/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentConditionException;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.condition.AgentCondition;
import com.cognos.asv.condition.ReportServerCondition;
import com.cognos.asv.condition.ReportSpecificationParser;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetParser;
import com.cognos.asv.resultset.ResultSetProcessed;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.io.InputStream;

public class TransientAgentCondition
extends AgentCondition {
    private String m_reportSpecification;
    private AsyncConversation m_conversation;

    public TransientAgentCondition(BaseAgent agent, String reportSpecification) {
        super(agent);
        if (reportSpecification == null) {
            throw new IllegalArgumentException("specification cannot be null");
        }
        this.m_reportSpecification = reportSpecification;
        this.m_conversation = new AsyncConversation();
    }

    @Override
    public synchronized void cancel() {
        this.m_conversation.cancel();
    }

    @Override
    public void run() throws AgentConditionException {
        try {
            this.doRun();
        }
        catch (AgentConditionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CONDITION_INVALID, new Object[]{e});
        }
    }

    private void doRun() throws LocalizableException, Exception {
        InputStream attachmentPartStream = null;
        try {
            attachmentPartStream = this.evaluateCondition();
            if (null != attachmentPartStream) {
                ResultSet rs = this.createResultSet(attachmentPartStream);
                ResultSetProcessed p_rs = new ResultSetProcessed(null, rs, this.getAgent().getEventKey());
                this.getAgent().setResultSet(p_rs);
            }
        }
        catch (Exception e1) {
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e1});
        }
        finally {
            if (attachmentPartStream != null) {
                attachmentPartStream.close();
            }
        }
    }

    private InputStream evaluateCondition() throws LocalizableException {
        InputStream result = null;
        Option[] options = ResolveOptionsUtil.resolveConditionOptions(this.getAgent());
        try {
            String tempObjectLocation = CRNProperties.getInstance().getProperty("temporaryObjectLocation");
            options = OptionUtils.addTemporaryObjectLocationRunOption((Option[])options, (String)tempObjectLocation);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)e));
        }
        ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this.getAgent(), false);
        ReportServerCondition rsvpCondition = new ReportServerCondition(this.m_conversation, this.getAgent(), options, parameters);
        result = rsvpCondition.runSpecification(this.m_reportSpecification);
        try {
            ReportSpecificationParser reportParser = new ReportSpecificationParser(this.m_reportSpecification);
            this.getAgent().setSortTopics(reportParser.getSortTopics());
        }
        catch (AgentServiceException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)e);
        }
        return result;
    }

    protected ResultSet createResultSet(InputStream attachmentStream) {
        ResultSetParser parser = new ResultSetParser(LocaleUtil.getLocale((String)this.getAgent().getHeaders().getUserPreferenceContentLocale()));
        return parser.parse(attachmentStream);
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        if (ObjectModelUtil.compareSeverity((SeverityEnum)validateResult.getValidationSeverity(), (SeverityEnum)SeverityEnum.warn) <= 0) {
            try {
                this.doRun();
            }
            catch (SDKClientException sdke) {
                String[] messages = sdke.getMessages();
                for (int i = 0; i < messages.length; ++i) {
                    validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_CONDITION_INVALID, new Object[]{messages[i]}, SeverityEnum.warn));
                }
            }
            catch (LocalizableException e) {
                validateResult.addValidationMessage(new I18NMessage(e));
            }
            catch (Throwable e) {
                validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_CONDITION_INVALID, new Object[]{e.getLocalizedMessage()}, SeverityEnum.warn));
            }
        }
    }
}

