/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.history;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AgentOutputHotList;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.HistoryDetailAgentService;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.MonitorServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.HistoryUpdateTrustedChecker;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.TimeUtils;
import java.util.Date;
import java.util.Locale;

public class AgentHistoryDetail {
    private SearchPathSingleObject m_historyPath;
    private String m_eventID = null;
    private JobBiBusHeaders m_headers;
    private boolean m_useTrusted = false;

    public AgentHistoryDetail(BaseStepObject stepObject) {
        AsynchOptionStringArray contextIDs = this.getRunContextID(stepObject);
        if (contextIDs.getValue().length > 0) {
            this.m_eventID = contextIDs.getValue()[contextIDs.getValue().length - 1];
        }
        this.m_historyPath = this.getHistoryLocation(stepObject);
        this.m_headers = stepObject.getHeaders();
    }

    public AgentHistoryDetail(BaseAgent agent) {
        AsynchOptionSearchPathSingleObject historyLocation = agent.getHistoryLocation();
        if (historyLocation != null) {
            this.m_historyPath = historyLocation.getValue();
        }
        if (this.m_historyPath == null) {
            AsynchOptionStringArray contextIDs = agent.getRunContextID();
            this.m_eventID = contextIDs.getValue()[contextIDs.getValue().length - 1];
        }
        this.m_headers = agent.getHeaders();
    }

    public SearchPathSingleObject getHistoryLocation(BaseStepObject stepObject) {
        AsynchOption historyOption = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])stepObject.getSubmitOptions(), (Object)AsynchOptionEnum.historyLocation);
        return historyOption instanceof AsynchOptionSearchPathSingleObject ? ((AsynchOptionSearchPathSingleObject)historyOption).getValue() : null;
    }

    public AsynchOptionStringArray getRunContextID(BaseStepObject stepObject) {
        AsynchOption contextIDOption = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])stepObject.getSubmitOptions(), (Object)AsynchOptionEnum.runContext);
        return contextIDOption instanceof AsynchOptionStringArray ? (AsynchOptionStringArray)contextIDOption : null;
    }

    public void addOutputDetail(AgentOutputHotList hotlist) throws AgentServiceException {
        HistoryDetailAgentService hdas = this.buildDetail(hotlist);
        this.addBaseClasses(new BaseClass[]{hdas});
    }

    public void addMessage(I18NCode code, Object[] params, SeverityEnum severityEnum) throws AgentServiceException {
        this.addBaseClasses(new BaseClass[]{this.makeDetail(code, params, severityEnum)});
    }

    public void addMessages(I18NMessage[] messages) throws AgentServiceException {
        if (messages == null || messages.length == 0) {
            return;
        }
        BaseClass[] details = new BaseClass[messages.length];
        for (int i = 0; i < messages.length; ++i) {
            I18NMessage message = messages[i];
            details[i] = this.makeDetail(message.getCode(), message.getParams(), message.getSeverity());
        }
        this.addBaseClasses(details);
    }

    private HistoryDetail makeDetail(I18NCode code, Object[] params, SeverityEnum severityEnum) {
        HistoryDetail detail = new HistoryDetail();
        Locale locale = this.m_headers.getProductLocale();
        String msg = I18NUtil.getMessage((I18NCode)code, (Object[])params, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
        StringProp sp = new StringProp();
        sp.setValue(msg);
        detail.setDetail(sp);
        Date date = new Date();
        DateTimeProp timeProp = new DateTimeProp();
        timeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)date));
        detail.setDetailTime(timeProp);
        SeverityEnumProp severity = new SeverityEnumProp();
        severity.setValue(severityEnum);
        detail.setSeverity(severity);
        return detail;
    }

    private HistoryDetailAgentService buildDetail(AgentOutputHotList hotlist) {
        HistoryDetailAgentService hdas = new HistoryDetailAgentService();
        Date date = new Date();
        DateTimeProp detailTimeProp = new DateTimeProp();
        detailTimeProp.setValue(TimeUtils.dateToUTCJavaCalendar((Date)date));
        hdas.setDetailTime(detailTimeProp);
        SeverityEnumProp sevProp = new SeverityEnumProp();
        sevProp.setValue(SeverityEnum.info);
        hdas.setSeverity(sevProp);
        Nil nil = new Nil();
        nil.setName(hotlist.getName());
        nil.setSearchPath(hotlist.getSearchPath());
        nil.setStoreID(hotlist.getStoreID());
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        BaseClass[] baseClasses = new BaseClass[]{nil};
        bcap.setValue(baseClasses);
        hdas.setOutput(bcap);
        return hdas;
    }

    private void addBaseClasses(BaseClass[] classes) throws AgentServiceException {
        MonitorServiceClientPort port = null;
        try {
            if (this.m_eventID != null) {
                port = Client.instance().getMonitorServiceClient(this.m_headers);
                port.add(this.m_eventID, classes, null, null);
            } else if (this.m_historyPath != null) {
                port = Client.instance().getContentManagerServiceClient(this.m_headers);
                String historySearchPath = this.m_historyPath.get_value();
                HistoryUpdateTrustedChecker checker = new HistoryUpdateTrustedChecker(this.m_headers.getBiBusHeader());
                if (!this.m_useTrusted) {
                    this.m_useTrusted = checker.determineTrustedFlagState(historySearchPath);
                }
                if (this.m_useTrusted) {
                    port.signNextRequest("ASV");
                    ((ContentManagerServiceClientPort)port).add(new SearchPathSingleObject(historySearchPath), classes, new AddOptions());
                } else {
                    ((ContentManagerServiceClientPort)port).add(new SearchPathSingleObject(historySearchPath), classes, new AddOptions());
                }
            }
        }
        catch (SDKClientException e) {
            String location = this.m_eventID != null ? this.m_eventID : this.m_historyPath.get_value();
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Error adding history detail; path [" + location + "], useTrusted [" + this.m_useTrusted + "].");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (LocalizableException)((Object)e));
            throw new AgentServiceException(I18NCode.MSG_ERROR_ADD_HISTORY_DETAIL, (Object[])new String[]{port.getPortName(), location}, e);
        }
        catch (EMFSecurityException e) {
            String location = this.m_eventID != null ? this.m_eventID : this.m_historyPath.get_value();
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Security Error adding history detail; path [" + location + "], useTrusted [" + this.m_useTrusted + "].");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(e.getLocalizedMessage());
            throw new AgentServiceException(I18NCode.MSG_ERROR_ADD_HISTORY_DETAIL, (Object[])new String[]{port.getPortName(), location}, e);
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
    }
}

