/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.parameters;

import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.Parameter;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SourceParametersHolder {
    private List m_param = new ArrayList();
    private List m_paramValue = new ArrayList();
    private int m_pointer = 0;
    private int MAX_NUM_OF_ITEMS = 1000;

    SourceParametersHolder() {
    }

    void addParameters(Parameter param, ParameterValue paramValue) {
        this.m_param.add(param);
        this.m_paramValue.add(paramValue);
    }

    ParameterValue[] getParametersValue() {
        return this.m_paramValue.toArray(new ParameterValue[this.m_paramValue.size()]);
    }

    BaseParameter[] getParameters() {
        return this.m_param.toArray(new BaseParameter[this.m_param.size()]);
    }

    boolean hasNext() {
        return ((ParameterValue)this.m_paramValue.get(0)).getValue().length > this.m_pointer;
    }

    void reset() {
        this.m_pointer = 0;
    }

    ParameterValue[] getNext() {
        return this.getNext(this.MAX_NUM_OF_ITEMS);
    }

    private ParameterValue[] getNext(int numOfItems) {
        ParameterValue[] paramValues = this.getParametersValue();
        ArrayList<ParameterValue> result = new ArrayList<ParameterValue>();
        int nextEndIndex = this.m_pointer + numOfItems;
        for (int i = 0; i < paramValues.length; ++i) {
            ParmValueItem[] parmValueArray = paramValues[i].getValue();
            if (nextEndIndex > parmValueArray.length) {
                nextEndIndex = parmValueArray.length;
            }
            List<ParmValueItem> parmValuesList = Arrays.asList(parmValueArray);
            parmValuesList = parmValuesList.subList(this.m_pointer, nextEndIndex);
            ParameterValue paramValue = new ParameterValue();
            paramValue.setName(paramValues[i].getName());
            paramValue.setValue(parmValuesList.toArray(new ParmValueItem[parmValuesList.size()]));
            result.add(paramValue);
        }
        this.m_pointer += numOfItems;
        return result.toArray(new ParameterValue[result.size()]);
    }
}

