/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.parameters;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.agent.AgentView;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.formatters.XMLEncodeFormatter;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.parameters.MissingParameterHandler;
import com.cognos.asv.parameters.SourceParametersHolder;
import com.cognos.asv.parameters.TaskParameterInfo;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetDistinctTopicFiltered;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AgentDefinitionView;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailDrillThroughRequest;
import com.cognos.developer.schemas.bibus._3.AsynchDetailParameterValues;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignment;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignmentArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Parameter;
import com.cognos.developer.schemas.bibus._3.ParameterAssignmentDataItem;
import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.ParameterDataTypeEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportServiceDrillThroughSpecification;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.HistoryTopicsEnum;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class TaskParamGenerator {
    public TaskParameterInfo makeParameterInfo(AgentTask callingTask, ResultSet agentResultSet, String targetSearchPath) throws AgentServiceException {
        TaskParameterInfo tpi = new TaskParameterInfo();
        tpi.setTargetParameters(this.getTargetParameters(callingTask, agentResultSet));
        ParameterValue[] parameterValues = this.makeParameters(callingTask, tpi, agentResultSet, targetSearchPath);
        tpi.setParameterValues(parameterValues);
        MissingParameterHandler mph = new MissingParameterHandler(new ValidationResultHandler(null), tpi.getTargetParameters());
        mph.getMissingParameters(callingTask, tpi.getTargetParameters(), tpi.getParameterValues(), agentResultSet);
        tpi.setMissingParameters(mph.m_missingParams.toArray(new BaseParameter[0]));
        return tpi;
    }

    private ParameterValue[] makeParameters(AgentTask callingTask, TaskParameterInfo tpi, ResultSet agentResultSet, String targetSearchPath) throws AgentServiceException {
        BaseParameter[] targetParameters = tpi.getTargetParameters();
        BaseParameterAssignment[] assignments = null;
        ParameterValue[] defaults = null;
        ParameterValue[] parameterValues = null;
        SearchPathSingleObject[] modelPaths = null;
        if (callingTask != null) {
            ParameterValueArrayProp pvap;
            BaseParameterAssignmentArrayProp bpaap = callingTask.getAgentTaskDefinition().getParameterAssignments();
            if (bpaap != null) {
                assignments = bpaap.getValue();
            }
            if ((pvap = callingTask.getAgentTaskDefinition().getParameters()) != null) {
                defaults = pvap.getValue();
            }
        }
        if (assignments == null || assignments.length == 0) {
            tpi.setAssignments(false);
        } else {
            tpi.setAssignments(true);
        }
        if (assignments == null || assignments.length == 0 || agentResultSet.isEmpty()) {
            return defaults;
        }
        HashMap<String, ResultSetTopic> functionTopicsByName = new HashMap<String, ResultSetTopic>();
        HashMap<String, String> historyTopicsByName = new HashMap<String, String>();
        String topic_string = "";
        for (int i = 0; assignments != null && i < assignments.length; ++i) {
            if (!(assignments[i] instanceof ParameterAssignmentDataItem)) continue;
            ParameterAssignmentDataItem pidi = (ParameterAssignmentDataItem)assignments[i];
            String data_item_name = pidi.getDataItemName().get_value();
            ResultSetLinePieces rslp = new ResultSetLinePieces(data_item_name, new IdentityFormatter());
            Set topicSet = rslp.getTopics();
            if (topicSet.iterator().hasNext()) {
                ResultSetTopic rsTopic = (ResultSetTopic)topicSet.iterator().next();
                topic_string = topic_string + rsTopic.toString();
                if (rsTopic.normal()) continue;
                functionTopicsByName.put(rsTopic.reference(), rsTopic);
                continue;
            }
            if (!rslp.isConstant()) continue;
            String historyTopic = (String)rslp.get(0);
            historyTopicsByName.put(pidi.getParameterName(), historyTopic);
        }
        if (topic_string.length() > 0) {
            agentResultSet = new ResultSetDistinctTopicFiltered(agentResultSet, topic_string);
        }
        Iterator topicNameIt = agentResultSet.getMetadata();
        int totalColumnsUsedAsParameters = agentResultSet.numQueryItems() - 1;
        Set keyset = (Set)agentResultSet.asCollection(new TreeSet());
        int numRowsReturned = keyset.size();
        boolean olapTarget = this.isOlapTarget(targetParameters);
        SourceParametersHolder holder = new SourceParametersHolder();
        while (topicNameIt.hasNext() && totalColumnsUsedAsParameters > 0 && topic_string.length() > 0) {
            MetadataItem metadataItem = (MetadataItem)topicNameIt.next();
            if (metadataItem.name().compareToIgnoreCase(ResultSet.STATUS_TOPIC.name()) == 0) continue;
            ResultSetTopic currentTopic = metadataItem.makeTopic();
            String caption = metadataItem.caption();
            ParameterDataTypeEnum typeEnum = this.getSourceContextType(olapTarget, metadataItem);
            this.createSourceParams(currentTopic, metadataItem.expression(), caption, typeEnum, numRowsReturned, keyset, agentResultSet, callingTask, holder, false, olapTarget);
            if (!functionTopicsByName.containsKey(currentTopic.reference())) continue;
            currentTopic = (ResultSetTopic)functionTopicsByName.get(currentTopic.reference());
            this.createSourceParams(currentTopic, currentTopic.toString(), caption, typeEnum, numRowsReturned, keyset, agentResultSet, callingTask, holder, false, olapTarget);
        }
        for (String parameterName : historyTopicsByName.keySet()) {
            String historyTopic = (String)historyTopicsByName.get(parameterName);
            Locale locale = LocaleUtil.getLocale((String)callingTask.getHeaders().getUserPreferenceContentLocale());
            HistoryTopicsEnum topicType = HistoryTopicsEnum.getTypeEnum((String)historyTopic, (Locale)locale);
            ParameterDataTypeEnum typeEnum = ObjectModelUtil.getParameterType((String)topicType.getType());
            SourceParametersHolder historyHolder = this.createSourceParams(null, parameterName, topicType.getTopic(locale), typeEnum, numRowsReturned, null, null, callingTask, new SourceParametersHolder(), true, olapTarget);
            defaults = ResolveParametersUtil.mergeParameters(defaults, historyHolder.getParametersValue());
        }
        ParameterValue[] merged = null;
        if (holder.getParametersValue().length > 0) {
            parameterValues = this.getParameterValues(callingTask);
            parameterValues = this.trimParameterValues(parameterValues, assignments);
            modelPaths = this.getModelPaths(callingTask);
            while (holder.hasNext()) {
                ParameterValue[] m_param = holder.getNext();
                ParameterValue[] assignedParameters = new ParameterValue[]{};
                assignedParameters = targetSearchPath != null ? this.getParameterValuesByDrillThroughCall(callingTask, modelPaths, holder.getParameters(), m_param, assignments, targetParameters, parameterValues, targetSearchPath) : this.getMatchingParameterAssignmentValue(assignments, holder.getParametersValue());
                merged = ResolveParametersUtil.appendParameters(merged, assignedParameters);
            }
        }
        ParameterValue[] resolvedParameters = ResolveParametersUtil.mergeParameters(merged, defaults);
        return resolvedParameters;
    }

    private ParameterValue[] trimParameterValues(ParameterValue[] targetParameterValues, BaseParameterAssignment[] assignments) {
        HashSet<String> assignmentHashSet = new HashSet<String>();
        if (assignments != null) {
            for (int i = 0; i < assignments.length; ++i) {
                assignmentHashSet.add(((ParameterAssignmentDataItem)assignments[i]).getParameterName());
            }
        }
        ArrayList<ParameterValue> trimmedTargetParameterValues = new ArrayList<ParameterValue>();
        if (targetParameterValues != null) {
            for (int j = 0; j < targetParameterValues.length; ++j) {
                if (assignmentHashSet.contains(targetParameterValues[j].getName())) continue;
                trimmedTargetParameterValues.add(targetParameterValues[j]);
            }
        }
        return trimmedTargetParameterValues.toArray(new ParameterValue[0]);
    }

    private ParameterDataTypeEnum getSourceContextType(boolean isOlapTarget, MetadataItem mdi) {
        ParameterDataTypeEnum type = ObjectModelUtil.getParameterType((String)mdi.type());
        if (Boolean.valueOf(mdi.getMun()).booleanValue() && (isOlapTarget || this.useOlapSourceForRelational_573062())) {
            type = ParameterDataTypeEnum.memberUniqueName;
        }
        return type;
    }

    private boolean isOlapTarget(BaseParameter[] targetParameters) {
        ParameterDataTypeEnum type;
        boolean isOlapTarget = false;
        for (int i = 0; i < targetParameters.length && !(isOlapTarget = (type = targetParameters[i].getType()).equals((Object)ParameterDataTypeEnum.memberUniqueName)); ++i) {
        }
        return isOlapTarget;
    }

    private boolean useOlapSourceForRelational_573062() {
        boolean useOlap = true;
        try {
            String val = CRNProperties.getInstance().getProperty("olap.rel.drill");
            useOlap = Boolean.valueOf(val);
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        return useOlap;
    }

    private SourceParametersHolder createSourceParams(ResultSetTopic topic, String expression, String name, ParameterDataTypeEnum typeEnum, int numRowsReturned, Set keyset, ResultSet agentResultSet, AgentTask task, SourceParametersHolder holder, boolean isHistory, boolean olapTarget) {
        Parameter param = new Parameter();
        ParameterValue paramValue = new ParameterValue();
        this.initialiseParameterValues(param, paramValue, expression, name, typeEnum);
        ParmValueItem[] spvi = null;
        if (numRowsReturned > 0 && !isHistory) {
            spvi = this.getParameterValues(keyset, agentResultSet, topic, task, olapTarget);
        } else if (isHistory) {
            int rows = numRowsReturned > 0 ? numRowsReturned : 1;
            ArrayList<SimpleParmValueItem> historyValuesList = new ArrayList<SimpleParmValueItem>(rows);
            for (int i = 0; i < rows; ++i) {
                SimpleParmValueItem pvi = new SimpleParmValueItem();
                pvi.setDisplay(name);
                pvi.setInclusive(true);
                pvi.setUse(name);
                historyValuesList.add(pvi);
            }
            spvi = historyValuesList.toArray(new ParmValueItem[historyValuesList.size()]);
        }
        paramValue.setValue(spvi);
        holder.addParameters(param, paramValue);
        return holder;
    }

    private ParmValueItem[] getParameterValues(Set rsKeyset, ResultSet agentResultSet, ResultSetTopic currentTopic, AgentTask task, boolean olapTarget) {
        Iterator keysetIt = rsKeyset.iterator();
        ArrayList<SimpleParmValueItem> spvis = new ArrayList<SimpleParmValueItem>();
        while (keysetIt.hasNext()) {
            ResultSetKey key = (ResultSetKey)keysetIt.next();
            ResultSetDataValue rsdv = agentResultSet.getDataValue(key, currentTopic);
            String use = "";
            if (currentTopic.caption()) {
                use = rsdv.getPresentationValue();
            } else if (olapTarget || this.useOlapSourceForRelational_573062()) {
                String drillThroughValue = task.getDrillThroughValue(rsdv, currentTopic);
                use = drillThroughValue == null || "".equals(drillThroughValue) ? rsdv.getRawValue() : drillThroughValue;
                if (use == null || use.equals("")) {
                    use = rsdv.getPresentationValue();
                }
            } else {
                use = rsdv.getRawValue();
            }
            SimpleParmValueItem pvi = new SimpleParmValueItem();
            pvi.setDisplay(rsdv.getPresentationValue());
            pvi.setInclusive(true);
            pvi.setUse(use);
            spvis.add(pvi);
        }
        return spvis.toArray(new ParmValueItem[spvis.size()]);
    }

    private void initialiseParameterValues(Parameter param, ParameterValue value, String expression, String caption, ParameterDataTypeEnum type) {
        value.setName(expression);
        ParameterCapabilityEnum[] pce = new ParameterCapabilityEnum[]{ParameterCapabilityEnum.discreteValue, ParameterCapabilityEnum.multivalued};
        param.setCapabilities(pce);
        MultilingualString[] ml = new MultilingualString[]{new MultilingualString()};
        ml[0].setLocale("en-us");
        ml[0].setValue(caption);
        param.setCaption(ml);
        param.setName(expression);
        param.setType(type);
    }

    private ParameterValue[] getMatchingParameterAssignmentValue(BaseParameterAssignment[] assignments, ParameterValue[] sourceParameterValues) {
        int i;
        ArrayList<ParameterValue> matchingParameterValues = new ArrayList<ParameterValue>();
        HashMap<String, ParameterValue> sourceParameterMap = new HashMap<String, ParameterValue>();
        for (i = 0; i < sourceParameterValues.length; ++i) {
            ParameterValue sourceParameterValue = sourceParameterValues[i];
            sourceParameterMap.put(sourceParameterValue.getName(), sourceParameterValue);
        }
        for (i = 0; i < assignments.length; ++i) {
            ParameterAssignmentDataItem parameterAssignment = (ParameterAssignmentDataItem)assignments[i];
            String dataItemName = parameterAssignment.getDataItemName().get_value();
            if (!sourceParameterMap.containsKey(dataItemName)) continue;
            ParameterValue pv = (ParameterValue)sourceParameterMap.get(dataItemName);
            ParameterValue newParameterValue = this.createParameterValue(parameterAssignment.getParameterName(), pv);
            matchingParameterValues.add(newParameterValue);
        }
        return matchingParameterValues.toArray(new ParameterValue[matchingParameterValues.size()]);
    }

    private ParameterValue createParameterValue(String parameterName, ParameterValue pv) {
        ParmValueItem[] value = pv.getValue();
        ParameterValue paramValue = new ParameterValue(parameterName, value);
        return paramValue;
    }

    private ParameterValue[] getParameterValuesByDrillThroughCall(AgentTask task, SearchPathSingleObject[] modelPaths, BaseParameter[] sourceParameters, ParameterValue[] sourceParameterValues, BaseParameterAssignment[] pa, BaseParameter[] targetParameters, ParameterValue[] parameterValues, String targetSearchPath) throws AgentServiceException {
        ParameterValue[] params = null;
        JobBiBusHeaders headers = task.getHeaders();
        BiBusHeader header = headers.getBiBusHeader();
        Tracking tracking = header.getTracking();
        tracking.setConversationContext(null);
        header.setTracking(tracking);
        headers.setBiBusHeader(header);
        BatchReportServiceClientPort reportService = Client.instance().getBatchReportServiceClient(headers);
        try {
            ParameterValue[] connectionParameterValues = ResolveParametersUtil.getConnectionParameters(task);
            parameterValues = ResolveParametersUtil.mergeParameters(connectionParameterValues, parameterValues);
            AsynchOptionInt doNotWait = new AsynchOptionInt();
            doNotWait.setName(AsynchOptionEnum.primaryWaitThreshold);
            doNotWait.setValue(0);
            Option[] options = new Option[]{doNotWait};
            ParameterValue[] matchedParameterValues = this.getMatchingParameterAssignmentValue(pa, sourceParameterValues);
            AsynchSpecification drillSpecification = this.generateDrillThroughSpecification(task, modelPaths, pa, targetSearchPath);
            matchedParameterValues = ResolveParametersUtil.mergeParameters(parameterValues, matchedParameterValues);
            AsynchReply reply = reportService.runSpecification(drillSpecification, matchedParameterValues, options);
            while (reply != null && (reply.getStatus().equals((Object)AsynchReplyStatusEnum.working) || reply.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking))) {
                reply = reportService.wait(reply.getPrimaryRequest(), null, null);
            }
            if (reply != null && reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete)) {
                params = this.getParamsFromDrillReply(reply, task);
            }
        }
        catch (EMFSecurityException cse) {
            AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)cse);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{cse.getLocalizedMessage()});
        }
        catch (SDKClientException sdke) {
            AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)sdke);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{sdke.getLocalizedMessage()});
        }
        finally {
            reportService.close();
        }
        return params;
    }

    private ParameterValue[] getParamsFromDrillReply(AsynchReply reply, AgentTask task) {
        ParameterValue[] params = null;
        boolean noDrillParams = false;
        boolean noParamValues = false;
        HashMap<String, ParameterValue> results = new HashMap<String, ParameterValue>();
        AsynchDetail[] ad = reply.getDetails();
        if (ad != null) {
            AsynchDetail asynchDetail;
            int i;
            for (i = 0; i < ad.length; ++i) {
                asynchDetail = ad[i];
                if (!(asynchDetail instanceof AsynchDetailDrillThroughRequest)) continue;
                params = ((AsynchDetailDrillThroughRequest)asynchDetail).getParameters();
                noDrillParams = this.addParams(task, params, results);
            }
            for (i = 0; i < ad.length; ++i) {
                asynchDetail = ad[i];
                if (!(asynchDetail instanceof AsynchDetailParameterValues)) continue;
                params = ((AsynchDetailParameterValues)ad[i]).getParameters();
                noParamValues = this.addParams(task, params, results);
            }
            if (noDrillParams && noParamValues) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_UNABLE_TO_DRILL, new Object[]{task.getBaseClass().getDefaultName().getValue()});
            }
        }
        ParameterValue[] values = results.values().toArray(new ParameterValue[results.values().size()]);
        return values;
    }

    private boolean addParams(AgentTask task, ParameterValue[] params, Map<String, ParameterValue> results) {
        boolean invalid = (params == null || params.length == 0) && task.getResultSet().numDataItems() > 0;
        for (int j = 0; !invalid && j < params.length; ++j) {
            ParameterValue pValue = params[j];
            if (results.containsKey(pValue.getName())) continue;
            results.put(pValue.getName(), pValue);
        }
        return invalid;
    }

    private AsynchSpecification generateDrillThroughSpecification(AgentTask task, SearchPathSingleObject[] modelPaths, BaseParameterAssignment[] pa, String targetSearchPath) {
        ReportServiceDrillThroughSpecification specification = new ReportServiceDrillThroughSpecification();
        Specification spec = new Specification();
        XMLEncodeFormatter xmlEncodeFormatter = new XMLEncodeFormatter();
        StringBuffer modelSearchPath = new StringBuffer();
        for (int i = 0; i < modelPaths.length; ++i) {
            modelSearchPath.append("<dts:searchPath>");
            String modelPath = xmlEncodeFormatter.format(modelPaths[i].get_value());
            modelSearchPath.append(modelPath);
            modelSearchPath.append("</dts:searchPath>");
        }
        StringBuffer parameterAssignment = new StringBuffer();
        for (int i = 0; i < pa.length; ++i) {
            ParameterAssignmentDataItem targetParameter = (ParameterAssignmentDataItem)pa[i];
            parameterAssignment.append("<dts:parameterAssignment>");
            parameterAssignment.append("<dts:parameterName>" + targetParameter.getParameterName() + "</dts:parameterName>");
            String dataItemName = xmlEncodeFormatter.format(targetParameter.getDataItemName().get_value());
            parameterAssignment.append("<dts:item>" + dataItemName + "</dts:item>");
            parameterAssignment.append("</dts:parameterAssignment>");
        }
        String encodedReportTarget = xmlEncodeFormatter.format(targetSearchPath);
        String specXML = "<dts:drillThroughSpecification xmlns:dts=\"http://developer.cognos.com/schemas/drillThroughSpecification/1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><dts:modelSearchPaths>" + modelSearchPath.toString() + "</dts:modelSearchPaths>" + "<dts:parameterAssignments>" + parameterAssignment.toString() + "</dts:parameterAssignments>" + "<dts:reportTarget>" + "<dts:action>http://developer.cognos.com/schemas/bibus/3/constants/drillThroughActionEnum#default</dts:action>" + "<dts:targetSearchPath>" + encodedReportTarget + "</dts:targetSearchPath>" + "</dts:reportTarget>" + "</dts:drillThroughSpecification>";
        spec.set_value(specXML);
        specification.setValue(spec);
        return specification;
    }

    private BaseParameter[] getTargetParameters(AgentTask callingTask, ResultSet agentResultSet) throws AgentServiceException {
        BaseParameter[] targetParameters = null;
        BaseAgentTaskTarget target = callingTask.getTarget();
        targetParameters = target.getTargetParameters(agentResultSet);
        return targetParameters;
    }

    private ParameterValue[] getParameterValues(AgentTask callingTask) throws AgentServiceException {
        ParameterValue[] targetParameterValues = null;
        BaseAgentTaskTarget target = callingTask.getTarget();
        targetParameterValues = target.getParameters();
        return targetParameterValues;
    }

    private SearchPathSingleObject[] getModelPaths(AgentTask callingTask) throws AgentServiceException {
        JobBiBusHeaders headers = callingTask.getHeaders();
        BiBusHeader header = headers.getBiBusHeader();
        Tracking tracking = header.getTracking();
        tracking.setConversationContext(null);
        header.setTracking(tracking);
        headers.setBiBusHeader(header);
        BaseAgent agent = (BaseAgent)callingTask.getParent();
        ArrayList paths = new ArrayList();
        this.addReportSearchPath(agent.getBaseClass(), paths);
        ArrayList modelPaths = new ArrayList();
        if (paths.size() > 0) {
            Object modelPath = null;
            ContentManagerServiceClientPort cm = Client.instance().getContentManagerServiceClient(headers);
            try {
                QueryRequest[] requests = new QueryRequest[paths.size()];
                for (int i = 0; i < paths.size(); ++i) {
                    SearchPathSingleObject sp = (SearchPathSingleObject)paths.get(i);
                    if (sp == null) continue;
                    requests[i] = new QueryRequest();
                    requests[i].setProperties(new PropEnum[]{PropEnum.metadataModel, PropEnum.metadataModelPackage, PropEnum.base});
                    RefProp taskObjectRefs = new RefProp();
                    taskObjectRefs.setRefPropName(PropEnum.base);
                    taskObjectRefs.setProperties(new PropEnum[]{PropEnum.metadataModel, PropEnum.metadataModelPackage});
                    QueryOptions taskDefOpt = new QueryOptions();
                    taskDefOpt.setRefProps(new RefProp[]{taskObjectRefs});
                    requests[i].setOptions(taskDefOpt);
                    requests[i].setSearch(sp.get_value());
                }
                this.parseReplies(modelPaths, cm.queryMultiple(requests));
            }
            catch (EMFSecurityException cse) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_MODEL, new String[]{modelPath != null ? modelPath.get_value() : ""});
            }
            catch (SDKClientException sdke) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_MODEL, new String[]{modelPath != null ? modelPath.get_value() : ""});
            }
            finally {
                cm.close();
            }
        } else if (agent instanceof Agent) {
            this.addModelPath(modelPaths, ((Agent)agent).getConditionReport());
        } else if (agent instanceof AgentView) {
            this.addModelPath(modelPaths, ((AgentView)agent).getBaseAgent().getConditionReport());
        }
        return modelPaths.toArray(new SearchPathSingleObject[0]);
    }

    private void parseReplies(ArrayList modelPaths, QueryReply[] replies) {
        BaseClass[] bc = null;
        for (int i = 0; replies != null && i < replies.length; ++i) {
            bc = replies[i].getQueryResult();
            this.parseBases(modelPaths, bc);
        }
    }

    private void parseBases(ArrayList modelPaths, BaseClass[] bc) {
        if (bc != null && bc.length >= 1 && bc[0] != null) {
            ReportView rv;
            BaseClassArrayProp props;
            if (bc[0] instanceof Report) {
                this.addModelPath(modelPaths, (AuthoredReport)bc[0]);
            } else if (bc[0] instanceof ReportView && (props = (rv = (ReportView)bc[0]).getBase()) != null) {
                BaseClass[] viewBases = props.getValue();
                this.parseBases(modelPaths, viewBases);
            }
        }
    }

    private void addModelPath(ArrayList modelPaths, AuthoredReport report) {
        BaseClass model = ObjectModelUtil.getBaseClass((BaseClassArrayProp)report.getMetadataModel(), (int)0);
        SearchPathSingleObject modelPath = null;
        if (model == null) {
            BaseClass modelPackage = ObjectModelUtil.getBaseClass((BaseClassArrayProp)report.getMetadataModelPackage(), (int)0);
            if (modelPackage != null && modelPackage.getSearchPath().getValue() != null) {
                String searchPath = modelPackage.getSearchPath().getValue();
                String modelSearchPath = searchPath + "/model[last()]";
                modelPath = ObjectModelUtil.makeSearchPath((String)modelSearchPath);
            }
        } else if (model != null && model.getSearchPath() != null) {
            modelPath = ObjectModelUtil.makeSearchPath((String)model.getSearchPath().getValue());
        }
        if (modelPath != null) {
            modelPaths.add(modelPath);
        }
    }

    private SearchPathSingleObject addReportSearchPath(BaseClass base, List paths) {
        SearchPathSingleObject spso = null;
        if (base instanceof AgentDefinition && !"".equals(base.getSearchPath().getValue())) {
            spso = ObjectModelUtil.makeSearPathSingleObject((String)(base.getSearchPath().getValue() + "/report"));
        } else if (base instanceof AgentDefinitionView) {
            String viewPath;
            BaseClass viewBase = ObjectModelUtil.getBaseClass((BaseClassArrayProp)((AgentDefinitionView)base).getBase(), (int)0);
            String string = viewPath = viewBase != null ? viewBase.getSearchPath().getValue() : "";
            if (!"".equals(viewPath)) {
                spso = ObjectModelUtil.makeSearPathSingleObject((String)(viewPath + "/report"));
            }
        } else if (base instanceof BaseReport && !"".equals(base.getSearchPath().getValue())) {
            spso = ObjectModelUtil.makeSearPathSingleObject((String)base.getSearchPath().getValue());
        }
        if (spso != null) {
            paths.add(spso);
        }
        return spso;
    }

    private SearchPathSingleObject addReportSearchPath(BaseClassArrayProp bcap, List paths) {
        BaseClass base = ObjectModelUtil.getBaseClass((BaseClassArrayProp)bcap, (int)0);
        return this.addReportSearchPath(base, paths);
    }
}

