/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.reportTemplates;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.ReportSpecProtectionSession;
import com.cognos.accman.jcam.crypto.SecureStateSession;
import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportServiceReportSpecification;
import com.cognos.developer.schemas.bibus._3.RunOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class TemplateBuilder {
    final I18NCode errCode = AsvI18NCode.MSG_ASV_TEMPLATE_BUILD_ERROR;
    private CAMFactory m_camf = null;
    private static TemplateBuilder m_builder = new TemplateBuilder();

    public static TemplateBuilder instance() {
        return m_builder;
    }

    private TemplateBuilder() {
    }

    public String build(String templatePath, JobBiBusHeaders headers) throws AgentServiceException {
        String report = null;
        try {
            CAMFactory camFactory = this.getCamFactory();
            String templateSpec = this.getTemplateSpec(templatePath);
            if (this.canSign(camFactory, headers)) {
                templateSpec = this.signSpecification(camFactory, templateSpec);
            }
            report = this.runTemplateSpec(templateSpec, headers);
            return report;
        }
        catch (CAMCryptoException ex) {
            throw new AgentServiceException(this.errCode, new Object[]{ex.getMessage()});
        }
        catch (IOException ex) {
            throw new AgentServiceException(this.errCode, new Object[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTemplateSpec(String templatePath) {
        InputStream is = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        StringBuffer buff = new StringBuffer();
        try {
            is = this.getClass().getResourceAsStream(templatePath);
            ir = new InputStreamReader(is, "UTF-8");
            br = new BufferedReader(ir);
            String line = null;
            try {
                while ((line = br.readLine()) != null) {
                    buff.append(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buff.toString();
    }

    private synchronized CAMFactory getCamFactory() throws CAMCryptoException {
        if (this.m_camf == null) {
            this.m_camf = new CAMFactory();
            byte[] initString = "<initializeDocument><serviceID>ASV</serviceID></initializeDocument>".getBytes();
            this.m_camf.initialize(initString);
        }
        return this.m_camf;
    }

    private String runTemplateSpec(String templateSpec, JobBiBusHeaders headers) throws AgentServiceException {
        BiBusHeader header = BiBusUtilities.getDeepCopy((BiBusHeader)headers.getBiBusHeader());
        Option[] options = new Option[4];
        RunOptionStringArray formatRunOption = new RunOptionStringArray();
        formatRunOption.setName(RunOptionEnum.outputFormat);
        String[] formats = new String[]{"XHTML"};
        formatRunOption.setValue(formats);
        options[0] = formatRunOption;
        RunOptionAnyURI xslOption = new RunOptionAnyURI();
        xslOption.setName(RunOptionEnum.xslURL);
        xslOption.setValue("null.xsl");
        options[1] = xslOption;
        RunOptionInt verticalElementsValue = new RunOptionInt();
        verticalElementsValue.setName(RunOptionEnum.verticalElements);
        verticalElementsValue.setValue(Integer.MAX_VALUE);
        options[2] = verticalElementsValue;
        RunOptionBoolean promptElementsValue = new RunOptionBoolean();
        promptElementsValue.setName(RunOptionEnum.prompt);
        promptElementsValue.setValue(false);
        options[3] = promptElementsValue;
        try {
            String tempObjectLocation = CRNProperties.getInstance().getProperty("temporaryObjectLocation");
            options = OptionUtils.addTemporaryObjectLocationRunOption((Option[])options, (String)tempObjectLocation);
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)e));
        }
        ParameterValue[] parameters = null;
        AsyncConversation conversation = new AsyncConversation();
        BatchReportServiceClientPort servicePort = null;
        AsynchReply reply = null;
        ReportServiceReportSpecification reportSpec = new ReportServiceReportSpecification();
        Specification spec = new Specification();
        spec.set_value(templateSpec);
        reportSpec.setValue(spec);
        String[] reportPages = null;
        try {
            int i;
            servicePort = Client.instance().getBatchReportServiceClient(new JobBiBusHeaders(header));
            reply = servicePort.runSpecification((AsynchSpecification)reportSpec, parameters, options);
            reply = conversation.doWaitConversation((ServiceAPI)servicePort, reply);
            AsynchDetail[] details = reply.getDetails();
            AsynchDetailReportStatus detailReportStatus = null;
            AsynchDetailReportOutput detailReportOutput = null;
            if (details != null) {
                for (i = 0; i < details.length && detailReportStatus == null; ++i) {
                    if (!(details[i] instanceof AsynchDetailReportStatus)) continue;
                    detailReportStatus = (AsynchDetailReportStatus)details[i];
                }
            }
            if (detailReportStatus != null && detailReportStatus.getStatus().equals((Object)AsynchDetailReportStatusEnum.responseReady)) {
                reply = servicePort.getOutput(reply.getPrimaryRequest(), parameters, options);
                details = reply.getDetails();
            }
            if (details != null) {
                for (i = 0; i < details.length && detailReportOutput == null; ++i) {
                    if (!(details[i] instanceof AsynchDetailReportOutput)) continue;
                    detailReportOutput = (AsynchDetailReportOutput)details[i];
                }
            }
            if (detailReportOutput != null) {
                reportPages = detailReportOutput.getOutputPages();
            }
            if (reply.getStatus().equals((Object)AsynchReplyStatusEnum.complete)) {
                servicePort.release(reply.getPrimaryRequest());
            }
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_TEMPLATE_BUILD_ERROR, new Object[]{e.getMessage()});
        }
        catch (SDKClientException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_TEMPLATE_BUILD_ERROR, new Object[]{e.getMessage()});
        }
        catch (LocalizableException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_TEMPLATE_BUILD_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            if (servicePort != null) {
                servicePort.close();
            }
        }
        return reportPages[0];
    }

    private boolean canSign(CAMFactory camFactory, JobBiBusHeaders headers) throws IOException, CAMCryptoException {
        BiBusHeader busHeaders;
        String encoding = "UTF-8";
        boolean canSign = false;
        String secureState = null;
        String passport = null;
        if (headers != null && (busHeaders = headers.getBiBusHeader()) != null) {
            CAMPassport camPassport;
            CAM cam;
            CAF caf = busHeaders.getCAF();
            if (caf != null) {
                secureState = caf.getSecureState();
            }
            if ((cam = busHeaders.getCAM()) != null && (camPassport = cam.getCAMPassport()) != null) {
                passport = camPassport.getId();
            }
        }
        if (passport != null && secureState != null) {
            SecureStateSession session = null;
            byte[] secureStateBytes = secureState.getBytes("UTF-8");
            byte[] passportBytes = passport.getBytes("UTF-8");
            session = camFactory.createSecureStateSession(passportBytes, secureStateBytes);
            if (session != null && session.verifySecureStateToken()) {
                canSign = session.getRequestExternal();
            }
        }
        return canSign;
    }

    private String signSpecification(CAMFactory camFactory, String specification) throws CAMCryptoException, AgentServiceException {
        String signedSpec = specification;
        ReportSpecProtectionSession rsps = null;
        rsps = camFactory.createReportSpecProtectionSession();
        try {
            rsps.setSpec(specification.getBytes("UTF-8"));
            byte[] protectedSpec = null;
            protectedSpec = rsps.protectData();
            signedSpec = new String(protectedSpec, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new AgentServiceException(this.errCode, new Object[]{ex.getMessage()});
        }
        return signedSpec;
    }
}

