/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetDrillValue;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.developer.schemas.bibus._3.ParameterDataTypeEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.axis.types.Time;
import org.apache.axis.types.UnsignedByte;
import org.apache.axis.types.UnsignedInt;
import org.apache.axis.types.UnsignedLong;
import org.apache.axis.types.UnsignedShort;

public class ResultSetDataValue {
    private String m_presentationValue;
    private String m_rawValue;
    private ResultSetDrillValue[] m_drillValues;
    private Locale m_locale;
    private boolean m_prompting;

    public ResultSetDataValue() {
        this.m_presentationValue = null;
        this.m_rawValue = null;
    }

    public ResultSetDataValue(String rawValue, String presentationValue) {
        this.m_presentationValue = presentationValue;
        this.m_rawValue = rawValue == null || rawValue.length() <= 0 ? this.m_presentationValue : rawValue;
    }

    public boolean isNull() {
        return this.m_rawValue == null;
    }

    public boolean isEmpty() {
        boolean isEmpty = this.m_presentationValue != null && this.m_presentationValue.trim().length() <= 0;
        isEmpty = isEmpty && this.m_rawValue != null && this.m_rawValue.trim().length() <= 0;
        return isEmpty;
    }

    public String getNullMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
    }

    public String getPresentationValue() {
        return this.m_presentationValue;
    }

    public String getRawValue() {
        return this.m_rawValue;
    }

    public String getTopicValue(ResultSetTypeEnum type) {
        if (this.isNull()) {
            return this.getNullMessage(this.m_locale);
        }
        if (ResultSetTypeEnum.HTML.equals(type)) {
            return this.m_presentationValue == null || "".equals(this.m_presentationValue) ? this.m_rawValue : this.m_presentationValue;
        }
        return this.m_rawValue;
    }

    public String getTopicValue() {
        return this.getTopicValue(ResultSetTypeEnum.XML);
    }

    public String getMunDrillValue(String drillPath, String parameter) {
        for (int i = 0; this.m_drillValues != null && i < this.m_drillValues.length; ++i) {
            if (!this.m_drillValues[i].matches(drillPath, parameter, ParameterDataTypeEnum.memberUniqueName)) continue;
            return this.m_drillValues[i].getDrillValue();
        }
        return null;
    }

    public String getDrillValue(String drillPath, String parameter) {
        for (int i = 0; this.m_drillValues != null && i < this.m_drillValues.length; ++i) {
            if (!this.m_drillValues[i].matches(drillPath, parameter)) continue;
            return this.m_drillValues[i].getDrillValue();
        }
        return null;
    }

    void update(ResultSetDataValue rhs) {
        if (rhs.m_rawValue != null) {
            this.m_rawValue = rhs.m_rawValue;
        }
        if (rhs.m_presentationValue != null) {
            this.m_presentationValue = rhs.m_presentationValue;
        }
        if (rhs.m_drillValues != null) {
            this.m_drillValues = rhs.m_drillValues;
        }
        if (rhs.m_locale != null) {
            this.m_locale = rhs.m_locale;
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ResultSetDataValue) {
            ResultSetDataValue rsdv = (ResultSetDataValue)obj;
            if (this.isNull() && rsdv.isNull()) {
                result = true;
            } else if (this.isEmpty() && rsdv.isEmpty()) {
                result = true;
            } else if (!this.isNull() && this.m_presentationValue.equals(rsdv.getPresentationValue()) && this.m_rawValue.equals(rsdv.getRawValue())) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return !this.isNull() ? this.m_presentationValue.hashCode() : super.hashCode();
    }

    public ResultSetDrillValue[] getDrillValues() {
        return this.m_drillValues;
    }

    public void setDrillValues(ResultSetDrillValue[] drillValues) {
        this.m_drillValues = drillValues;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public boolean isPrompting() {
        return this.m_prompting;
    }

    public void setPrompting(boolean prompting) {
        this.m_prompting = prompting;
    }

    public Comparable getComparableValue(MetadataItem metadataItem) {
        Comparable ret_value = null;
        if (metadataItem != null) {
            String type = metadataItem.type();
            ret_value = this.getValue(this.getRawValue(), type);
        }
        return ret_value;
    }

    private Comparable getValue(String value, String type) {
        Object comparable = value;
        if (type != null && value != null && !value.equals("")) {
            if (type.compareToIgnoreCase("xs:string") == 0 || type.compareToIgnoreCase("xsdString") == 0) {
                comparable = value;
            } else if (type.compareToIgnoreCase("xs:int") == 0 || type.compareToIgnoreCase("xsdInt") == 0) {
                comparable = new Integer(value);
            } else if (type.compareToIgnoreCase("xs:float") == 0 || type.compareToIgnoreCase("xsdFloat") == 0) {
                comparable = new Float(value);
            } else if (type.compareToIgnoreCase("memberUniqueName") == 0 || type.compareToIgnoreCase("memberUniqueName") == 0) {
                comparable = value;
            } else if (type.compareToIgnoreCase("xs:credential") == 0 || type.compareToIgnoreCase("credential") == 0) {
                comparable = value;
            } else if (type.compareToIgnoreCase("xs:byte") == 0 || type.compareToIgnoreCase("xsdByte") == 0) {
                comparable = new Byte(value);
            } else if (type.compareToIgnoreCase("xs:decimal") == 0 || type.compareToIgnoreCase("xsdDecimal") == 0) {
                comparable = new BigDecimal(value);
            } else if (type.compareToIgnoreCase("xs:double") == 0 || type.compareToIgnoreCase("xsdDouble") == 0) {
                comparable = new Double(value);
            } else if (type.compareToIgnoreCase("xs:long") == 0 || type.compareToIgnoreCase("xsdLong") == 0) {
                comparable = new Long(value);
            } else if (type.compareToIgnoreCase("xs:short") == 0 || type.compareToIgnoreCase("xsdShort") == 0) {
                comparable = new Short(value);
            } else if (type.compareToIgnoreCase("xs:time") == 0 || type.compareToIgnoreCase("xsdTime") == 0) {
                comparable = new Time(value).getAsCalendar().getTime();
            } else if (type.compareToIgnoreCase("xs:unsignedByte") == 0 || type.compareToIgnoreCase("xsdUnsignedByte") == 0) {
                comparable = new UnsignedByte(value);
            } else if (type.compareToIgnoreCase("xs:unsignedInt") == 0 || type.compareToIgnoreCase("xsdUnsignedInt") == 0) {
                comparable = new UnsignedInt(value);
            } else if (type.compareToIgnoreCase("xs:unsignedLong") == 0 || type.compareToIgnoreCase("xsdUnsignedLong") == 0) {
                comparable = new UnsignedLong(value);
            } else if (type.compareToIgnoreCase("xs:unsignedShort") == 0 || type.compareToIgnoreCase("xsdUnsignedShort") == 0) {
                comparable = new UnsignedShort(value);
            } else if (type.compareToIgnoreCase("xs:duration") == 0 || type.compareToIgnoreCase("xsdDuration") == 0) {
                comparable = value;
            } else if (type.compareToIgnoreCase("xs:dateTime") == 0 || type.compareToIgnoreCase("xsdDateTime") == 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                try {
                    comparable = formatter.parse(value);
                }
                catch (ParseException e) {
                    comparable = value;
                }
            } else if (type.compareToIgnoreCase("xs:date") == 0 || type.compareToIgnoreCase("xsdDate") == 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    comparable = formatter.parse(value);
                }
                catch (ParseException e) {
                    comparable = value;
                }
            } else {
                comparable = value;
            }
        }
        return comparable;
    }
}

