/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDelegate;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetSinglePartition;
import com.cognos.asv.resultset.ResultSetTopicPartition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ResultSetDistinctTopicFiltered
extends ResultSetDelegate {
    private List m_keys;

    public ResultSetDistinctTopicFiltered(ResultSet rs, String topicString) {
        super(rs);
        this.m_keys = this.buildKeys(rs, topicString);
    }

    @Override
    public int numDataItems() {
        return this.m_keys.size();
    }

    @Override
    public Iterator getData() {
        return this.m_keys.iterator();
    }

    private List buildKeys(ResultSet rs, String topicString) {
        LinkedList ret_value = new LinkedList();
        ResultSetLinePieces linePieces = new ResultSetLinePieces(topicString, new IdentityFormatter());
        if (!linePieces.isConstant()) {
            String topicKey = linePieces.getTopicString();
            ResultSetSinglePartition singlePartition = new ResultSetSinglePartition(rs);
            ResultSetTopicPartition topicPartition = new ResultSetTopicPartition(singlePartition, rs, topicKey);
            while (topicPartition.hasNext()) {
                topicPartition.next();
                ResultSetPartition partition = topicPartition.partition();
                Iterator it = partition.getData();
                if (!it.hasNext()) continue;
                ret_value.add(it.next());
            }
        }
        return ret_value;
    }
}

