/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.linepieces.NCText;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

public class ResultSetLinePieces {
    private ArrayList m_pieces = new ArrayList();

    public ResultSetLinePieces(String template) {
        this.m_pieces = this.makePieces(template, new IdentityFormatter());
    }

    public ResultSetLinePieces(String template, Formatter decoder) {
        this.m_pieces = this.makePieces(template, decoder);
    }

    public boolean isConstant() {
        return this.m_pieces.size() == 1 && this.m_pieces.get(0) instanceof String;
    }

    public int size() {
        return this.m_pieces.size();
    }

    public Object get(int i) {
        return this.m_pieces.get(i);
    }

    public Set getTopics() {
        TreeSet ret_value = new TreeSet();
        if (!this.isConstant()) {
            for (int i = 0; i != this.m_pieces.size(); ++i) {
                if (!(this.m_pieces.get(i) instanceof ResultSetTopic)) continue;
                ret_value.add(this.m_pieces.get(i));
            }
        }
        return ret_value;
    }

    public String getTopicString() {
        String ret_value = null;
        if (!this.isConstant()) {
            Set topics = this.getTopics();
            StringBuffer topicString = new StringBuffer("");
            for (ResultSetTopic topic : topics) {
                topicString.append(topic.toString());
            }
            ret_value = topicString.toString();
        }
        return ret_value;
    }

    public String toString() {
        StringBuffer ret_value = new StringBuffer("");
        for (Object piece : this.m_pieces) {
            ret_value.append(piece.toString());
        }
        return ret_value.toString();
    }

    private ArrayList makePieces(String value, Formatter decoder) {
        ArrayList result = new ArrayList();
        if (value.length() == 0) {
            result.add(value);
        } else {
            NCText helper = new NCText();
            result = helper.makePieces(result, value, decoder);
        }
        return result;
    }
}

