/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetDelegate;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetSortTopic;
import com.cognos.asv.resultset.ResultSetTopic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ResultSetSorted
extends ResultSetDelegate {
    private Set m_keySet;

    public ResultSetSorted(ResultSet rs, ResultSetSortTopic[] topics) {
        super(rs);
        this.m_keySet = this.buildKeySet(rs, topics);
    }

    @Override
    public Set generateKeySet() {
        return this.m_keySet;
    }

    @Override
    public Iterator getData() {
        return this.m_keySet.iterator();
    }

    private Set buildKeySet(ResultSet rs, ResultSetSortTopic[] topics) {
        TreeSet ret_value = new TreeSet(new ResultSetComparator(topics));
        ret_value.addAll(rs.generateKeySet());
        return ret_value;
    }

    private class ResultSetComparator
    implements Comparator {
        private List m_topics = new ArrayList();
        private int m_index = 0;

        public ResultSetComparator(ResultSetSortTopic[] topics) {
            this.m_topics.addAll(Arrays.asList(topics));
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (o1 instanceof ResultSetKey && o2 instanceof ResultSetKey) {
                ResultSetKey key1 = (ResultSetKey)o1;
                ResultSetKey key2 = (ResultSetKey)o2;
                ResultSetSortTopic sortTopic = this.getNextTopic();
                ResultSetTopic topic = sortTopic.getTopic();
                MetadataItem metadata = ResultSetSorted.this.getMetadataValue(topic);
                ResultSetDataValue firstValue = ResultSetSorted.this.getDataValue(key1, topic);
                Comparable first = firstValue.getComparableValue(metadata);
                ResultSetDataValue secondValue = ResultSetSorted.this.getDataValue(key2, topic);
                Comparable second = secondValue.getComparableValue(metadata);
                result = sortTopic.isAscending() ? first.compareTo(second) : second.compareTo(first);
                if (result == 0 && this.hasNext()) {
                    result = this.compare(key1, key2);
                }
            }
            this.m_index = 0;
            return result;
        }

        private ResultSetSortTopic getNextTopic() {
            ResultSetSortTopic topic = (ResultSetSortTopic)this.m_topics.get(this.m_index);
            ++this.m_index;
            return topic;
        }

        private boolean hasNext() {
            return this.m_topics.size() == this.m_index;
        }
    }
}

