/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.ResultSetTopicType;

public class ResultSetTopic
implements Comparable {
    private String m_name;
    private String m_reference;
    private ResultSetTopicType m_type;

    public ResultSetTopic(String name, String reference) {
        this(name, reference, ResultSetTopicType.NORMAL);
    }

    public ResultSetTopic(String name, String reference, ResultSetTopicType type) {
        this.m_name = name;
        this.m_reference = reference;
        this.m_type = type;
    }

    public String name() {
        return this.m_name;
    }

    public String reference() {
        return this.m_reference;
    }

    public boolean previous() {
        return ResultSetTopicType.PREVIOUS.equals(this.m_type);
    }

    public boolean caption() {
        return ResultSetTopicType.CAPTION.equals(this.m_type);
    }

    public boolean normal() {
        return ResultSetTopicType.NORMAL.equals(this.m_type);
    }

    public String toString() {
        String ret_value = this.m_reference;
        if (!this.normal()) {
            ret_value = this.m_type.toString() + "(" + this.m_reference + ")";
        }
        return ret_value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResultSetTopic) {
            ResultSetTopic o = (ResultSetTopic)obj;
            return o.m_name.equals(this.m_name) && o.m_type == this.m_type;
        }
        return false;
    }

    public int hashCode() {
        return (this.m_name + String.valueOf(this.m_type)).hashCode();
    }

    public int compareTo(Object obj) {
        ResultSetTopic o = (ResultSetTopic)obj;
        int comparison = this.m_name.compareTo(o.m_name);
        if (comparison == 0 && o.m_type != this.m_type) {
            comparison = o.m_type.compareTo(this.m_type);
        }
        return comparison;
    }
}

