/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTopicFilter;
import com.cognos.asv.resultset.ResultSetTopicType;
import com.cognos.developer.schemas.bibus._3.StringArrayProp;
import com.cognos.jsmcommon.util.HashList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SuppressionFilters {
    private Set m_filters = new HashSet();
    private HashList m_topic_filters = new HashList();

    public SuppressionFilters(ResultSetFilterEnum filterEnum) {
        this(new ResultSetFilterEnum[]{filterEnum}, null);
    }

    public SuppressionFilters(ResultSetFilterEnum[] filterEnums) {
        this(filterEnums, null);
    }

    public SuppressionFilters(ResultSetFilterEnum[] filterEnums, StringArrayProp topicFilters) {
        for (int i = 0; i < filterEnums.length; ++i) {
            this.addFilter(filterEnums[i]);
        }
        this.setTopicFilter(topicFilters);
    }

    public List generateFilteredKeySet(ResultSet unfiltered) {
        LinkedList<ResultSetKey> filter_key_set = new LinkedList<ResultSetKey>();
        Iterator it = unfiltered.getData();
        while (it.hasNext()) {
            List topicFilters;
            ResultSetKey key = (ResultSetKey)it.next();
            String status = unfiltered.getDataValue(key, ResultSet.STATUS_TOPIC).getTopicValue();
            if (this.m_filters.contains(status)) {
                if (this.m_topic_filters.containsKey((Object)status)) {
                    List topic_filters = this.m_topic_filters.get((Object)status);
                    if (!this.checkTopicFilters(topic_filters, key, unfiltered)) continue;
                    filter_key_set.add(key);
                    continue;
                }
                filter_key_set.add(key);
                continue;
            }
            if (!this.m_topic_filters.containsKey((Object)ResultSetFilterEnum.UNCHANGED.getValue()) || !ResultSetFilterEnum.CHANGED.getValue().equals(status) || !this.checkTopicFilters(topicFilters = this.m_topic_filters.get((Object)ResultSetFilterEnum.UNCHANGED.getValue()), key, unfiltered)) continue;
            filter_key_set.add(key);
        }
        return filter_key_set;
    }

    private boolean checkTopicFilters(List topic_filters, ResultSetKey key, ResultSet unfiltered) {
        boolean useKey = false;
        for (ResultSetTopicFilter topicFilter : topic_filters) {
            if (!this.checkTopicFilter(topicFilter, key, unfiltered)) continue;
            useKey = true;
            break;
        }
        return useKey;
    }

    private boolean checkTopicFilter(ResultSetTopicFilter topicFilter, ResultSetKey key, ResultSet unfiltered) {
        ResultSetTopic currentTopic = topicFilter.topic();
        ResultSetTopic previousTopic = new ResultSetTopic(currentTopic.name(), currentTopic.reference(), ResultSetTopicType.PREVIOUS);
        String currentValue = unfiltered.getDataValue(key, currentTopic).getTopicValue();
        String previousValue = unfiltered.getDataValue(key, previousTopic).getTopicValue();
        boolean value_unchanged = currentValue == null ? previousValue == null : currentValue.equals(previousValue);
        boolean use_value = ResultSetFilterEnum.CHANGED.equals(topicFilter.getFilterType()) && !value_unchanged;
        use_value = use_value || ResultSetFilterEnum.UNCHANGED.equals(topicFilter.getFilterType()) && value_unchanged;
        return use_value;
    }

    public Set getResultSetFilterTypes() {
        return this.m_filters;
    }

    public ResultSetTopic[] getTopicFilters() {
        return (ResultSetTopic[])this.m_topic_filters.toArray((Object[])new ResultSetTopic[0]);
    }

    private void setTopicFilter(StringArrayProp topicFilters) {
        if (topicFilters == null) {
            return;
        }
        ResultSetTopicFilter[] topics = this.getFromProps(topicFilters);
        ResultSetFilterEnum filter_type = null;
        if (this.m_filters.contains(ResultSetFilterEnum.CHANGED.getValue()) ^ this.m_filters.contains(ResultSetFilterEnum.UNCHANGED.getValue())) {
            ResultSetFilterEnum resultSetFilterEnum = filter_type = this.m_filters.contains(ResultSetFilterEnum.UNCHANGED.getValue()) ? ResultSetFilterEnum.UNCHANGED : ResultSetFilterEnum.CHANGED;
        }
        if (filter_type != null) {
            for (int i = 0; i < topics.length; ++i) {
                topics[i].setFilterType(filter_type);
                this.m_topic_filters.put((Object)filter_type.getValue(), (Object)topics[i]);
            }
        }
    }

    public boolean containsFilter(ResultSetFilterEnum filter) {
        return this.m_filters != null && this.m_filters.contains(filter.getValue());
    }

    private void addFilter(ResultSetFilterEnum filter) {
        if (filter == null) {
            return;
        }
        if (this.m_filters.contains(filter.getValue())) {
            return;
        }
        this.m_filters.add(filter.getValue());
    }

    private ResultSetTopicFilter[] getFromProps(StringArrayProp value) {
        String[] values = value.getValue();
        ResultSetTopicFilter[] rsts = new ResultSetTopicFilter[values == null ? 0 : values.length];
        for (int i = 0; i < rsts.length; ++i) {
            ResultSetLinePieces pieces = new ResultSetLinePieces(values[i]);
            ResultSetTopic topic = (ResultSetTopic)pieces.get(0);
            rsts[i] = new ResultSetTopicFilter(topic);
        }
        return rsts;
    }
}

