/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.xml.sax.Attributes;

public class HTMLBase {
    protected String m_value;
    protected String[] m_attribute_names;
    protected String[] m_attribute_values;
    protected Hashtable m_attribute_keys;

    public HTMLBase(Attributes attributes) {
        this.m_attribute_names = new String[attributes.getLength()];
        this.m_attribute_values = new String[attributes.getLength()];
        this.m_attribute_keys = new Hashtable();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attributeQName = attributes.getQName(i);
            String attributeValue = attributes.getValue(i);
            this.m_attribute_names[i] = attributeQName;
            this.m_attribute_values[i] = attributeValue;
            this.m_attribute_keys.put(attributeQName, new Integer(i));
        }
    }

    public boolean hasAttribute(String attribute_name) {
        return this.m_attribute_keys.containsKey(attribute_name);
    }

    public String getAttribute(String attribute_name) {
        String ret_value = null;
        if (this.hasAttribute(attribute_name)) {
            int key = (Integer)this.m_attribute_keys.get(attribute_name);
            ret_value = this.m_attribute_values[key];
        }
        return ret_value;
    }

    public void setAttribute(String attribute_name, String value) {
        if (this.hasAttribute(attribute_name)) {
            int key = (Integer)this.m_attribute_keys.get(attribute_name);
            this.m_attribute_values[key] = value;
        } else {
            int i = this.m_attribute_names.length;
            String[] new_names = new String[i + 1];
            String[] new_values = new String[i + 1];
            System.arraycopy(this.m_attribute_names, 0, new_names, 0, i);
            System.arraycopy(this.m_attribute_values, 0, new_values, 0, i);
            new_names[i] = attribute_name;
            new_values[i] = value;
            this.m_attribute_names = new_names;
            this.m_attribute_values = new_values;
            this.m_attribute_keys.put(attribute_name, new Integer(i));
        }
    }

    public void setValue(String obj) {
        this.m_value = obj;
    }

    public String getValue() {
        return this.m_value;
    }

    public void write(Writer writer) throws IOException {
        String fullClassName = this.getClass().getName();
        int index = fullClassName.lastIndexOf(".");
        String className = fullClassName.substring(index + 1);
        writer.write("<" + className);
        for (int i = 0; i < this.m_attribute_names.length; ++i) {
            writer.write(" " + this.m_attribute_names[i] + "=\"" + this.m_attribute_values[i] + "\"");
        }
        if (this.m_value != null) {
            writer.write(">" + this.m_value + "</" + className + ">");
        } else {
            writer.write("/>");
        }
        writer.flush();
    }
}

