/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.resultset.linepieces.NCElement;
import com.cognos.asv.resultset.linepieces.NCElementType;
import java.util.List;

public abstract class AbstractItem {
    private StringBuffer m_reference = new StringBuffer();
    private StringBuffer m_name;

    public abstract List getElements();

    public abstract void format(String var1, Formatter var2, List var3);

    protected String changeText(String text) {
        this.m_reference = new StringBuffer(text);
        return this.m_reference.toString();
    }

    protected String changeName(String text) {
        this.m_name = new StringBuffer(text);
        return this.m_name.toString();
    }

    public String getEscapedReference(String text) {
        StringBuffer result = new StringBuffer();
        NCElement[] all = this.getElements().toArray(new NCElement[0]);
        boolean shouldEscapeStart = false;
        boolean shouldEscapeEnd = false;
        if (all.length > 1 && NCElementType.TOPIC_START.equals(all[0].getType()) && NCElementType.TOPIC_END.equals(all[all.length - 1].getType())) {
            shouldEscapeStart = true;
            shouldEscapeEnd = true;
        }
        for (int counter = 0; counter < all.length; ++counter) {
            if (shouldEscapeStart && NCElementType.TOPIC_START.equals(all[counter].getType())) {
                result.append(NCElementType.ESCAPED_TOPIC_START.getText());
                shouldEscapeStart = false;
                continue;
            }
            if (shouldEscapeEnd && NCElementType.TOPIC_END.equals(all[counter].getType())) {
                result.append(NCElementType.ESCAPED_TOPIC_END.getText());
                shouldEscapeEnd = false;
                continue;
            }
            result.append(all[counter].getSubString(text));
        }
        return result.toString();
    }

    public void defineReference(String text) {
        StringBuffer result = new StringBuffer();
        NCElement[] all = this.getElements().toArray(new NCElement[0]);
        for (int counter = 0; counter < all.length; ++counter) {
            if (NCElementType.ESCAPED_TOPIC_START.equals(all[counter].getType())) {
                result.append('[');
                continue;
            }
            if (NCElementType.ESCAPED_TOPIC_END.equals(all[counter].getType())) {
                result.append(']');
                continue;
            }
            result.append(all[counter].getSubString(text));
        }
        this.m_reference = result;
    }

    public void defineName(String text) {
        StringBuffer result = new StringBuffer();
        NCElement[] all = this.getElements().toArray(new NCElement[0]);
        for (int counter = 0; counter < all.length; ++counter) {
            if (NCElementType.ESCAPED_TOPIC_START.equals(all[counter].getType())) {
                result.append('[');
                continue;
            }
            if (NCElementType.ESCAPED_TOPIC_END.equals(all[counter].getType())) {
                result.append(']');
                continue;
            }
            if (NCElementType.DOUBLE_TOPIC_END.equals(all[counter].getType())) {
                result.append(']');
                continue;
            }
            result.append(all[counter].getSubString(text));
        }
        this.m_name = result;
    }

    public String getReference() {
        return this.m_reference.toString();
    }

    public String getName() {
        return this.m_name.toString();
    }

    public String toString() {
        return this.m_reference == null ? (this.getElements() == null ? "there are no elements in the item" : this.getElements().toString()) : this.m_reference.toString();
    }
}

