/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import com.cognos.asv.resultset.ResultSetTopicType;
import com.cognos.asv.resultset.linepieces.NCElement;
import com.cognos.asv.resultset.linepieces.NCElementType;
import com.cognos.asv.resultset.linepieces.NonReportItem;
import com.cognos.asv.resultset.linepieces.ReportItem;
import java.util.ArrayList;
import java.util.List;

public final class ItemGenerator {
    private ArrayList m_topicElements = new ArrayList();
    private NCElementType m_lastElementType;
    private ResultSetTopicType m_topicType = ResultSetTopicType.NORMAL;
    private boolean m_isTopicStarted = false;
    private boolean m_topicStartIsEncountered = false;

    private void reset() {
        this.m_topicElements.clear();
        this.m_topicType = ResultSetTopicType.NORMAL;
        this.m_isTopicStarted = false;
        this.m_topicStartIsEncountered = false;
    }

    public void addElement(List elements, NCElement elem) {
        NCElementType type = elem.getType();
        if (NCElementType.CAPTION_START.equals(type) || NCElementType.PREVIOUS_START.equals(type)) {
            ResultSetTopicType topicType = ResultSetTopicType.getType(type);
            if (this.m_topicType == topicType) {
                this.m_topicElements.add(elem);
            } else if (this.m_topicStartIsEncountered) {
                this.m_topicElements.add(elem);
            } else {
                if (!this.m_topicElements.isEmpty()) {
                    elements.add(new NonReportItem(this.m_topicElements));
                    this.reset();
                }
                this.m_topicElements.add(elem);
                this.m_topicType = topicType;
            }
        } else if (NCElementType.FUNCTION_END.equals(type)) {
            if (this.m_topicType != ResultSetTopicType.NORMAL && NCElementType.TOPIC_END.equals(this.m_lastElementType) && this.m_topicStartIsEncountered) {
                this.m_topicElements.add(elem);
                elements.add(new ReportItem(this.m_topicElements, this.m_topicType));
                this.reset();
            } else {
                this.m_topicElements.add(elem);
            }
        } else if (NCElementType.TOPIC_START.equals(type)) {
            if (this.m_topicType != ResultSetTopicType.NORMAL) {
                if (this.m_topicElements.size() > 1) {
                    elements.add(new NonReportItem(this.m_topicElements));
                    this.reset();
                }
                this.m_topicStartIsEncountered = true;
                this.m_topicElements.add(elem);
            } else {
                if (this.m_topicElements.size() > 0 && !this.m_topicStartIsEncountered) {
                    elements.add(new NonReportItem(this.m_topicElements));
                    this.reset();
                }
                this.m_topicStartIsEncountered = true;
                this.m_topicElements.add(elem);
            }
        } else if (NCElementType.TOPIC_END.equals(type)) {
            if (this.m_topicStartIsEncountered) {
                if (this.m_topicType == ResultSetTopicType.NORMAL) {
                    this.m_topicElements.add(elem);
                    elements.add(new ReportItem(this.m_topicElements, ResultSetTopicType.NORMAL));
                    this.reset();
                } else {
                    this.m_topicElements.add(elem);
                }
            } else if (!this.m_topicStartIsEncountered) {
                this.m_topicElements.add(elem);
                elements.add(new NonReportItem(this.m_topicElements));
                this.reset();
            } else {
                this.m_topicElements.add(elem);
            }
        } else {
            this.m_topicElements.add(elem);
        }
        this.m_lastElementType = type;
    }

    public void close(List elements) {
        if (!this.m_topicElements.isEmpty()) {
            elements.add(new NonReportItem(this.m_topicElements));
            this.m_topicElements.clear();
        }
    }
}

