/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import com.cognos.asv.resultset.linepieces.NCElementType;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NCElement {
    private int m_start;
    private int m_end;
    private NCElementType m_type;

    public NCElement(int start, int end, NCElementType type) {
        if (end < start || start == end) {
            String errMsg = "start and end can not have equal values; " + start + " to " + end;
            System.err.println(errMsg);
        }
        this.m_start = start;
        this.m_end = end;
        this.m_type = type;
    }

    public String getSubString(String text) {
        String result = text.substring(this.m_start, this.m_end);
        return result;
    }

    public NCElementType getType() {
        return this.m_type;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NCElement) {
            NCElement otherEl = (NCElement)obj;
            result = this.m_start == otherEl.m_start && this.m_end == otherEl.m_end && this.m_type.equals(otherEl.m_type);
        }
        return result;
    }

    public void breakByPattern(CharSequence text, ListIterator elements, NCElementType type) {
        Pattern startEscape = type.getPattern();
        Matcher startMatcher = startEscape.matcher(text.subSequence(this.m_start, this.m_end));
        int start = 0;
        int end = 0;
        int index = this.m_start;
        int theStart = this.m_start;
        int theEnd = this.m_end;
        boolean found = false;
        boolean isChanged = false;
        while (startMatcher.find()) {
            found = true;
            start = startMatcher.start() + theStart;
            end = startMatcher.end() + theStart;
            if (start == this.m_start) {
                this.m_end = end;
                this.m_type = type;
                isChanged = true;
            } else if (start > this.m_start) {
                if (isChanged) {
                    if (start > index) {
                        elements.add(new NCElement(index, start, NCElementType.TEXT));
                    }
                } else {
                    this.m_end = start;
                    isChanged = true;
                }
            }
            if (start >= this.m_end && end > this.m_end) {
                elements.add(new NCElement(start, end, type));
            }
            index = end;
        }
        if (index < theEnd && found) {
            elements.add(new NCElement(index, theEnd, NCElementType.TEXT));
        }
    }

    public int hashCode() {
        return this.m_start + this.m_end;
    }

    public String toString() {
        return this.m_start + " to " + this.m_end + " : " + this.m_type.toString() + " : ";
    }
}

