/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.resultset.linepieces.AbstractItem;
import com.cognos.asv.resultset.linepieces.ItemGenerator;
import com.cognos.asv.resultset.linepieces.NCElement;
import com.cognos.asv.resultset.linepieces.NCElementType;
import com.cognos.asv.resultset.linepieces.NonReportItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public final class NCText {
    private static NCElementType[] m_types = new NCElementType[]{NCElementType.ESCAPED_TOPIC_START, NCElementType.ESCAPED_TOPIC_END, NCElementType.TOPIC_START, NCElementType.DOUBLE_TOPIC_END, NCElementType.TOPIC_END, NCElementType.PREVIOUS_START, NCElementType.CAPTION_START, NCElementType.FUNCTION_END};

    private List buildPieces(LinkedList elements) {
        NCElement oneElement = null;
        ArrayList currentText = new ArrayList();
        ItemGenerator topicExtractor = new ItemGenerator();
        while (elements.size() > 0) {
            oneElement = (NCElement)elements.removeFirst();
            topicExtractor.addElement(currentText, oneElement);
        }
        topicExtractor.close(currentText);
        Object oneObj = null;
        NonReportItem lastItem = null;
        Iterator currentPieces = currentText.iterator();
        while (currentPieces.hasNext()) {
            oneObj = currentPieces.next();
            if (oneObj instanceof NonReportItem) {
                if (lastItem == null) {
                    lastItem = oneObj;
                    continue;
                }
                lastItem.addItem(oneObj);
                currentPieces.remove();
                continue;
            }
            lastItem = null;
        }
        return currentText;
    }

    private void breakTextByPattern(String text, LinkedList elements, NCElementType type) {
        NCElement oneElement = null;
        ListIterator allEls = elements.listIterator();
        while (allEls.hasNext()) {
            oneElement = (NCElement)allEls.next();
            if (!NCElementType.TEXT.equals(oneElement.getType())) continue;
            oneElement.breakByPattern(text, allEls, type);
        }
    }

    private void breakText(String text, LinkedList elements) {
        NCElement oneElement = new NCElement(0, text.length(), NCElementType.TEXT);
        elements.add(oneElement);
        for (int counter = 0; counter < m_types.length; ++counter) {
            this.breakTextByPattern(text, elements, m_types[counter]);
        }
    }

    private boolean compareList(LinkedList list, String text, String[] expectedStrings, NCElementType[] types) {
        boolean result = list.size() == expectedStrings.length;
        NCElement oneElement = null;
        int counter = 0;
        Iterator allEls = list.iterator();
        while (result && allEls.hasNext()) {
            oneElement = (NCElement)allEls.next();
            result = oneElement.getSubString(text).equals(expectedStrings[counter]);
            if (result) {
                result = types[counter].equals(oneElement.getType());
            }
            ++counter;
        }
        return result;
    }

    private ArrayList formatPieces(String text, List pieces, Formatter decoder) {
        ArrayList result = new ArrayList();
        AbstractItem[] items = pieces.toArray(new AbstractItem[pieces.size()]);
        for (int counter = 0; counter < items.length; ++counter) {
            items[counter].format(text, decoder, result);
        }
        return result;
    }

    public ArrayList makePieces(ArrayList list, String value, Formatter decoder) {
        ArrayList result = null;
        result = list == null ? new ArrayList() : list;
        LinkedList theList = new LinkedList();
        this.breakText(value, theList);
        List thePieces = this.buildPieces(theList);
        result = this.formatPieces(value, thePieces, decoder);
        return result;
    }

    public String escapeTopics(String value) {
        LinkedList theList = new LinkedList();
        this.breakText(value, theList);
        List thePieces = this.buildPieces(theList);
        AbstractItem[] pieces = thePieces.toArray(new AbstractItem[thePieces.size()]);
        StringBuffer escapedBuffer = new StringBuffer();
        for (int counter = 0; counter < pieces.length; ++counter) {
            escapedBuffer.append(pieces[counter].getEscapedReference(value));
        }
        String escapedText = escapedBuffer.toString();
        return escapedText;
    }
}

