/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTopicType;
import com.cognos.asv.resultset.linepieces.AbstractItem;
import com.cognos.asv.resultset.linepieces.NCElementType;
import java.util.ArrayList;
import java.util.List;

public final class ReportItem
extends AbstractItem {
    private ArrayList m_topicElements;
    private ResultSetTopicType m_type;

    public ReportItem(ArrayList topicElements, ResultSetTopicType type) {
        this.m_topicElements = new ArrayList(topicElements);
        this.m_type = type;
    }

    @Override
    public void format(String text, Formatter formatter, List pieces) {
        this.defineReference(text);
        String formattedReference = this.getReference();
        this.defineName(text);
        String formattedName = this.getName();
        if (formatter != null) {
            formattedReference = this.changeText(formatter.format(formattedReference));
            formattedName = this.changeName(formatter.format(formattedName));
        }
        ResultSetTopic rsp = null;
        if (this.m_type == ResultSetTopicType.PREVIOUS) {
            String theName = formattedName.substring(NCElementType.PREVIOUS_START.getText().length() + 1, formattedName.length() - 2);
            String theRef = formattedReference.substring(NCElementType.PREVIOUS_START.getText().length(), formattedReference.length() - 1);
            rsp = new ResultSetTopic(theName, theRef, this.m_type);
        } else if (this.m_type == ResultSetTopicType.CAPTION) {
            String theName = formattedName.substring(NCElementType.CAPTION_START.getText().length() + 1, formattedName.length() - 2);
            String theRef = formattedReference.substring(NCElementType.CAPTION_START.getText().length(), formattedReference.length() - 1);
            rsp = new ResultSetTopic(theName, theRef, this.m_type);
        } else {
            rsp = new ResultSetTopic(formattedName.substring(1, formattedName.length() - 1), formattedReference.toString(), this.m_type);
        }
        pieces.add(rsp);
    }

    @Override
    public List getElements() {
        return this.m_topicElements;
    }
}

