/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.service;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentHouseKeeper;
import com.cognos.asv.service.ASVAsyncService;
import com.cognos.asv.service.ASVConfiguration;
import com.cognos.jsmcommon.lock.ResourceLockManager;
import com.cognos.jsmcommon.lock.database.SdsInstanceAwareResourceLockManager;
import com.cognos.jsmcommon.logging.PerfLog;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.soap.service.AxisServiceHandler;
import com.cognos.jsmcommon.soap.service.IServiceConfiguration;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.Controller;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.pogo.async.AsyncService;
import com.cognos.pogo.async.Asyncable;
import com.cognos.pogo.monitoring.SimpleRequestReportingHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidator;
import com.ibm.cognos.jsmcommon.dbschemavalidator.DBSchemaValidatorAtIntervals;
import java.util.Iterator;
import org.dom4j.Element;

public class ASVHandler
extends BasicHandler
implements Asyncable {
    private PogoEngine m_engine = null;
    private static final String DELETE_HOT_LIST = "deleteHotList";
    private static final String GET_TRANSLATED_HISTORY_TOPIC = "getTranslatedHistoryTopic";
    private static final String PREVIEW_RUNNING_AGENT = "previewRunningAgent";
    private boolean m_suspended = false;
    private Controller m_housekeeper = null;
    private ResourceLockManager resourceLockManager;

    public ASVHandler() {
        super(null);
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        this.m_engine = engine;
    }

    public AsyncService getAsyncRequest(MessageContext context) {
        BIBusEnvelope biBusEnv = (BIBusEnvelope)context.getProperty("request.envelope");
        ASVAsyncService ret_value = null;
        if (this.isAsynch(biBusEnv)) {
            ret_value = new ASVAsyncService(this, context);
        }
        return ret_value;
    }

    public void configure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        CRNProperties cclConfig = CRNProperties.getInstance();
        cclConfig.init(configuration.getICCLConfiguration(), this.getName());
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(configuration.getICCLConfiguration());
        perf.stop();
    }

    public void dispose() {
    }

    public void initialize() {
        try {
            Handler h = this.m_engine.getHandlerPool().find("agentService.jsmReporter");
            if (h != null && h instanceof SimpleRequestReportingHandler) {
                SimpleRequestReportingHandler srrh = (SimpleRequestReportingHandler)h;
                srrh.getRequestReporter();
            }
            this.resourceLockManager = SdsInstanceAwareResourceLockManager.instance();
        }
        catch (Exception x) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeImpl(MessageContext mc) throws PogoException {
        if (this.isSuspended()) {
            mc.setFault(new Fault("AbortIfSuspendedHandler.serviceStopped"));
            return;
        }
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        try {
            BIBusEnvelope biBusEnv = (BIBusEnvelope)mc.getProperty("request.envelope");
            ThreadProperties.setProperty((String)"componentID", (String)"ASV");
            String requestOp = BiBusUtilities.getOperation((BIBusEnvelope)biBusEnv);
            if (requestOp != null) {
                ThreadProperties.setProperty((String)"requestOperation", (String)requestOp);
            }
            ThreadProperties.setObject((String)"resource.lock.manager", (Object)this.resourceLockManager);
            AxisServiceHandler handler = AxisServiceHandler.getHandler((IServiceConfiguration)ASVConfiguration.getInstance(), (MessageContext)mc);
            handler.setAsAsync(true);
            handler.prepare();
            handler.execute();
        }
        finally {
            ThreadProperties.clear();
            perf.stop();
        }
    }

    public void reconfigure(Configuration configuration) {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.WARN, "ENTER");
        this.configure(configuration);
        perf.stop();
    }

    public void resume() {
        this.resumeNow();
    }

    public void start() {
        this.resumeNow();
        DBSchemaValidatorAtIntervals.getInstance().startDBSchemaValidationAtIntervals(DBSchemaValidator.ComponentName.NC);
    }

    private synchronized void resumeNow() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).startService("AgentService", "Success");
        if (null == this.m_housekeeper) {
            this.m_housekeeper = new AgentHouseKeeper();
            this.m_housekeeper.start();
            this.setSuspended(false);
        } else {
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Error in resume/starting the agent service house keeper");
        }
        perf.stop();
    }

    public void stop() {
        this.suspendNow();
    }

    public void suspend(boolean immediately) {
        this.suspendNow();
    }

    private synchronized void suspendNow() {
        PerfLog perf = SDSLogger.getLogger((SDSCategory)ASVCategory.PERF).start(((Object)((Object)this)).getClass(), SDSLevel.FATAL, "ENTER");
        this.setSuspended(true);
        if (null != this.m_housekeeper) {
            this.m_housekeeper.stop();
            this.m_housekeeper = null;
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).stopService("AgentService", "Success");
        perf.stop();
    }

    private void setSuspended(boolean suspended) {
        this.m_suspended = suspended;
    }

    private boolean isSuspended() {
        return this.m_suspended;
    }

    private boolean isAsynch(BIBusEnvelope biBusEnv) {
        String method;
        boolean asynch = true;
        Element body = biBusEnv.getBody();
        Iterator children = body.elementIterator();
        if (children.hasNext() && ((method = ((Element)children.next()).getName()) != null && method.equals(PREVIEW_RUNNING_AGENT) || method.equals(DELETE_HOT_LIST) || method.equals(GET_TRANSLATED_HISTORY_TOPIC))) {
            asynch = false;
        }
        return asynch;
    }
}

