/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.RssOptionsGenerator;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.actions.RunAgentAction;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetIgnoreIllegalTopics;
import com.cognos.asv.resultset.ResultSetNoEvents;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.UrlRSSTask;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.run.commands.AddHistoryParametersCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.Locale;

public class AgentBaseRssTarget
extends BaseAgentTaskTarget {
    public AgentBaseRssTarget(BaseRSSTask base, BaseStepObject jobStep, JobBiBusHeaders headers) {
        super((BaseClass)base, jobStep, headers);
    }

    protected BaseRSSTask getBaseRss() {
        return (BaseRSSTask)this.getBaseClass();
    }

    @Override
    public Option[] getOptions() {
        return this.getBaseRss().getOptions() != null ? this.getBaseRss().getOptions().getValue() : new Option[]{};
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseRss().getParameters() != null ? this.getBaseRss().getParameters().getValue() : new ParameterValue[]{};
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.doRun(action, true);
    }

    @Override
    public void onStepFailed(AgentAction action) throws AgentServiceException {
        RunAgentAction runAgentAction = new RunAgentAction(this);
        this.doRun(runAgentAction, false);
    }

    private void doRun(AgentAction action, boolean success) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        try {
            ResultSet rs = this.buildResultSet(this.getResultSet(), true);
            Object obj = this.buildTaskRun(success, rs);
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            TaskRunInfo taskRun = (TaskRunInfo)obj;
            action.runAgentTaskTarget(success ? Client.ServiceEnum.MONITOR_SERVICE : Client.ServiceEnum.DELIVERY_SERVICE, this.getBaseRss().getSearchPath().getValue(), taskRun.parameters(), taskRun.options());
        }
        catch (AgentServiceException ase) {
            throw ase;
        }
        catch (LocalizableException le) {
            throw new AgentServiceException(le);
        }
        catch (Throwable e) {
            String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        boolean success = !this.getByPassExecution();
        ResultSet rs = this.buildResultSet(this.getResultSet(), true);
        Object obj = this.buildTaskRun(success, rs);
        try {
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
            if (obj instanceof TaskRunInfo) {
                TaskRunInfo taskRunInfo = (TaskRunInfo)obj;
                previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
            }
        }
        catch (LocalizableException e) {
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
            AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)e : new AgentServiceException(e);
            throw ase;
        }
        catch (Throwable e) {
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
            String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
        }
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        validateResult.addValidationMessages(RssOptionsGenerator.validate(this.getBaseRss(), validateResult.getHeaders()));
        boolean success = !this.getByPassExecution();
        ResultSet rs = this.buildResultSet(this.getResultSet(), false);
        Object obj = this.buildTaskRun(success, validateResult.getValidationSeverity(), rs);
        try {
            if (obj instanceof Exception) {
                throw (Exception)obj;
            }
        }
        catch (LocalizableException e) {
            validateResult.addValidationMessage(new I18NMessage(e.getI18NCode(), e.getParams(), SeverityEnum.warn));
        }
        catch (Throwable t) {
            validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_DS_VALIDATION_ERRORS, new Object[]{t.getLocalizedMessage()}, SeverityEnum.error));
        }
    }

    private Object buildTaskRun(boolean success, ResultSet rs) {
        return this.buildTaskRun(success, SeverityEnum.warn, rs);
    }

    private Object buildTaskRun(boolean success, SeverityEnum severity, ResultSet resultSet) {
        Object ret_value = null;
        try {
            String uri;
            I18NCode code;
            BaseAgent agent = null;
            BaseStepObject step = this;
            while (agent == null && (step = step.getParent()) != null) {
                if (!(step instanceof BaseAgent)) continue;
                agent = (BaseAgent)step;
            }
            BaseRSSTask base = this.getBaseRss();
            String title_string = null;
            MultilingualStringProp titlearr = this.getBaseRss().getTitle();
            if (titlearr != null) {
                MultilingualString[] titles = this.getBaseRss().getTitle().getValue();
                String string = title_string = titles != null && titles.length > 0 && titles[0] != null ? titles[0].getValue() : null;
            }
            if (base instanceof ShortcutRSSTask) {
                I18NCode code2;
                BaseClassArrayProp shortcutLink = ((ShortcutRSSTask)base).getLink();
                SearchPathSingleObject linkPath = ObjectModelUtil.getSearchPath((BaseClassArrayProp)shortcutLink, (int)0);
                if (linkPath != null && (code2 = RssOptionsGenerator.validateLinkEntry(this.getHeaders(), linkPath)) != null) {
                    throw new AgentServiceException(code2, new Object[]{title_string}, SeverityEnum.error);
                }
            } else if (base instanceof UrlRSSTask && (code = RssOptionsGenerator.validateURL(uri = ObjectModelUtil.getUri((AnyURIProp)((UrlRSSTask)base).getLink()))) != null) {
                throw new AgentServiceException(code, new Object[]{title_string}, SeverityEnum.error);
            }
            Option[] resolved_options = ResolveOptionsUtil.resolveOptions(this);
            RssOption[] rss_options = RssOptionsGenerator.generateOptions(agent, this.getBaseRss(), resultSet, success, severity);
            Option[] merged_options = OptionUtils.mergeOptions((Option[])resolved_options, (Option[])rss_options);
            ParameterValue[] pvs = ResolveParametersUtil.resolveParameters(this);
            pvs = ResolveParametersUtil.trimToTargetParams(pvs, this, this.getResultSet());
            ret_value = new TaskRunInfo(merged_options, pvs);
        }
        catch (Exception e) {
            ret_value = e;
        }
        return ret_value;
    }

    private ResultSet buildResultSet(ResultSet rs, boolean ignoreIllegalTopics) {
        if (rs.isEmpty()) {
            Locale locale = LocaleUtil.getLocale((String)this.getHeaders().getUserPreferenceContentLocale());
            String defaultValue = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
            rs = ResultSetNoEvents.getResultSet(rs, locale, defaultValue);
        }
        if (ignoreIllegalTopics) {
            rs = new ResultSetIgnoreIllegalTopics(rs);
        }
        return rs;
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }

    @Override
    protected void addTseFailCommands() {
        this.addTseCommands(new CmdSpec[]{new AddHistoryParametersCmdSpec()});
    }
}

