/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetIgnoreIllegalTopics;
import com.cognos.asv.resultset.ResultSetNoEvents;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetSinglePartition;
import com.cognos.asv.resultset.ResultSetTopicPartition;
import com.cognos.asv.taskTargets.AttachmentValidator;
import com.cognos.asv.taskTargets.memo.ResultSetDeliveryOptionsBuilder;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.EventTypeEnum;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.DeliveryServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.run.commands.AddHistoryParametersCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.util.I18NMessageUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class AgentMemoTarget
extends BaseAgentTaskTarget {
    private String[] reportVariables;

    public AgentMemoTarget(Memo memo, BaseStepObject jobStep, JobBiBusHeaders headers) {
        super((BaseClass)memo, jobStep, headers);
    }

    private Memo getBaseMemo() {
        return (Memo)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseMemo().getParameters() != null ? this.getBaseMemo().getParameters().getValue() : null;
    }

    @Override
    public Option[] getOptions() {
        return this.getBaseMemo().getOptions() != null ? this.getBaseMemo().getOptions().getValue() : null;
    }

    public String[] getReportVariables() {
        return this.reportVariables;
    }

    @Override
    public ResultSetFilterEnum[] getFilter(EventTypeEnum[] eventTypeEnumArray) {
        ResultSetFilterEnum[] filters = new ResultSetFilterEnum[]{};
        if (eventTypeEnumArray != null) {
            ArrayList<ResultSetFilterEnum> enums = new ArrayList<ResultSetFilterEnum>();
            for (int i = 0; i < eventTypeEnumArray.length; ++i) {
                ResultSetFilterEnum xenum = ResultSetFilterEnum.getFilterEnum(eventTypeEnumArray[i].getValue());
                enums.add(xenum);
            }
            filters = enums.toArray(new ResultSetFilterEnum[0]);
        } else {
            filters = super.getFilter(eventTypeEnumArray);
        }
        return filters;
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        ResultSetDeliveryOptionsBuilder builder = new ResultSetDeliveryOptionsBuilder(this.getOptions(), null, this.getHeaders(), this.getParent(), this.getStoreID(), true);
        ResultSet rs = this.buildResultSet(this.getResultSet(), true);
        ArrayList taskRuns = this.buildTaskRuns(builder, rs);
        Iterator it = taskRuns.iterator();
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                action.runAgentTaskTarget(Client.ServiceEnum.MONITOR_SERVICE, this.getSearchPath(), taskRun.parameters(), taskRun.options());
            }
            catch (LocalizableException e) {
                this.setStatus(EventStatus.FAILED);
                AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)e : new AgentServiceException(e);
                throw ase;
            }
            catch (Throwable e) {
                this.setStatus(EventStatus.FAILED);
                String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        ResultSetDeliveryOptionsBuilder builder = new ResultSetDeliveryOptionsBuilder(this.getOptions(), null, this.getHeaders(), this.getParent(), this.getStoreID(), false);
        ResultSet rs = this.buildResultSet(this.getResultSet(), false);
        ArrayList taskRuns = this.buildTaskRuns(builder, rs);
        Iterator it = taskRuns.iterator();
        while (it.hasNext()) {
            DeliveryServiceClientPort dscp = null;
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                dscp = Client.instance().getDeliveryServiceClient(this.getHeaders());
                AsynchReply reply = dscp.validateSpecification(null, new ParameterValue[0], taskRun.options());
                AttachmentValidator attachValidator = new AttachmentValidator(this, this.getOptions());
                I18NMessage[] invalidMessages = attachValidator.validate();
                if (invalidMessages.length > 0) {
                    validateResult.addValidationMessages(invalidMessages);
                }
                AsynchDetail[] details = reply.getDetails();
                validateResult.addValidationMessages(I18NMessageUtil.getMessages((AsynchDetail[])details, (I18NCode)AsvI18NCode.MSG_ASV_DS_VALIDATION_ERRORS));
            }
            catch (LocalizableException e) {
                validateResult.addValidationMessage(new I18NMessage(e.getI18NCode(), e.getParams(), e.getSeverity()));
            }
            catch (Throwable t) {
                validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_DS_VALIDATION_ERRORS, new Object[]{t.getLocalizedMessage()}, SeverityEnum.error));
            }
            finally {
                if (dscp == null) continue;
                dscp.close();
            }
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        ResultSetDeliveryOptionsBuilder builder = new ResultSetDeliveryOptionsBuilder(this.getOptions(), null, this.getHeaders(), this.getParent(), this.getStoreID(), false);
        ResultSet rs = this.buildResultSet(this.getResultSet(), true);
        ArrayList taskBuilds = this.buildTaskRuns(builder, rs);
        ArrayList<TaskRunInfo> taskRuns = new ArrayList<TaskRunInfo>();
        Iterator it = taskBuilds.iterator();
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                taskRuns.add(taskRun);
            }
            catch (LocalizableException e) {
                previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
                this.setStatus(EventStatus.FAILED);
                AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)e : new AgentServiceException(e);
                throw ase;
            }
            catch (Throwable e) {
                previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
                this.setStatus(EventStatus.FAILED);
                String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
            }
        }
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, taskRuns.toArray(new TaskRunInfo[0])));
    }

    private ArrayList buildTaskRuns(ResultSetDeliveryOptionsBuilder builder, ResultSet rs) {
        ArrayList<Object> taskRuns = new ArrayList<Object>();
        ResultSetSinglePartition singlePartition = new ResultSetSinglePartition(rs);
        String recipients = builder.getRecipients();
        ResultSetTopicPartition recipientFilter = new ResultSetTopicPartition(singlePartition, rs, recipients);
        String subject = builder.getSubject();
        ResultSetTopicPartition subjectFilter = new ResultSetTopicPartition(recipientFilter, rs, subject);
        while (null != subjectFilter && subjectFilter.hasNext()) {
            try {
                subjectFilter.next();
                ResultSetPartition partition = subjectFilter.partition();
                builder.setPartition(partition);
                builder.processDeliveryOptions();
                DeliveryOption[] buildOptions = builder.getDeliveryOptions();
                Option[] submitOptions = this.getParent().getParent().getSubmitOptions();
                Option[] runOptions = OptionUtils.mergeOptions((Option[])submitOptions, (Option[])buildOptions);
                taskRuns.add(new TaskRunInfo(runOptions, null));
            }
            catch (Exception e) {
                taskRuns.add(e);
            }
        }
        CmdSpec[] cmdSpec = builder.getReportVariables();
        if (cmdSpec.length > 0 && !this.SaveReportPathCmdExistsForTaskID()) {
            this.addTseCommands(builder.getReportVariables());
        }
        return taskRuns;
    }

    private ResultSet buildResultSet(ResultSet rs, boolean ignoreIllegalTopics) {
        if (rs.isEmpty()) {
            Locale locale = LocaleUtil.getLocale((String)this.getHeaders().getUserPreferenceContentLocale());
            String defaultValue = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
            rs = ResultSetNoEvents.getResultSet(rs, locale, defaultValue);
        }
        if (ignoreIllegalTopics) {
            rs = new ResultSetIgnoreIllegalTopics(rs);
        }
        return rs;
    }

    @Override
    protected void addTseFailCommands() {
        this.addTseCommands(new CmdSpec[]{new AddHistoryParametersCmdSpec()});
    }

    public boolean isAttached(String searchPath) {
        boolean isAttached = false;
        Option[] options = this.getOptions();
        for (int i = 0; i < options.length && !isAttached; ++i) {
            DeliveryOption deliveryOption;
            if (!(options[i] instanceof DeliveryOption) || !(deliveryOption = (DeliveryOption)options[i]).getName().equals((Object)DeliveryOptionEnum.memoPart)) continue;
            DeliveryOptionMemoPart dom = (DeliveryOptionMemoPart)deliveryOption;
            isAttached = this.extractAttachments(dom.getValue(), searchPath);
        }
        return isAttached;
    }

    private boolean extractAttachments(MemoPart memoPart, String searchPath) {
        MemoPartAgentObject attachment;
        boolean isAttached = false;
        if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite composite = (MemoPartComposite)memoPart;
            MemoPart[] mps = composite.getParts();
            for (int j = 0; j < mps.length && !isAttached; ++j) {
                isAttached = this.extractAttachments(mps[j], searchPath);
            }
        } else if (memoPart instanceof MemoPartAgentObject && (attachment = (MemoPartAgentObject)memoPart).getSearchPath() != null && attachment.getSearchPath().get_value() != null) {
            isAttached = attachment.getSearchPath().get_value().equals(searchPath);
        }
        return isAttached;
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }
}

