/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.taskTargets.webServiceTask.ASVWebServiceRequest;
import com.cognos.asv.taskTargets.webServiceTask.WebServiceTaskRunnable;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.HashMap;

public class AgentWebServiceTarget
extends BaseAgentTaskTarget
implements IAGSWSDLConstants {
    AgentWebServiceTarget() {
        super(null, null, null);
    }

    public AgentWebServiceTarget(WebServiceTask webTask, BaseStepObject jobStep, JobBiBusHeaders headers) {
        super((BaseClass)webTask, jobStep, headers);
    }

    private WebServiceTask getBaseWebService() {
        return (WebServiceTask)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseWebService().getParameters() != null ? this.getBaseWebService().getParameters().getValue() : null;
    }

    @Override
    public Option[] getOptions() {
        return this.getBaseWebService().getOptions() != null ? this.getBaseWebService().getOptions().getValue() : null;
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        try {
            WebServiceTaskRunnable runnable = new WebServiceTaskRunnable((WebServiceTask)this.getBaseClass(), null, this.getHeaders());
            ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
            parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
            runnable.setSubmitParameters(parameters);
            Option[] options = ResolveOptionsUtil.resolveOptions(this);
            ParameterValue[] taskParams = runnable.getParameters();
            TaskRunInfo taskRunInfo = new TaskRunInfo(options, taskParams);
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
        }
        catch (AgentServiceException e1) {
            previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
            AgentServiceException ase = new AgentServiceException(e1.getI18NCode(), e1.getParams(), (Throwable)((Object)e1), SeverityEnum.warn);
            throw ase;
        }
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        try {
            WebServiceTaskRunnable runnable = new WebServiceTaskRunnable((WebServiceTask)this.getBaseClass(), null, this.getHeaders());
            runnable.setSubmitOptions(ResolveOptionsUtil.resolveOptions(this));
            ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
            parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
            runnable.setSubmitParameters(parameters);
            runnable.validate(validateResult);
        }
        catch (AgentServiceException e1) {
            AgentServiceException ase = new AgentServiceException(e1.getI18NCode(), e1.getParams(), (Throwable)((Object)e1), SeverityEnum.warn);
            throw ase;
        }
    }

    @Override
    protected BaseParameter[] getTargetParametersImpl(ParameterValue[] connectionParameters) throws AgentServiceException {
        return AgentWebServiceTarget.getWebServiceParameters(this.getBaseWebService());
    }

    static BaseParameter[] getWebServiceParameters(WebServiceTask wtask) throws AgentServiceException {
        ASVWebServiceRequest asvWebServiceReq = new ASVWebServiceRequest(wtask.getDefaultName().getValue());
        HashMap<String, String> wsifAttrMap = new HashMap<String, String>();
        HashMap<String, Object> wsifParmMap = new HashMap<String, Object>();
        wsifAttrMap.put("target", wtask.getUri().getValue());
        wsifParmMap.put("portname", new String[]{wtask.getBindingName().getValue()});
        wsifParmMap.put("servicename", new String[]{wtask.getServiceName().getValue()});
        wsifParmMap.put("operationname", new String[]{wtask.getOperationName().getValue()});
        BooleanProp bulkEventsProperty = wtask.getBulkEvents();
        wsifParmMap.put("bulkEvents", bulkEventsProperty == null ? false : bulkEventsProperty.isValue());
        return asvWebServiceReq.createParameters(wsifAttrMap, wsifParmMap);
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }
}

