/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class TopicValidator {
    private ResultSet m_agentResultSet;
    private Collection m_memoTopics;
    private ValidationResultHandler m_validationHandler;

    public TopicValidator(ResultSet agentResultSet, Collection memoTopics, ValidationResultHandler validationHandler) {
        this.m_agentResultSet = agentResultSet;
        this.m_memoTopics = memoTopics;
        this.m_validationHandler = validationHandler;
    }

    public void validate() {
        HashSet<String> agentTopics = new HashSet<String>();
        Iterator metaDataIter = this.m_agentResultSet.getMetadata();
        while (metaDataIter.hasNext()) {
            MetadataItem item = (MetadataItem)metaDataIter.next();
            if (item == null) continue;
            agentTopics.add(item.expression());
        }
        for (ResultSetTopic memoTopic : this.m_memoTopics) {
            ResultSetLinePieces memoTopicPieces = new ResultSetLinePieces(memoTopic.name());
            if (!memoTopicPieces.isConstant() || agentTopics.contains(memoTopic.reference())) continue;
            this.m_validationHandler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_AGS_UNKNOWN_TOPIC, new Object[]{memoTopic.name()}, SeverityEnum.error));
        }
    }
}

