/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.TaskRun;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseDataIntegrationTask;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.ContentTask;
import com.cognos.developer.schemas.bibus._3.ExportDeployment;
import com.cognos.developer.schemas.bibus._3.ImportDeployment;
import com.cognos.developer.schemas.bibus._3.IndexUpdateTask;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.Locale;

public class UnknownTarget
extends BaseAgentTaskTarget {
    public UnknownTarget(BaseClass type, BaseStepObject parent, JobBiBusHeaders headers) {
        super(type, parent, headers);
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        I18NMessage error = this.getError();
        throw new AgentServiceException(error.getCode(), error.getParams());
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        validateResult.addValidationMessage(this.getError());
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
    }

    @Override
    public ParameterValue[] getParameters() {
        return new ParameterValue[0];
    }

    @Override
    public Option[] getOptions() {
        return new Option[0];
    }

    private I18NMessage getError() {
        I18NMessage message = null;
        BaseClass base = this.getBaseClass();
        if (base instanceof BaseReport) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_REPORT_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof JobDefinition) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_JOB_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof BaseAgentDefinition) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_AGENT_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof ImportDeployment) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_IMPORT_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof ExportDeployment) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_EXPORT_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof IndexUpdateTask) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_INDEX_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof ContentTask) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_CONTENT_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else if (base instanceof BaseDataIntegrationTask) {
            message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_METRIC_TARGET, new Object[]{this.getName()}, SeverityEnum.error);
        } else {
            AgentTaskDefinition atd;
            AgentTaskDefinition agentTaskDefinition = atd = this.getParent() != null ? ((AgentTask)this.getParent()).getAgentTaskDefinition() : null;
            if (atd != null) {
                String param = atd.getDefaultName() != null ? atd.getDefaultName().getValue() : this.getUnknown();
                message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_TASK_OBJECT, new Object[]{param}, SeverityEnum.error);
            } else {
                message = new I18NMessage(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{this.getUnknown()}, SeverityEnum.error);
            }
        }
        return message;
    }

    private String getUnknown() {
        Locale locale = this.getHeaders().getProductLocale();
        return I18NUtil.getMessage((I18NCode)I18NCode.KEY_UNKNOWN, null, (Locale)LocaleUtil.createProductLocale((String)locale.toString()));
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }
}

