/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.humanTask;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.formatters.HTMLDecodeFormatter;
import com.cognos.asv.formatters.HTMLEncodeFormatter;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetMessageBuilder;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.taskTargets.humanTask.HumanTaskHelper;
import com.cognos.asv.xhtml.XHTML;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLSAXHandler;
import com.cognos.asv.xhtml.XHTMLTag;
import com.cognos.asv.xhtml.XHTML_HTMLVisitor;
import com.cognos.asv.xhtml.descriptors.TaskRunDescriptor;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SaveTaskInfoCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SetParameterCmdSpec;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class HumanTaskBuilder {
    private String htsInputMessage;
    private Document htsInputMessageDoc;
    private ResultSetPartition workingPartition;
    private boolean task;
    private JobBiBusHeaders headers;
    private BaseStepObject parent;
    private boolean validatePreview;
    private Guid humanTaskStoreId;
    private String userTopicString;
    private String subjectTopicString;
    private String priorityTopicString;
    private String iconTopicString;
    private Map<String, SetParameterCmdSpec> reportVariables = new HashMap<String, SetParameterCmdSpec>();
    private boolean eventOutputAttached = false;
    private HashMap<String, BaseClass> userCache = new HashMap();
    private TaskRunDescriptor.TASK_TYPE taskType;
    private int taskCount;

    public HumanTaskBuilder(ParameterValue[] parameters, JobBiBusHeaders headers, BaseStepObject parent, Guid humanTaskStoreId, boolean validatePreview) {
        this.htsInputMessage = this.getParameterValue("hts", parameters);
        try {
            this.taskCount = Integer.parseInt(this.getParameterValue("taskCount", parameters));
        }
        catch (NumberFormatException ex) {
            this.taskCount = 0;
        }
        this.headers = headers;
        this.parent = parent;
        this.validatePreview = validatePreview;
        this.humanTaskStoreId = humanTaskStoreId;
    }

    public void parse() throws AgentServiceException {
        try {
            this.htsInputMessageDoc = DocumentHelper.parseText((String)this.htsInputMessage);
        }
        catch (DocumentException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        Node notificationNode = this.htsInputMessageDoc.selectSingleNode("//*[local-name()='beplNotification']");
        Node taskNode = this.htsInputMessageDoc.selectSingleNode("//*[local-name()='beplTask']");
        if (notificationNode == null && taskNode == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR);
        }
        boolean bl = this.task = taskNode != null && notificationNode == null;
        if (taskNode != null) {
            this.taskType = TaskRunDescriptor.TASK_TYPE.APPROVAL;
        } else if (notificationNode != null) {
            this.taskType = TaskRunDescriptor.TASK_TYPE.NOTIFICATION;
        }
        this.replaceLinkItems();
        this.replaceTaskLinkItems();
        this.replaceFutureTaskIds();
        this.userTopicString = null;
        this.subjectTopicString = null;
        this.priorityTopicString = null;
        this.iconTopicString = null;
    }

    public TaskRunDescriptor.TASK_TYPE getType() {
        return this.taskType;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public String getUserTopics() {
        if (this.userTopicString != null) {
            return this.userTopicString;
        }
        List primaryUsers = this.task ? this.htsInputMessageDoc.selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']") : this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List primaryGroups = this.task ? this.htsInputMessageDoc.selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']") : this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List stakeholderUsers = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List stakeholderGroups = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        this.userTopicString = this.addNodeListToString(this.userTopicString, primaryUsers);
        this.userTopicString = this.addNodeListToString(this.userTopicString, primaryGroups);
        this.userTopicString = this.addNodeListToString(this.userTopicString, stakeholderUsers);
        this.userTopicString = this.addNodeListToString(this.userTopicString, stakeholderGroups);
        return this.userTopicString;
    }

    public String getSubjectTopics() {
        List subjectNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='subject']");
        this.subjectTopicString = this.addNodeListToString(this.subjectTopicString, subjectNodes);
        return this.subjectTopicString;
    }

    public String getPriorityTopics() {
        List priorityNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='priority']");
        this.priorityTopicString = this.addNodeListToString(this.priorityTopicString, priorityNodes);
        return this.priorityTopicString;
    }

    public String getIconTopics() {
        List iconNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='taskIconPath']");
        this.iconTopicString = this.addNodeListToString(this.iconTopicString, iconNodes);
        return this.iconTopicString;
    }

    public void setPartition(ResultSetPartition partition) {
        this.workingPartition = partition;
    }

    public ParameterValue[] getParameters() throws AgentServiceException {
        Document newDoc = (Document)this.htsInputMessageDoc.clone();
        this.rebuildBpel(newDoc);
        this.rebuildManualTask(newDoc);
        ParameterValue[] ret_value = this.eventOutputAttached ? new ParameterValue[2] : new ParameterValue[1];
        ret_value[0] = new ParameterValue();
        ret_value[0].setName("hts");
        ParmValueItem[] parmValueItems = new ParmValueItem[1];
        SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
        simpleParmValueItem.setUse(newDoc.asXML());
        simpleParmValueItem.setDisplay("hts");
        simpleParmValueItem.setInclusive(false);
        parmValueItems[0] = simpleParmValueItem;
        ret_value[0].setValue(parmValueItems);
        if (this.eventOutputAttached) {
            BaseStepObjectContainer container = this.getParentTasksContainer(this.parent);
            BaseAgent baseAgent = null;
            if (container instanceof BaseAgent) {
                baseAgent = (BaseAgent)container;
            }
            ret_value[1] = new ParameterValue();
            ret_value[1].setName("eventOutput");
            parmValueItems = new ParmValueItem[1];
            simpleParmValueItem = new SimpleParmValueItem();
            GuidProp hotlistGuid = baseAgent.getAgentOutputHotlist() == null ? null : baseAgent.getAgentOutputHotlist().getStoreID();
            SearchPathSingleObject hotlistSpObj = ObjectModelUtil.getSearchPath((Guid)(hotlistGuid == null ? null : hotlistGuid.getValue()));
            String hotlistSp = hotlistSpObj == null ? null : hotlistSpObj.get_value();
            simpleParmValueItem.setUse("eventOutput:eventOutput:" + hotlistSp);
            simpleParmValueItem.setDisplay("eventOutput");
            simpleParmValueItem.setInclusive(false);
            parmValueItems[0] = simpleParmValueItem;
            ret_value[1].setValue(parmValueItems);
        }
        return ret_value;
    }

    public CmdSpec[] getReportVariables() {
        return this.reportVariables.values().toArray(new CmdSpec[0]);
    }

    private String getParameterValue(String name, ParameterValue[] parameters) {
        String valueStr = "";
        for (int i = 0; i < parameters.length && valueStr.equals(""); ++i) {
            ParameterValue parameterValue = parameters[i];
            if (!parameterValue.getName().equals(name)) continue;
            SimpleParmValueItem parmValueItem = (SimpleParmValueItem)parameterValue.getValue()[0];
            valueStr = parmValueItem.getUse();
        }
        return valueStr;
    }

    private String addNodeListToString(String topicString, List recipientNodeList) {
        if (topicString == null) {
            topicString = "";
        }
        for (Node node : recipientNodeList) {
            topicString = topicString + node.getText() + ";";
        }
        return topicString;
    }

    private void rebuildBpel(Document newDoc) throws AgentServiceException {
        Element recipients = this.buildRecipients();
        Element priority = this.buildPriority();
        Element bpelElement = (Element)newDoc.selectSingleNode("//*[local-name()='beplNotification' or local-name()='beplTask']");
        List childElements = bpelElement.elements();
        for (Element childElement : childElements) {
            childElement.detach();
        }
        for (Element childElement : childElements) {
            if (childElement.getQName().equals((Object)HumanTaskHelper.peopleAssignmentsQN)) {
                bpelElement.add(recipients);
                continue;
            }
            if (childElement.getQName().equals((Object)HumanTaskHelper.priorityQN)) {
                bpelElement.add(priority);
                continue;
            }
            bpelElement.add(childElement);
        }
    }

    private void rebuildManualTask(Document newDoc) throws AgentServiceException {
        Element icon = this.buildIcon();
        Element manualTaskElement = (Element)newDoc.selectSingleNode("//*[local-name()='manualTask']");
        List childElements = manualTaskElement.elements();
        for (Element childElement : childElements) {
            childElement.detach();
        }
        for (Element childElement : childElements) {
            if (childElement.getQName().equals((Object)HumanTaskHelper.iconQN)) {
                manualTaskElement.add(icon);
                continue;
            }
            if (childElement.getQName().equals((Object)HumanTaskHelper.subjectQN)) {
                manualTaskElement.add(this.buildSubject(childElement).remove(0));
                continue;
            }
            if (childElement.getQName().equals((Object)HumanTaskHelper.descriptionQN)) {
                manualTaskElement.add(this.buildDescription(childElement).remove(0));
                continue;
            }
            if (childElement.getQName().equals((Object)HumanTaskHelper.futureTaskListQN)) {
                manualTaskElement.add(this.replaceFutureTaskTopics(childElement));
                continue;
            }
            manualTaskElement.add(childElement);
        }
    }

    private Element replaceFutureTaskTopics(Element futureTaskListElement) {
        futureTaskListElement.detach();
        List displayNodes = futureTaskListElement.selectNodes("./*[local-name()='futureTask']/*[local-name()='display']");
        List<String> displayStrings = this.getNodeListValues(displayNodes);
        for (int i = 0; i < displayNodes.size(); ++i) {
            Node displayNode = (Node)displayNodes.get(i);
            displayNode.setText(displayStrings.get(i));
        }
        return futureTaskListElement;
    }

    private List<Element> buildSubject(Element subjectElement) {
        ArrayList<Element> subjectNodes = new ArrayList<Element>();
        subjectNodes.add(subjectElement);
        List<String> subjectStrings = this.getNodeListValues(subjectNodes);
        ArrayList<Element> subjectElements = new ArrayList<Element>();
        for (int i = 0; i < subjectNodes.size(); ++i) {
            Node newNode = (Node)((Node)subjectNodes.get(i)).clone();
            newNode.setText(subjectStrings.get(i));
            subjectElements.add((Element)newNode.detach());
        }
        return subjectElements;
    }

    private List<Element> buildDescription(Element descriptionElement) throws AgentServiceException {
        ArrayList<Element> descriptionNodes = new ArrayList<Element>();
        descriptionNodes.add(descriptionElement);
        ArrayList<Element> descriptionElements = new ArrayList<Element>();
        for (int i = 0; i < descriptionNodes.size(); ++i) {
            Element description = (Element)descriptionNodes.get(i);
            Attribute contentTypeAttribute = description.attribute("contentType");
            if (contentTypeAttribute != null) {
                String contentTypeAttributeValue = contentTypeAttribute.getText();
                if (contentTypeAttributeValue != null) {
                    if (contentTypeAttributeValue.equals("text/plain")) {
                        descriptionElements.add(this.buildPlainMessageBody());
                        continue;
                    }
                    if (contentTypeAttributeValue.equals("text/html")) {
                        descriptionElements.add(this.buildHTMLMessageBody());
                        continue;
                    }
                    descriptionElements.add(description);
                    continue;
                }
                descriptionElements.add(description);
                continue;
            }
            descriptionElements.add(descriptionElement);
        }
        return descriptionElements;
    }

    private Element buildPriority() {
        List priorityNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='priority']");
        List<String> priorityStrings = this.getNodeListValues(priorityNodes);
        ArrayList<Element> priorityElements = new ArrayList<Element>();
        for (int i = 0; i < priorityNodes.size(); ++i) {
            Node newNode = (Node)((Node)priorityNodes.get(i)).clone();
            newNode.setText(priorityStrings.get(i));
            priorityElements.add((Element)newNode.detach());
        }
        return priorityNodes.size() > 0 ? (Element)priorityElements.get(0) : null;
    }

    private Element buildIcon() {
        List iconNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='taskIconPath']");
        List<String> iconStrings = this.getNodeListValues(iconNodes);
        ArrayList<Element> iconElements = new ArrayList<Element>();
        for (int i = 0; i < iconNodes.size(); ++i) {
            Node newNode = (Node)((Node)iconNodes.get(i)).clone();
            newNode.setText(iconStrings.get(i));
            iconElements.add((Element)newNode.detach());
        }
        return iconNodes.size() > 0 ? (Element)iconElements.get(0) : null;
    }

    private Element buildPlainMessageBody() {
        List plainDescriptionNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/plain']");
        ArrayList<Element> plainDescriptionElements = new ArrayList<Element>();
        for (int i = 0; i < plainDescriptionNodes.size(); ++i) {
            Node newNode = (Node)((Node)plainDescriptionNodes.get(i)).clone();
            String text = ((Node)plainDescriptionNodes.get(i)).getText();
            ResultSetMessageBuilder message_builder = new ResultSetMessageBuilder(this.workingPartition, ResultSetTypeEnum.HTML, text);
            String generatedPlainBody = message_builder.getMessage();
            newNode.setText(generatedPlainBody);
            plainDescriptionElements.add((Element)newNode.detach());
        }
        return plainDescriptionElements.size() > 0 ? (Element)plainDescriptionElements.get(0) : null;
    }

    private Element buildHTMLMessageBody() throws AgentServiceException {
        List htmlDescriptionNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/html']");
        ArrayList<Element> htmlDescriptionElements = new ArrayList<Element>();
        for (int i = 0; i < htmlDescriptionNodes.size(); ++i) {
            Node newNode = (Node)((Node)htmlDescriptionNodes.get(i)).clone();
            List childElements = ((Element)htmlDescriptionNodes.get(i)).elements();
            if (childElements.size() > 0) {
                String htmlText = ((Element)childElements.get(0)).asXML();
                XHTMLSAXHandler handler = new XHTMLSAXHandler();
                XHTML XHTML_processor = new XHTML(new StringReader(htmlText), handler);
                XHTML_processor.parse();
                XHTMLTag messageRootNode = handler.getRoot();
                messageRootNode.visit(new XHTML_HTMLVisitor(this.workingPartition, ResultSetTypeEnum.HTML));
                String generatedBody = ((XHTMLNode)messageRootNode).getText(new HTMLEncodeFormatter(), new HTMLDecodeFormatter()).getText();
                List newChildElements = ((Element)newNode).elements();
                for (Element element : newChildElements) {
                    element.detach();
                }
                try {
                    Document HTMLDoc = DocumentHelper.parseText((String)generatedBody);
                    Node HTMLElement = HTMLDoc.getRootElement().detach();
                    ((Element)newNode).add(HTMLElement);
                }
                catch (DocumentException e) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
                }
            }
            htmlDescriptionElements.add((Element)newNode.detach());
        }
        return htmlDescriptionElements.size() > 0 ? (Element)htmlDescriptionElements.get(0) : null;
    }

    private Element buildRecipients() throws AgentServiceException {
        Element groupElement;
        Element groupsElement;
        Element organizationEntityElement;
        Element literalElement;
        Element fromElement;
        List primaryUserNodes = this.task ? this.htsInputMessageDoc.selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']") : this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List primaryGroupNodes = this.task ? this.htsInputMessageDoc.selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']") : this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List stakeholderUserNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List stakeholderGroupNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List businessAdminGroupNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='businessAdministrators']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List<String> primaryUsers = this.getNodeListValues(primaryUserNodes);
        List<String> primaryGroups = this.getNodeListValues(primaryGroupNodes);
        List<String> stakeholderUsers = this.getNodeListValues(stakeholderUserNodes);
        List<String> stakeholderGroups = this.getNodeListValues(stakeholderGroupNodes);
        List<String> businessAdminGroups = this.getNodeListValues(businessAdminGroupNodes);
        BaseClass[] primaries = this.checkCMRecipients(primaryUsers, primaryGroups);
        BaseClass[] stakeholders = this.checkCMRecipients(stakeholderUsers, stakeholderGroups);
        primaryUsers = this.getUsers(primaries);
        primaryGroups = this.getGroups(primaries);
        stakeholderUsers = this.getUsers(stakeholders);
        stakeholderGroups = this.getGroups(stakeholders);
        Document doc = DocumentHelper.createDocument();
        Element peopleAssignmentsElement = doc.addElement(HumanTaskHelper.peopleAssignmentsQN);
        if (primaryUsers.size() + primaryGroups.size() + stakeholderUsers.size() + stakeholderGroups.size() > 0) {
            Element userElement;
            Element usersElement;
            if (primaryUsers.size() + primaryGroups.size() > 0) {
                Element primaryUsersElement = this.task ? peopleAssignmentsElement.addElement(HumanTaskHelper.potentialOwnersQN) : peopleAssignmentsElement.addElement(HumanTaskHelper.recipientsQN);
                fromElement = primaryUsersElement.addElement(HumanTaskHelper.fromQN);
                fromElement.addAttribute("logicalPeopleGroup", "cam");
                literalElement = fromElement.addElement(HumanTaskHelper.literalQN);
                organizationEntityElement = literalElement.addElement(HumanTaskHelper.organizationalEntityQN);
                if (primaryUsers.size() > 0) {
                    usersElement = organizationEntityElement.addElement(HumanTaskHelper.usersQN);
                    for (String user : primaryUsers) {
                        userElement = usersElement.addElement(HumanTaskHelper.userQN);
                        userElement.addText(user);
                    }
                }
                if (primaryGroups.size() > 0) {
                    groupsElement = organizationEntityElement.addElement(HumanTaskHelper.groupsQN);
                    for (String group : primaryGroups) {
                        groupElement = groupsElement.addElement(HumanTaskHelper.groupQN);
                        groupElement.addText(group);
                    }
                }
            }
            if (stakeholderUsers.size() + stakeholderGroups.size() > 0) {
                Element taskStakeholdersElement = peopleAssignmentsElement.addElement(HumanTaskHelper.taskStakeholdersQN);
                fromElement = taskStakeholdersElement.addElement(HumanTaskHelper.fromQN);
                fromElement.addAttribute("logicalPeopleGroup", "cam");
                literalElement = fromElement.addElement(HumanTaskHelper.literalQN);
                organizationEntityElement = literalElement.addElement(HumanTaskHelper.organizationalEntityQN);
                if (stakeholderUsers.size() > 0) {
                    usersElement = organizationEntityElement.addElement(HumanTaskHelper.usersQN);
                    for (String user : stakeholderUsers) {
                        userElement = usersElement.addElement(HumanTaskHelper.userQN);
                        userElement.addText(user);
                    }
                }
                if (stakeholderGroups.size() > 0) {
                    groupsElement = organizationEntityElement.addElement(HumanTaskHelper.groupsQN);
                    for (String group : stakeholderGroups) {
                        groupElement = groupsElement.addElement(HumanTaskHelper.groupQN);
                        groupElement.addText(group);
                    }
                }
            }
        }
        if (businessAdminGroups.size() > 0) {
            Element businessAdministratorsElement = peopleAssignmentsElement.addElement(HumanTaskHelper.businessAdministratorsQN);
            fromElement = businessAdministratorsElement.addElement(HumanTaskHelper.fromQN);
            fromElement.addAttribute("logicalPeopleGroup", "cam");
            literalElement = fromElement.addElement(HumanTaskHelper.literalQN);
            organizationEntityElement = literalElement.addElement(HumanTaskHelper.organizationalEntityQN);
            groupsElement = organizationEntityElement.addElement(HumanTaskHelper.groupsQN);
            for (String group : businessAdminGroups) {
                groupElement = groupsElement.addElement(HumanTaskHelper.groupQN);
                groupElement.addText(group);
            }
        }
        return (Element)peopleAssignmentsElement.detach();
    }

    protected void replaceLinkItems() throws AgentServiceException {
        List linkNodes;
        if (!this.validatePreview && (linkNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='linksList']/*[local-name()='link']")) != null && linkNodes.size() > 0) {
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>(linkNodes.size());
            for (Object linkNode : linkNodes) {
                Node linkIDNode = ((Node)linkNode).selectSingleNode("./*[local-name()='id']");
                QueryRequest linkRequest = new QueryRequest();
                linkRequest.setSearch(linkIDNode.getText());
                linkRequest.setProperties(new PropEnum[]{PropEnum.objectClass, PropEnum.searchPath, PropEnum.storeID});
                requests.add(linkRequest);
            }
            BaseClass[] replies = this.queryCMObjects(requests.toArray(new QueryRequest[0]));
            if (replies != null && replies.length == linkNodes.size()) {
                for (int i = 0; i < replies.length; ++i) {
                    if (replies[i] == null) continue;
                    BaseClass baseClass = replies[i];
                    Node linkIDNode = ((Node)linkNodes.get(i)).selectSingleNode("./*[local-name()='id']");
                    linkIDNode.setText(baseClass.getStoreID().getValue().get_value());
                }
            }
        }
    }

    protected void replaceTaskLinkItems() {
        List taskLinkNodes;
        BaseStepObjectContainer container = this.getParentTasksContainer(this.parent);
        BaseAgent baseAgent = null;
        if (container instanceof BaseAgent) {
            baseAgent = (BaseAgent)container;
        }
        if ((taskLinkNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='taskLinksList']/*[local-name()='taskLink']")) != null && taskLinkNodes.size() > 0) {
            for (int i = 0; i < taskLinkNodes.size(); ++i) {
                Node taskLinkNode = (Node)taskLinkNodes.get(i);
                Node taskLinkIDNode = taskLinkNode.selectSingleNode("./*[local-name()='id']");
                String id = taskLinkIDNode.getText();
                if (id.equals("eventOutput")) {
                    if (!this.validatePreview) {
                        taskLinkIDNode.setText("?eventOutput?");
                    }
                    this.eventOutputAttached = true;
                    Node taskLinkDisplayNode = taskLinkNode.selectSingleNode("./*[local-name()='display']");
                    String agName = baseAgent.getBaseClass().getDefaultName() == null ? "" : baseAgent.getBaseClass().getDefaultName().getValue();
                    taskLinkDisplayNode.setText(agName);
                    continue;
                }
                AgentTask attachedTask = this.getAttachedTask(id);
                if (attachedTask == null) continue;
                BaseAgentTaskTarget attachedTarget = this.getAttachedTarget(attachedTask);
                if (!this.validatePreview) {
                    id = this.replaceSearchPathForTSE(id, attachedTarget);
                    taskLinkIDNode.setText("?" + attachedTask.getStoreID().get_value() + "?");
                    if (id != null && !this.reportVariables.containsKey(id)) {
                        SetParameterCmdSpec setSPParameterCmd = new SetParameterCmdSpec(baseAgent.getParentTaskID(), id, id, null);
                        this.reportVariables.put(id, setSPParameterCmd);
                    }
                }
                attachedTarget.addDependentStepId(this.humanTaskStoreId);
            }
        }
    }

    protected void replaceFutureTaskIds() {
        List futureTaskNodes;
        BaseStepObjectContainer container = this.getParentTasksContainer(this.parent);
        BaseAgent baseAgent = null;
        if (container instanceof BaseAgent) {
            baseAgent = (BaseAgent)container;
        }
        if ((futureTaskNodes = this.htsInputMessageDoc.selectNodes("//*[local-name()='manualTask']/*[local-name()='futureTaskList']/*[local-name()='futureTask']")) != null && futureTaskNodes.size() > 0) {
            for (int i = 0; i < futureTaskNodes.size(); ++i) {
                Node futureTaskNode = (Node)futureTaskNodes.get(i);
                Node futureTaskIDNode = futureTaskNode.selectSingleNode("./*[local-name()='id']");
                String id = futureTaskIDNode.getText();
                AgentTask attachedTask = this.getAttachedTask(id);
                if (attachedTask == null || this.validatePreview) continue;
                id = attachedTask.getStoreID().get_value();
                futureTaskIDNode.setText("?" + id + "?");
            }
        }
    }

    protected BaseClass[] checkCMRecipients(List<String> users, List<String> groups) throws AgentServiceException {
        ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>(users.size() + groups.size());
        for (String user : users) {
            QueryRequest userRequest = new QueryRequest();
            userRequest.setSearch(user);
            userRequest.setProperties(new PropEnum[]{PropEnum.objectClass, PropEnum.searchPath, PropEnum.storeID});
            requests.add(userRequest);
        }
        for (String group : groups) {
            QueryRequest groupRequest = new QueryRequest();
            groupRequest.setSearch(group);
            groupRequest.setProperties(new PropEnum[]{PropEnum.objectClass, PropEnum.searchPath, PropEnum.storeID});
            requests.add(groupRequest);
        }
        return this.queryCMObjects(requests.toArray(new QueryRequest[0]));
    }

    protected BaseClass[] queryCMObjects(QueryRequest[] requests) throws AgentServiceException {
        ArrayList<QueryRequest> requestsToMake = new ArrayList<QueryRequest>();
        for (int i = 0; i < requests.length; ++i) {
            if (this.userCache.containsKey(requests[i].getSearch())) continue;
            requestsToMake.add(requests[i]);
        }
        int batch_size = 100;
        while (requestsToMake.size() > 0) {
            List<Object> batch_requests = null;
            batch_requests = requestsToMake.size() > batch_size ? requestsToMake.subList(0, batch_size) : requestsToMake;
            this.queryCMObjects(batch_requests);
            batch_requests.clear();
        }
        BaseClass[] baseClasses = new BaseClass[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            baseClasses[i] = this.userCache.get(requests[i].getSearch());
        }
        return baseClasses;
    }

    private void queryCMObjects(List<QueryRequest> requestsToMake) throws AgentServiceException {
        QueryReply[] replies = null;
        if (requestsToMake.size() > 0) {
            ContentManagerServiceClientPort cm_port = this.getCMPort();
            try {
                replies = cm_port.queryMultiple(requestsToMake.toArray(new QueryRequest[0]));
            }
            catch (SDKClientException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (EMFSecurityException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            finally {
                if (cm_port != null) {
                    cm_port.close();
                }
            }
            if (replies != null && replies.length > 0) {
                for (int i = 0; i < replies.length; ++i) {
                    BaseClass[] replyBaseClasses = replies[i].getQueryResult();
                    if (replyBaseClasses == null || replyBaseClasses.length != 1) continue;
                    BaseClass replyBaseClass = replyBaseClasses[0];
                    this.userCache.put(requestsToMake.get(i).getSearch(), replyBaseClass);
                }
            }
        }
    }

    private List<String> getUsers(BaseClass[] replies) {
        HashSet<String> users = new HashSet<String>();
        if (replies != null) {
            for (BaseClass reply : replies) {
                if (reply == null || !(reply instanceof Account)) continue;
                users.add(reply.getSearchPath().getValue());
            }
        }
        return new ArrayList<String>(users);
    }

    private List<String> getGroups(BaseClass[] replies) {
        HashSet<String> groups = new HashSet<String>();
        if (replies != null) {
            for (BaseClass reply : replies) {
                if (reply == null || reply instanceof Account) continue;
                groups.add(reply.getSearchPath().getValue());
            }
        }
        return new ArrayList<String>(groups);
    }

    private List<String> getNodeListValues(List nodeList) {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (Node node : nodeList) {
            Iterator it2;
            String nodeValue = node.getText();
            ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(this.workingPartition, ResultSetTypeEnum.XML, nodeValue);
            if (!lineBuilder.isConstant() && (it2 = this.workingPartition.getData()).hasNext()) {
                ResultSetKey rsk = (ResultSetKey)it2.next();
                nodeValue = lineBuilder.buildLine(rsk);
            }
            returnValue.add(nodeValue);
        }
        return returnValue;
    }

    ContentManagerServiceClientPort getCMPort() {
        return Client.instance().getContentManagerServiceClient(this.headers);
    }

    private AgentTask getAttachedTask(String id) {
        AgentTask agentTask = null;
        if (null != this.parent) {
            List<BaseStepObject> steps = this.getParentTasksContainer(this.parent).getSubSteps();
            for (BaseStepObject step : steps) {
                AgentTask taskStep;
                if (!(step instanceof AgentTask) || !id.equals((taskStep = (AgentTask)step).getSearchPathStoreID()) && !id.equals(taskStep.getSearchPath()) && !id.equals(taskStep.getBaseClass().getDefaultName().getValue())) continue;
                agentTask = taskStep;
                break;
            }
        }
        return agentTask;
    }

    private BaseAgentTaskTarget getAttachedTarget(AgentTask agentTask) {
        List<BaseStepObject> targets = agentTask.getSubSteps();
        BaseStepObject obj = targets.get(0);
        return (BaseAgentTaskTarget)obj;
    }

    private BaseStepObjectContainer getParentTasksContainer(BaseStepObject parent) {
        return (BaseStepObjectContainer)parent.getParent();
    }

    private String replaceSearchPathForTSE(String id, BaseAgentTaskTarget attachedTarget) {
        String reportSPVarName = null;
        if (!attachedTarget.SaveTaskInfoCmdExistsForTaskID()) {
            reportSPVarName = attachedTarget.saveTaskInfoVariable();
        } else {
            SaveTaskInfoCmdSpec savedSpec = attachedTarget.getSaveTaskInfoCmdSpecForTaskID();
            reportSPVarName = savedSpec.reportVar;
        }
        return reportSPVarName;
    }
}

