/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.humanTask;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentPreviewBuilder;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.humanTask.HTSNotificationValidator;
import com.cognos.asv.taskTargets.humanTask.HTSTaskValidator;
import com.cognos.asv.taskTargets.humanTask.HTSValidator;
import com.cognos.asv.taskTargets.humanTask.HumanTaskHelper;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.jsmcommon.http.HTTPRequest;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskStatus;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.cognos.spec.previewAgent.castor.AgentPreview;
import com.cognos.spec.previewAgent.castor.AgentTaskPreview;
import com.cognos.spec.previewAgent.castor.OutputInfo;
import com.cognos.spec.previewAgent.castor.OutputInfos;
import com.cognos.spec.previewAgent.castor.TaskRunPreview;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;

public class HumanTaskRunnable
extends BaseStepObject
implements IAGSWSDLConstants {
    public static String WS_ADDRESSING_HEADER_NAME = "US-ADDRESSING";

    public HumanTaskRunnable(HumanTask webTask, BaseStepObject parent, JobBiBusHeaders headers) {
        super((BaseClass)webTask, parent, headers);
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getSubmitParameters();
    }

    @Override
    public Option[] getOptions() {
        return this.getSubmitOptions();
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        TaskRunInfo taskRunInfo = new TaskRunInfo(ResolveOptionsUtil.resolveOptions(this), this.getParameters());
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        I18NMessage[] errors = new I18NMessage[]{};
        try {
            this.validateAndRun(validateResult);
        }
        catch (AgentServiceException ase) {
            errors = new I18NMessage[]{new I18NMessage(ase.getI18NCode(), ase.getParams(), SeverityEnum.warn)};
        }
        validateResult.addValidationMessages(errors);
    }

    private void validateAndRun(ValidationResultHandler validationResult) throws AgentServiceException {
        if (validationResult != null) {
            this.doHumanTaskValidation(validationResult);
        } else {
            String agentEventId = this.extractParentEventIDfromOptions(this.getSubmitOptions());
            String eventId = this.extractEventIDfromOptions(this.getSubmitOptions());
            String wsAddressingHeader = null;
            try {
                wsAddressingHeader = this.generateWSAddressingHeader(eventId, agentEventId);
            }
            catch (PropertiesException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            BiBusHeader header = this.getHeaders().getBiBusHeader();
            String previewFromParameters = this.getPreviewFromParameters(agentEventId);
            BIBusEnvelope SOAP = BiBusUtilities.getHeadedEnvelope((BiBusHeader)header);
            Element soapHeaderElement = SOAP.getHeader();
            Element soapBody = SOAP.getBody();
            Document WSAddressingDoc = null;
            Document previewXMLDoc = null;
            Document bodyDoc = null;
            SimpleParmValueItem paramValue = this.getHTSParameter();
            String bodyDocText = paramValue.getUse();
            try {
                WSAddressingDoc = DocumentHelper.parseText((String)wsAddressingHeader);
                previewXMLDoc = DocumentHelper.parseText((String)previewFromParameters);
                bodyDoc = DocumentHelper.parseText((String)bodyDocText);
            }
            catch (DocumentException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            Element manualTaskElement = (Element)bodyDoc.selectSingleNode("//*[local-name()='manualTask']");
            if (manualTaskElement != null) {
                QName previewQName = new QName("preview", HumanTaskHelper.NS_HTS);
                Element previewElement = manualTaskElement.element(previewQName);
                if (previewElement == null) {
                    previewElement = manualTaskElement.addElement(previewQName);
                }
                previewElement.add(previewXMLDoc.getRootElement().detach());
            }
            soapHeaderElement.add(WSAddressingDoc.getRootElement().detach());
            soapBody.add(bodyDoc.getRootElement().detach());
            HTTPRequest request = new HTTPRequest("http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1");
            String response = null;
            try {
                StringWriter aWriter = new StringWriter();
                OutputFormat format = new OutputFormat();
                format.setNewLineAfterDeclaration(false);
                XMLWriter xmlWriter = new XMLWriter((Writer)aWriter, format);
                xmlWriter.write(SOAP.getAsDocument());
                xmlWriter.flush();
                request.setRequestBody(aWriter.toString());
                response = request.retrieveContent();
            }
            catch (IOException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (LocalizableException e) {
                throw new AgentServiceException(e);
            }
            BIBusEnvelope responseEnvelope = null;
            try {
                responseEnvelope = new BIBusEnvelope((Reader)new StringReader(response));
                if (responseEnvelope.getFaultString() != null) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(responseEnvelope.toString());
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{responseEnvelope.getFaultString()});
                }
            }
            catch (SOAPException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
        }
    }

    private SimpleParmValueItem getHTSParameter() {
        SimpleParmValueItem valueItem = null;
        ParameterValue[] paramValueArr = this.getParameters();
        ParameterValue paramValue = ObjectModelUtil.findParameter((ParameterValue[])paramValueArr, (String)"hts");
        ParmValueItem[] valueItemArr = paramValue.getValue();
        if (valueItemArr.length > 0 && valueItemArr[0] instanceof SimpleParmValueItem) {
            valueItem = (SimpleParmValueItem)valueItemArr[0];
        }
        return valueItem;
    }

    private void doHumanTaskValidation(ValidationResultHandler validationResult) throws AgentServiceException {
        BaseClass baseClass = this.getBaseClass();
        SimpleParmValueItem paramValue = this.getHTSParameter();
        if (paramValue != null) {
            Element beplTask;
            Document humanTaskXMLDoc;
            String htsValue = paramValue.getUse();
            try {
                humanTaskXMLDoc = DocumentHelper.parseText((String)htsValue);
            }
            catch (DocumentException ex) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, ex);
            }
            HTSValidator validator = null;
            Element notificationTask = (Element)humanTaskXMLDoc.selectSingleNode("//*[local-name()='beplNotification']");
            if (notificationTask != null) {
                validator = new HTSNotificationValidator(humanTaskXMLDoc, validationResult, this.getHeaders());
            }
            if ((beplTask = (Element)humanTaskXMLDoc.selectSingleNode("//*[local-name()='beplTask']")) != null) {
                validator = new HTSTaskValidator(humanTaskXMLDoc, validationResult, this.getHeaders());
            }
            if (validator != null) {
                ((HTSValidator)validator).validate();
            }
        }
    }

    private String generateWSAddressingHeader(String eventId, String agentEventId) throws PropertiesException {
        String urlString = CRNProperties.getInstance().getProperty("internalDispatcher");
        String responseAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
        String addressingHeader = "<wsa:ReplyTo xmlns:ext='http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext' xmlns:wsa='http://www.w3.org/2005/08/addressing' xmlns:ns1='" + responseAction + "'>" + "<wsa:Address>" + urlString + "</wsa:Address>" + "<wsa:ReferenceParameters>" + "<ns1:eventId>" + eventId + "</ns1:eventId>" + "<ns1:parentEventId>" + agentEventId + "</ns1:parentEventId>" + "</wsa:ReferenceParameters>" + "<wsa:Metadata>" + " <ext:responseAction>" + responseAction + "</ext:responseAction>" + "</wsa:Metadata>" + "</wsa:ReplyTo>";
        return addressingHeader;
    }

    private String getPreviewXML(String eventId) {
        String previewXml = "";
        try {
            AgentPreviewBuilder builder = new AgentPreviewBuilder(this.getHeaders());
            previewXml = builder.getAgentPreview(eventId);
            previewXml = "<tsePreview>" + previewXml + "</tsePreview>";
        }
        catch (AgentServiceException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        return previewXml;
    }

    private String getPreviewFromParameters(String agentEventId) throws AgentServiceException {
        String previewXML = "";
        boolean eventOutputAttached = false;
        try {
            String[] splitValues;
            AgentPreview agentPreview = new AgentPreview();
            agentPreview.setAgentStoreId(agentEventId);
            agentPreview.setName("preview");
            ParameterValue[] parameters = this.getParameters();
            ArrayList<ParameterValue> versionParameters = new ArrayList<ParameterValue>();
            ParameterValue taskStatusParameter = null;
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].getName().equals("taskStatus")) {
                        taskStatusParameter = parameters[i];
                        continue;
                    }
                    if (parameters[i].getName().equals("eventOutput")) {
                        eventOutputAttached = true;
                    }
                    if (parameters[i].getName().equals("hts")) continue;
                    versionParameters.add(parameters[i]);
                }
            }
            Hashtable<String, AgentTaskPreview> agentTaskPreviewMap = new Hashtable<String, AgentTaskPreview>();
            int numAgentTaskPreview = taskStatusParameter.getValue().length;
            ArrayList<AgentTaskPreview> agentTaskPreviewArray = new ArrayList<AgentTaskPreview>();
            if (eventOutputAttached) {
                AgentTaskPreview agentTaskPreview = new AgentTaskPreview();
                String EVENT_OUTPUT = "eventOutput";
                agentTaskPreview.setName("?eventOutput?");
                agentTaskPreview.setTargetStoreId("eventOutput");
                agentTaskPreview.setFailed(false);
                TaskRunPreview taskRunPreview = new TaskRunPreview();
                taskRunPreview.setEventId("eventOutput");
                taskRunPreview.setStatus("COMPLETED");
                agentTaskPreview.setTaskRunPreview(new TaskRunPreview[]{taskRunPreview});
                agentTaskPreviewMap.put("eventOutput", agentTaskPreview);
                agentTaskPreviewArray.add(agentTaskPreview);
            }
            for (int i = 0; i < taskStatusParameter.getValue().length; ++i) {
                SimpleParmValueItem simpleParmValue = (SimpleParmValueItem)taskStatusParameter.getValue()[i];
                String value = simpleParmValue.getUse();
                splitValues = value.split(":");
                String eventID = splitValues[0];
                String targetStoreID = splitValues[1];
                String status = splitValues[2];
                AgentTaskPreview agentTaskPreview = new AgentTaskPreview();
                agentTaskPreview.setName("?" + targetStoreID + "?");
                agentTaskPreview.setTargetStoreId(targetStoreID);
                agentTaskPreview.setFailed(TaskStatus.FAILED.toString().equals(status));
                TaskRunPreview taskRunPreview = new TaskRunPreview();
                taskRunPreview.setEventId(eventID);
                taskRunPreview.setStatus(status);
                agentTaskPreview.setTaskRunPreview(new TaskRunPreview[]{taskRunPreview});
                agentTaskPreviewMap.put(eventID, agentTaskPreview);
                agentTaskPreviewArray.add(agentTaskPreview);
            }
            agentPreview.setAgentTaskPreview(agentTaskPreviewArray.toArray(new AgentTaskPreview[0]));
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>(versionParameters.size());
            for (int i = 0; i < versionParameters.size(); ++i) {
                QueryRequest linkRequest = new QueryRequest();
                splitValues = ((SimpleParmValueItem)((ParameterValue)versionParameters.get(i)).getValue()[0]).getUse().split(":");
                String versionStoreIDSearchPath = splitValues[2];
                linkRequest.setSearch(versionStoreIDSearchPath + "/output");
                linkRequest.setProperties(new PropEnum[]{PropEnum.objectClass, PropEnum.searchPath, PropEnum.storeID, PropEnum.format, PropEnum.locale});
                requests.add(linkRequest);
            }
            QueryReply[] replies = this.queryCMObjects(requests.toArray(new QueryRequest[0]));
            if (replies != null && replies.length == requests.size()) {
                for (int i = 0; i < replies.length; ++i) {
                    BaseClass[] baseClasses;
                    String parameterName = ((ParameterValue)versionParameters.get(i)).getName();
                    String[] splitValues2 = ((SimpleParmValueItem)((ParameterValue)versionParameters.get(i)).getValue()[0]).getUse().split(":");
                    String eventID = splitValues2[0];
                    String targetStoreID = splitValues2[1];
                    if (replies[i] == null || (baseClasses = replies[i].getQueryResult()) == null || baseClasses.length <= 0) continue;
                    AgentTaskPreview agentTaskPreview = (AgentTaskPreview)agentTaskPreviewMap.get(eventID);
                    TaskRunPreview taskRunPreview = agentTaskPreview.getTaskRunPreview()[0];
                    agentTaskPreview.setName("?" + targetStoreID + "?");
                    OutputInfos outputInfos = new OutputInfos();
                    ArrayList<OutputInfo> outputInfoArray = new ArrayList<OutputInfo>();
                    taskRunPreview.setOutputInfos(outputInfos);
                    for (int j = 0; j < baseClasses.length; ++j) {
                        if (baseClasses[j] == null) continue;
                        Output output = (Output)baseClasses[j];
                        OutputInfo outputInfo = new OutputInfo();
                        outputInfo.setName(eventID);
                        outputInfo.setFormat(output.getFormat().getValue());
                        outputInfo.setLocale(output.getLocale().getValue());
                        outputInfo.setId(output.getStoreID().getValue().get_value());
                        outputInfoArray.add(outputInfo);
                    }
                    outputInfos.setOutputInfo(outputInfoArray.toArray(new OutputInfo[0]));
                }
            }
            StringWriter writer = new StringWriter();
            try {
                Marshaller marsh = new Marshaller((Writer)writer);
                marsh.setMarshalAsDocument(false);
                marsh.marshal((Object)agentPreview);
            }
            catch (IOException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (MarshalException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (ValidationException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            previewXML = "<tsePreview>" + writer.toString() + "</tsePreview>";
        }
        catch (AgentServiceException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
            throw e;
        }
        return previewXML;
    }

    private String extractEventIDfromOptions(Option[] options) {
        AsynchOptionStringArray aosa;
        String[] ids;
        String eventID = null;
        Option o = OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext);
        if (o != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 1) {
            eventID = ids[ids.length - 1];
        }
        return eventID;
    }

    private String extractParentEventIDfromOptions(Option[] options) {
        AsynchOptionStringArray aosa;
        String[] ids;
        String eventID = null;
        Option o = OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext);
        if (o != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 1) {
            int index = ids.length - 2 < 0 ? 0 : ids.length - 2;
            eventID = ids[index];
        }
        return eventID;
    }

    protected QueryReply[] queryCMObjects(QueryRequest[] requests) throws AgentServiceException {
        QueryReply[] replies = null;
        if (requests.length > 0) {
            ContentManagerServiceClientPort cm_port = this.getCMPort();
            try {
                replies = cm_port.queryMultiple(requests);
            }
            catch (SDKClientException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            catch (EMFSecurityException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
            }
            finally {
                if (cm_port != null) {
                    cm_port.close();
                }
            }
        }
        return replies;
    }

    public static String getEnvVar(BiBusHeader header, String name) {
        String value = "";
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null) {
            EnvironmentVar[] envVars = hdrSession.getEnvironmentVars();
            for (int i = 0; i < envVars.length; ++i) {
                if (!envVars[i].getName().equals(name)) continue;
                value = envVars[i].getValue();
                break;
            }
        }
        return value;
    }

    public static void setUserPrefVar(BiBusHeader header, String name, String value) {
        UserPreferenceVar[] userPrefVars = header.getUserPreferenceVars();
        UserPreferenceVar[] userPrefVars2 = new UserPreferenceVar[userPrefVars.length + 1];
        System.arraycopy(userPrefVars, 0, userPrefVars2, 1, userPrefVars.length);
        userPrefVars2[0] = new UserPreferenceVar();
        userPrefVars2[0].setName(name);
        userPrefVars2[0].setValue(value);
        header.setUserPreferenceVars(userPrefVars2);
    }

    ContentManagerServiceClientPort getCMPort() {
        return Client.instance().getContentManagerServiceClient(this.getHeaders());
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.validateAndRun(null);
    }
}

