/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.webServiceTask;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.xts.util.ByteArrayIOStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.ParseException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;

public class ASVWebServiceResult {
    private Reader m_wsdlResultReader = null;
    private String m_contentType = "text/xml";
    private boolean isFaultResponse = false;

    private ASVWebServiceResult() {
    }

    public ASVWebServiceResult(String[] faultDetails) throws AgentServiceException {
        StringBuffer resultStartBuf = new StringBuffer();
        this.isFaultResponse = true;
        resultStartBuf.append("<FAULT>");
        if (faultDetails != null) {
            for (int i = 0; i < faultDetails.length; ++i) {
                resultStartBuf.append("<FAULTDETAILS>");
                resultStartBuf.append(" " + faultDetails[i]);
                resultStartBuf.append("</FAULTDETAILS>");
            }
        }
        resultStartBuf.append("</FAULT>");
        this.m_wsdlResultReader = new BufferedReader(new StringReader(resultStartBuf.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASVWebServiceResult(String[] outNames, Class[] outTypes, WSIFMessage output) throws AgentServiceException {
        StringBuffer resultStartBuf = new StringBuffer();
        resultStartBuf.append("<RESULT>");
        for (int results = 0; results < outNames.length; ++results) {
            String theResultName = outNames[results];
            resultStartBuf.append("<NAME>");
            resultStartBuf.append(theResultName);
            resultStartBuf.append("</NAME>");
            String s = "";
            if (outTypes[results] != null) {
                s = outTypes[results].getName();
            }
            resultStartBuf.append("<VALUE ");
            resultStartBuf.append("TYPE=\"");
            resultStartBuf.append(s);
            resultStartBuf.append("\">");
            try {
                if (s.compareToIgnoreCase("string") == 0) {
                    resultStartBuf.append((String)output.getObjectPart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("double") == 0) {
                    resultStartBuf.append(output.getDoublePart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("float") == 0) {
                    resultStartBuf.append(output.getFloatPart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("long") == 0) {
                    resultStartBuf.append(output.getLongPart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("byte") == 0) {
                    resultStartBuf.append(output.getBytePart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("int") == 0) {
                    resultStartBuf.append(output.getIntPart(theResultName));
                    continue;
                }
                if (s.compareToIgnoreCase("boolean") == 0) {
                    resultStartBuf.append(output.getBooleanPart(theResultName));
                    continue;
                }
                resultStartBuf.append((String)output.getObjectPart(theResultName));
                continue;
            }
            catch (WSIFException e) {
                resultStartBuf.append("complex value");
                continue;
            }
            finally {
                resultStartBuf.append("</VALUE>");
            }
        }
        resultStartBuf.append("</RESULT>");
        this.m_wsdlResultReader = new BufferedReader(new StringReader(resultStartBuf.toString()));
    }

    public void release() throws AgentServiceException {
    }

    public boolean protocolHeaderSupported() {
        return false;
    }

    public InputStream getAttachmentInputStream() throws AgentServiceException {
        return null;
    }

    public InternetHeaders getProtocolHeaders() throws AgentServiceException {
        return null;
    }

    public ContentType getDefaultMimeType() throws AgentServiceException {
        ContentType contentType = null;
        try {
            contentType = new ContentType(this.m_contentType);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return contentType;
    }

    public boolean attachmentsSupported() {
        return false;
    }

    public void writeCopyTo(OutputStream out) throws AgentServiceException {
        try {
            ByteArrayIOStream bio = new ByteArrayIOStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bio, "UTF-8"));
            char[] buf = new char[4096];
            int bytesRead = this.m_wsdlResultReader.read(buf, 0, 4096);
            while (bytesRead != -1) {
                ((Writer)writer).write(buf, 0, bytesRead);
                bytesRead = this.m_wsdlResultReader.read(buf, 0, 4096);
            }
            ((Writer)writer).flush();
            bio.writeTo(out);
            this.m_wsdlResultReader = new BufferedReader(new InputStreamReader((InputStream)bio.convert(), "UTF-8"));
        }
        catch (IOException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
    }

    OutputStream getFault() throws AgentServiceException {
        ByteArrayIOStream x = new ByteArrayIOStream();
        if (this.isFaulted()) {
            this.writeCopyTo((OutputStream)x);
        }
        return x;
    }

    boolean isFaulted() {
        return this.isFaultResponse;
    }
}

