/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.formatters.FormatterPair;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.xhtml.XHTMLGetTextResultPiece;
import com.cognos.asv.xhtml.XHTMLGetTextResultReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public final class XHTMLGetTextResult {
    private ArrayList m_pieces = new ArrayList();

    public XHTMLGetTextResult() {
    }

    public XHTMLGetTextResult(String text) {
        this.m_pieces.add(new XHTMLGetTextResultPiece(text));
    }

    public void append(XHTMLGetTextResult rhs) {
        for (XHTMLGetTextResultPiece rhs_piece : rhs.m_pieces) {
            this.append(rhs_piece);
        }
    }

    public boolean isConstant() {
        boolean constant = true;
        Iterator it = this.m_pieces.iterator();
        while (it.hasNext()) {
            constant = constant && ((XHTMLGetTextResultPiece)it.next()).isConstant();
        }
        return constant;
    }

    public boolean isComplete() {
        boolean complete = true;
        Iterator it = this.m_pieces.iterator();
        while (it.hasNext()) {
            complete = complete && ((XHTMLGetTextResultPiece)it.next()).isComplete();
        }
        return complete;
    }

    public String getTopicString() {
        StringBuffer buffer = new StringBuffer("");
        Set topicSet = this.getTopics();
        Iterator topicIt = topicSet.iterator();
        while (topicIt.hasNext()) {
            buffer.append(((ResultSetTopic)topicIt.next()).toString());
        }
        return buffer.toString();
    }

    public Set getTopics() {
        TreeSet<ResultSetTopic> topicSet = new TreeSet<ResultSetTopic>();
        for (XHTMLGetTextResultPiece piece : this.m_pieces) {
            Set topics = piece.getTopics();
            for (ResultSetTopic topic : topics) {
                if (topicSet.contains(topic)) continue;
                topicSet.add(topic);
            }
        }
        return topicSet;
    }

    public void applyResultSet(ResultSet resultSet, ResultSetTypeEnum type, Formatter encoder, Formatter decoder) {
        if (this.m_pieces.size() == 1) {
            this.specialApplyResultSet(resultSet, type, encoder, decoder);
        } else {
            this.generalApplyResultSet(resultSet, type, encoder, decoder);
        }
    }

    private void generalApplyResultSet(ResultSet resultSet, ResultSetTypeEnum type, Formatter encoder, Formatter decoder) {
        ArrayList<Object> lineBuilders = new ArrayList<Object>();
        for (XHTMLGetTextResultPiece piece : this.m_pieces) {
            if (!piece.isComplete()) {
                ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(resultSet, type, piece.getText(), new FormatterPair(encoder, decoder));
                lineBuilders.add(lineBuilder);
                continue;
            }
            lineBuilders.add(piece);
        }
        XHTMLGetTextResult result = new XHTMLGetTextResult();
        Iterator keySetIterator = resultSet.getData();
        while (keySetIterator.hasNext()) {
            ResultSetKey key = (ResultSetKey)keySetIterator.next();
            for (Object e : lineBuilders) {
                if (e instanceof XHTMLGetTextResultPiece) {
                    result.append((XHTMLGetTextResultPiece)e);
                    continue;
                }
                if (!(e instanceof ResultSetLineBuilder)) continue;
                ResultSetLineBuilder lineBuilder = (ResultSetLineBuilder)e;
                result.append(lineBuilder.buildLine(key));
            }
        }
        this.m_pieces = result.m_pieces;
    }

    private void specialApplyResultSet(ResultSet resultSet, ResultSetTypeEnum type, Formatter encoder, Formatter decoder) {
        XHTMLGetTextResultPiece piece = (XHTMLGetTextResultPiece)this.m_pieces.get(0);
        ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(resultSet, type, piece.getText(), new FormatterPair(encoder, decoder));
        this.m_pieces = new ArrayList();
        this.m_pieces.add(new XHTMLGetTextResultPiece(resultSet, lineBuilder));
    }

    public void complete() {
        for (XHTMLGetTextResultPiece piece : this.m_pieces) {
            piece.markCompleted();
        }
    }

    public Reader getReader() {
        return new XHTMLGetTextResultReader(this.m_pieces);
    }

    public String getText() {
        StringBuffer ret_value = new StringBuffer(this.size());
        for (XHTMLGetTextResultPiece piece : this.m_pieces) {
            String text = piece.getText();
            ResultSetLinePieces pieces = new ResultSetLinePieces(text);
            ret_value.append(pieces.toString());
        }
        return ret_value.toString();
    }

    private void append(String piece) {
        if (this.m_pieces.isEmpty()) {
            this.m_pieces.add(new XHTMLGetTextResultPiece(piece));
        } else {
            XHTMLGetTextResultPiece end_piece = (XHTMLGetTextResultPiece)this.m_pieces.get(this.m_pieces.size() - 1);
            if (end_piece.isComplete()) {
                this.m_pieces.add(new XHTMLGetTextResultPiece(piece));
            } else {
                end_piece.append(piece);
            }
        }
    }

    private void append(XHTMLGetTextResultPiece piece) {
        if (this.m_pieces.isEmpty()) {
            this.m_pieces.add(piece);
        } else {
            XHTMLGetTextResultPiece end_piece = (XHTMLGetTextResultPiece)this.m_pieces.get(this.m_pieces.size() - 1);
            if (!end_piece.isComplete() && !piece.isComplete()) {
                end_piece.append(piece);
            } else {
                this.m_pieces.add(piece);
            }
        }
    }

    public String toString() {
        StringBuffer ret_value = new StringBuffer(this.size());
        for (XHTMLGetTextResultPiece piece : this.m_pieces) {
            ret_value.append(piece.toString());
        }
        return ret_value.toString();
    }

    private int size() {
        Iterator it = this.m_pieces.iterator();
        int size = 0;
        while (it.hasNext()) {
            XHTMLGetTextResultPiece piece = (XHTMLGetTextResultPiece)it.next();
            size += piece.length();
        }
        return size;
    }
}

