/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetLinePieces;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

final class XHTMLGetTextResultPiece {
    private ResultSet m_rs;
    private ResultSetLineBuilder m_lineBuilder;
    private StringBuffer m_text;
    private Hashtable m_hashtable;
    private boolean m_complete = false;

    public XHTMLGetTextResultPiece(ResultSet rs, ResultSetLineBuilder lineBuilder) {
        this.m_rs = rs;
        this.m_lineBuilder = lineBuilder;
    }

    public XHTMLGetTextResultPiece(StringBuffer text) {
        this.m_text = text;
    }

    public XHTMLGetTextResultPiece(String text) {
        this.m_text = new StringBuffer(text);
    }

    public Iterator keyIterator() {
        Iterator keyIterator = null;
        if (this.m_rs != null) {
            keyIterator = this.m_rs.getData();
        } else {
            this.m_hashtable = new Hashtable();
            this.m_hashtable.put("key", this.m_text.toString());
            keyIterator = this.m_hashtable.keySet().iterator();
        }
        return keyIterator;
    }

    public String keyValue(Object key) {
        String keyValue = null;
        if (this.m_rs != null) {
            keyValue = this.m_lineBuilder.buildLine((ResultSetKey)key);
        } else {
            ResultSetLinePieces linePieces = new ResultSetLinePieces((String)this.m_hashtable.get(key));
            keyValue = linePieces.toString();
        }
        return keyValue;
    }

    public boolean isConstant() {
        boolean constant = false;
        if (this.m_complete) {
            constant = true;
        } else if (this.m_rs != null) {
            constant = this.m_lineBuilder.isConstant();
        } else {
            ResultSetLinePieces pieces = new ResultSetLinePieces(this.m_text.toString());
            constant = pieces.isConstant();
        }
        return constant;
    }

    public Set getTopics() {
        Set topics = null;
        if (this.m_complete) {
            topics = new TreeSet();
        } else if (this.m_rs != null) {
            topics = this.m_lineBuilder.getLinePieces().getTopics();
        } else {
            ResultSetLinePieces pieces = new ResultSetLinePieces(this.m_text.toString());
            topics = pieces.getTopics();
        }
        return topics;
    }

    public int length() {
        int length = 0;
        if (this.m_rs != null) {
            Iterator it = this.m_rs.getData();
            while (it.hasNext()) {
                ResultSetKey key = (ResultSetKey)it.next();
                length += this.m_lineBuilder.sizeLine(key);
            }
        } else {
            length = this.m_text.length();
        }
        return length;
    }

    public void append(String rhs) {
        if (this.m_complete) {
            throw new IllegalStateException("cannot append to a complete piece");
        }
        if (this.m_rs != null) {
            this.m_text = this.getTextBuffer();
            this.m_rs = null;
            this.m_lineBuilder = null;
            this.append(rhs);
        } else {
            this.m_text.append(rhs);
        }
    }

    public void append(XHTMLGetTextResultPiece rhs) {
        this.append(rhs.getText());
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    public void markCompleted() {
        this.m_complete = true;
    }

    public String getText() {
        return this.getTextBuffer().toString();
    }

    public String toString() {
        return this.getText();
    }

    private StringBuffer getTextBuffer() {
        StringBuffer getTextBuffer = null;
        if (this.m_rs != null) {
            getTextBuffer = new StringBuffer(this.length());
            Iterator it = this.m_rs.getData();
            while (it.hasNext()) {
                ResultSetKey key = (ResultSetKey)it.next();
                getTextBuffer.append(this.m_lineBuilder.buildLine(key));
            }
        } else {
            getTextBuffer = this.m_text;
        }
        return getTextBuffer;
    }
}

