/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.xhtml.IXHTML_Visitor;
import com.cognos.asv.xhtml.XHTMLAttributes;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;

public abstract class XHTMLNode {
    private XHTMLNode m_parent;
    private ArrayList m_children;
    private String m_qName;
    private XHTMLAttributes m_attributes;
    private int m_pos = -1;

    public XHTMLNode(String qName, Attributes attributes) {
        this.m_qName = qName;
        this.m_attributes = new XHTMLAttributes(attributes);
    }

    public String qName() {
        return this.m_qName;
    }

    public XHTMLAttributes attributes() {
        return this.m_attributes;
    }

    public void addChildNode(XHTMLNode node) {
        if (this.m_children == null) {
            this.m_children = new ArrayList();
        }
        this.m_children.add(node);
        node.m_parent = this;
        node.m_pos = this.m_children.size() - 1;
    }

    public void addChildNode(XHTMLNode node, XHTMLNode refNode) {
        if (refNode == null) {
            this.addChildNode(node);
        } else {
            this.m_children.add(refNode.m_pos, node);
            node.m_parent = this;
            int isz = this.m_children.size();
            for (int i = 0; i < isz; ++i) {
                ((XHTMLNode)this.m_children.get((int)i)).m_pos = i;
            }
        }
    }

    public void removeChildNode(XHTMLNode node) {
        this.m_children.remove(node.m_pos);
        int isz = this.m_children.size();
        for (int i = 0; i < isz; ++i) {
            ((XHTMLNode)this.m_children.get((int)i)).m_pos = i;
        }
    }

    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    public List orphanChildNodes() {
        ArrayList ret_value = this.m_children;
        this.m_children = new ArrayList();
        for (XHTMLNode node : ret_value) {
            node.m_parent = null;
            node.m_pos = -1;
        }
        return ret_value;
    }

    public void replaceNode(XHTMLNode oldNode, XHTMLNode newNode) {
        int pos = oldNode.m_pos;
        this.m_children.set(pos, newNode);
        newNode.m_parent = this;
        newNode.m_pos = pos;
    }

    public Iterator childIterator() {
        Iterator it = null;
        if (this.hasChildren()) {
            it = this.m_children.iterator();
        }
        return it;
    }

    public abstract XHTMLGetTextResult getText(Formatter var1, Formatter var2);

    public void display(PrintStream ps) {
        this.private_display(0, ps);
    }

    public void visit(IXHTML_Visitor visitor) {
        visitor.start();
        this.visitAll(visitor);
        visitor.end();
    }

    public XHTMLNode deepCopy() {
        XHTMLNode clone = this.shallowCopy();
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode childNode = (XHTMLNode)it.next();
                XHTMLNode childCopy = childNode.deepCopy();
                clone.addChildNode(childCopy);
            }
        }
        return clone;
    }

    public List findAttributeValuePair(String name, String value) {
        ArrayList ret_value = new ArrayList();
        this.findAttributeValuePair(name, value, ret_value);
        return ret_value;
    }

    private void findAttributeValuePair(String name, String value, List collector) {
        if (this.attributes().hasAttribute(name) && this.attributes().getAttribute(name).equals(value)) {
            collector.add(this);
        }
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                ((XHTMLNode)it.next()).findAttributeValuePair(name, value, collector);
            }
        }
    }

    abstract XHTMLNode shallowCopy();

    protected void copyBase(XHTMLNode original) {
        this.m_qName = original.m_qName;
        this.m_attributes = original.m_attributes.shallowCopy();
    }

    protected void visitAll(IXHTML_Visitor visitor) {
        visitor.acceptNode(this);
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode node = (XHTMLNode)it.next();
                node.visitAll(visitor);
            }
        }
    }

    protected XHTMLNode getParent() {
        return this.m_parent;
    }

    protected XHTMLNode getRoot() {
        XHTMLNode node = this;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        return node;
    }

    protected abstract void private_display(int var1, PrintStream var2);

    protected void indent(int indent, PrintStream ps) {
        for (int i = 0; i < indent; ++i) {
            ps.print(" ");
        }
    }
}

