/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDistinctTopicFiltered;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import com.cognos.asv.xhtml.XHTMLNode;
import java.io.PrintStream;
import java.util.Iterator;

public class XHTMLReplicationNode
extends XHTMLNode {
    private ResultSet m_replicatePartition = null;
    private ResultSetTypeEnum m_replicateType = null;
    private boolean m_replicate = true;
    private boolean m_complete = true;
    private boolean m_unique = false;

    public XHTMLReplicationNode(ResultSet partition, ResultSetTypeEnum type) {
        super("#replicate", null);
        this.m_replicatePartition = partition;
        this.m_replicateType = type;
    }

    @Override
    public XHTMLGetTextResult getText(Formatter encoder, Formatter decoder) {
        XHTMLGetTextResult ret_value = new XHTMLGetTextResult();
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode node = (XHTMLNode)it.next();
                ret_value.append(node.getText(encoder, decoder));
            }
        }
        if (this.m_replicate) {
            ResultSet resultSet = this.m_replicatePartition;
            if (this.m_unique && !ret_value.isConstant()) {
                resultSet = new ResultSetDistinctTopicFiltered(this.m_replicatePartition, ret_value.getTopicString());
            }
            ret_value.applyResultSet(resultSet, this.m_replicateType, encoder, decoder);
            if (this.m_complete) {
                ret_value.complete();
            }
        }
        return ret_value;
    }

    public void setReplicate(boolean replicate) {
        this.m_replicate = replicate;
    }

    public void setComplete(boolean complete) {
        this.m_complete = complete;
    }

    public void setUnique(boolean unique) {
        this.m_unique = unique;
    }

    @Override
    XHTMLNode shallowCopy() {
        XHTMLReplicationNode copy = new XHTMLReplicationNode(this.m_replicatePartition, this.m_replicateType);
        copy.copyBase(this);
        return copy;
    }

    @Override
    protected void private_display(int indent, PrintStream ps) {
        this.indent(indent, ps);
        ps.println("<REPLICATION replicate=\"" + this.m_replicate + "\">");
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode node = (XHTMLNode)it.next();
                node.private_display(indent + 2, ps);
            }
        }
        this.indent(indent, ps);
        ps.println("</REPLICATION>");
    }
}

