/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.xhtml.XHTMLTag;
import com.cognos.asv.xhtml.XHTMLTextNode;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XHTMLSAXHandler
extends DefaultHandler {
    private XHTMLTag m_root = null;
    private Stack m_stack = new Stack();
    private XHTMLTextNode m_lastTextNode = null;
    private IdentityFormatter m_identity = new IdentityFormatter();
    private Set m_allowed_elements = new TreeSet();

    public XHTMLSAXHandler() {
    }

    public XHTMLSAXHandler(Set allowed_elements) {
        this.m_allowed_elements = allowed_elements;
    }

    public XHTMLTag getRoot() {
        return this.m_root;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.isParentAllowed()) {
            String data = new String(ch, start, length);
            if (this.m_lastTextNode != null) {
                this.m_lastTextNode.setText(this.m_lastTextNode.getText(this.m_identity, this.m_identity) + data);
            } else {
                XHTMLTextNode textNode = new XHTMLTextNode();
                textNode.setText(data);
                ((XHTMLTag)this.m_stack.peek()).addChildNode(textNode);
                this.m_lastTextNode = textNode;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.m_lastTextNode = null;
        if (((XHTMLTag)this.m_stack.peek()).qName().equals(qName)) {
            this.m_stack.pop();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        XHTMLTag tag = null;
        this.m_lastTextNode = null;
        if (this.m_root == null) {
            this.m_root = tag = new XHTMLTag(qName, attributes);
            this.m_stack.push(tag);
        } else if (this.isElementAllowed(qName)) {
            tag = new XHTMLTag(qName, attributes);
            ((XHTMLTag)this.m_stack.peek()).addChildNode(tag);
            this.m_stack.push(tag);
        }
    }

    private boolean isElementAllowed(String qName) {
        if (this.m_allowed_elements.size() == 0) {
            return true;
        }
        boolean ret_value = false;
        ret_value = this.m_allowed_elements.contains(qName) ? true : this.isParentAllowed();
        return ret_value;
    }

    private boolean isParentAllowed() {
        if (this.m_allowed_elements.size() == 0) {
            return true;
        }
        boolean ret_value = false;
        Iterator it = this.m_stack.iterator();
        while (it.hasNext() && !ret_value) {
            XHTMLTag parent = (XHTMLTag)it.next();
            if (!this.m_allowed_elements.contains(parent.qName())) continue;
            ret_value = true;
        }
        return ret_value;
    }
}

