/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.Formatter;
import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import com.cognos.asv.xhtml.XHTMLNode;
import java.io.PrintStream;
import java.util.Iterator;
import org.xml.sax.Attributes;

public class XHTMLTag
extends XHTMLNode {
    public XHTMLTag(String qName, Attributes attributes) {
        super(qName, attributes);
    }

    @Override
    public XHTMLGetTextResult getText(Formatter encoder, Formatter decoder) {
        XHTMLGetTextResult ret_value = new XHTMLGetTextResult();
        ret_value.append(new XHTMLGetTextResult(this.buildStartTag(encoder)));
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode node = (XHTMLNode)it.next();
                ret_value.append(node.getText(encoder, decoder));
            }
            ret_value.append(new XHTMLGetTextResult(this.buildEndTag(encoder)));
        }
        return ret_value;
    }

    @Override
    XHTMLNode shallowCopy() {
        XHTMLTag copy = new XHTMLTag(this.qName(), null);
        copy.copyBase(this);
        return copy;
    }

    @Override
    protected void private_display(int indent, PrintStream ps) {
        this.indent(indent, ps);
        if (this.getParent() == null) {
            ps.println("ROOT:START");
            this.indent(indent, ps);
        }
        ps.println(this.buildStartTag(new IdentityFormatter()));
        if (this.hasChildren()) {
            Iterator it = this.childIterator();
            while (it.hasNext()) {
                XHTMLNode node = (XHTMLNode)it.next();
                node.private_display(indent + 2, ps);
            }
            this.indent(indent, ps);
            ps.println(this.buildEndTag(new IdentityFormatter()));
        }
    }

    private String buildStartTag(Formatter formatter) {
        StringBuffer startTag = new StringBuffer("");
        startTag.append("<");
        startTag.append(formatter.format(this.qName()));
        startTag.append(this.attributes().getText(formatter));
        if (this.hasChildren()) {
            startTag.append(">");
        } else {
            startTag.append("/>");
        }
        return startTag.toString();
    }

    private String buildEndTag(Formatter formatter) {
        StringBuffer endTag = new StringBuffer("");
        if (this.hasChildren()) {
            endTag.append("</");
            endTag.append(formatter.format(this.qName()));
            endTag.append(">");
        }
        return endTag.toString();
    }
}

