/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.formatters.XMLDecodeFormatter;
import com.cognos.asv.formatters.XMLEncodeFormatter;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetMessageBuilder;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.xhtml.IXHTML_Visitor;
import com.cognos.asv.xhtml.XHTML;
import com.cognos.asv.xhtml.XHTMLGetTextResult;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLReplicationNode;
import com.cognos.asv.xhtml.XHTMLSAXHandler;
import com.cognos.asv.xhtml.XHTMLTag;
import com.cognos.asv.xhtml.XHTMLTextNode;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class XHTML_HTMLVisitor
implements IXHTML_Visitor {
    private static final String M_LOCALNAME_BODY = "BODY";
    private static final String M_LOCALNAME_META = "META";
    private static final String M_LOCALNAME_TR = "TR";
    private static final String M_LOCALNAME_LI = "LI";
    private static final String M_LOCALNAME_P = "P";
    private static final String M_LOCALNAME_A = "A";
    private static final String M_ATTRIBUTENAME_HREF = "HREF";
    private static final String M_META_ATTRIBUTE_NAME = "name";
    private static final String M_META_ATTRIBUTE_USER_HTML = "user-entered-html-email-body";
    private ResultSetPartition m_replicatePartition = null;
    private ResultSetTypeEnum m_replicateType = null;
    private ArrayList m_topicNodes = null;
    private XHTMLNode m_bodyNode = null;
    private boolean m_processAsHTML = false;
    private IdentityFormatter m_identity = new IdentityFormatter();

    public XHTML_HTMLVisitor(ResultSetPartition partition, ResultSetTypeEnum type) {
        this.m_replicatePartition = partition;
        this.m_replicateType = type;
        this.m_topicNodes = new ArrayList();
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
        if (this.m_processAsHTML) {
            this.processAsHTML();
        } else {
            this.processAsText();
        }
    }

    private static boolean isTextOriginated(String text) {
        boolean result = false;
        if (text != null && text.indexOf(M_META_ATTRIBUTE_USER_HTML) >= 0) {
            result = true;
        }
        return result;
    }

    private String manipulateText(String htmlBody) {
        String result = htmlBody;
        if (!XHTML_HTMLVisitor.isTextOriginated(htmlBody)) {
            String lowerText = htmlBody.toLowerCase();
            int startBodyIndex = lowerText.indexOf("<body");
            int endBodyIndex = lowerText.indexOf("</body");
            if (startBodyIndex >= 0 && endBodyIndex >= 0) {
                StringBuffer manipulatedHTML = new StringBuffer();
                String text = htmlBody.substring(startBodyIndex += 6, endBodyIndex);
                text = text.replaceAll("<[bB][rR]/>", "\n");
                ResultSetMessageBuilder message_builder = new ResultSetMessageBuilder(this.m_replicatePartition, ResultSetTypeEnum.HTML, text);
                String generatedBody = message_builder.getMessage();
                generatedBody = generatedBody.replaceAll("\n", "<br/>");
                manipulatedHTML.append(htmlBody.substring(0, startBodyIndex));
                manipulatedHTML.append(generatedBody);
                manipulatedHTML.append(htmlBody.substring(endBodyIndex, htmlBody.length()));
                result = manipulatedHTML.toString();
            }
        }
        return result;
    }

    @Override
    public void acceptNode(XHTMLNode node) {
        if (node instanceof XHTMLTextNode && this.isTopicTextNode((XHTMLTextNode)node)) {
            this.m_topicNodes.add(node);
        }
        if (node instanceof XHTMLTag) {
            XHTMLTag tag = (XHTMLTag)node;
            if (tag.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_META)) {
                String attribute = tag.attributes().getAttribute(M_META_ATTRIBUTE_NAME);
                this.m_processAsHTML = XHTML_HTMLVisitor.isTextOriginated(attribute);
            }
            if (tag.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_BODY)) {
                this.m_bodyNode = node;
            }
            if (tag.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_A)) {
                Iterator it = tag.attributes().attributeNameIterator();
                while (it.hasNext()) {
                    String attributeValue;
                    String attributeName = (String)it.next();
                    if (!attributeName.toUpperCase(Locale.ENGLISH).equals(M_ATTRIBUTENAME_HREF) || !this.isTopic(attributeValue = tag.attributes().getAttribute(attributeName))) continue;
                    this.m_topicNodes.add(node);
                }
            }
        }
    }

    private void processAsText() {
        XHTMLGetTextResult bodyResult = this.m_bodyNode.getText(new XMLEncodeFormatter(), new XMLDecodeFormatter());
        String bodyText = bodyResult.getText();
        bodyText = this.manipulateText(bodyText);
        XHTMLNode parentNode = this.m_bodyNode.getParent();
        parentNode.removeChildNode(this.m_bodyNode);
        XHTMLSAXHandler handler = new XHTMLSAXHandler();
        XHTML XHTML_processor = new XHTML(new StringReader(bodyText), handler);
        XHTML_processor.parse();
        XHTMLTag messageRootNode = handler.getRoot();
        parentNode.addChildNode(messageRootNode);
    }

    private void processAsHTML() {
        ArrayList replicatorNodes = new ArrayList();
        int isz = this.m_topicNodes.size();
        for (int i = 0; i < isz; ++i) {
            this.setReplicator((XHTMLNode)this.m_topicNodes.get(i), replicatorNodes);
        }
        int jsz = replicatorNodes.size();
        for (int j = 0; j < jsz; ++j) {
            XHTMLReplicationNode replicatorNode = (XHTMLReplicationNode)replicatorNodes.get(j);
            if (!this.replicatorHasReplicatorAncestor(replicatorNode)) continue;
            replicatorNode.setReplicate(false);
        }
    }

    private void setReplicator(XHTMLNode node, List replicatorNodes) {
        if (node.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_BODY)) {
            Iterator iterator = node.childIterator();
            int childCount = 0;
            XHTMLNode childNode2 = null;
            while (iterator.hasNext()) {
                ++childCount;
                childNode2 = (XHTMLNode)iterator.next();
            }
            if (childCount != 1 || !(childNode2 instanceof XHTMLReplicationNode)) {
                List childNodes = node.orphanChildNodes();
                XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(this.m_replicatePartition, this.m_replicateType);
                node.addChildNode(replicatorNode);
                for (XHTMLNode childNode2 : childNodes) {
                    replicatorNode.addChildNode(childNode2);
                }
            }
        } else if (node.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_BODY) || node.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_TR) || node.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_LI) || node.qName().toUpperCase(Locale.ENGLISH).equals(M_LOCALNAME_P)) {
            XHTMLNode parent = node.getParent();
            if (!(parent instanceof XHTMLReplicationNode)) {
                XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(this.m_replicatePartition, this.m_replicateType);
                replicatorNode.setUnique(true);
                node.getParent().replaceNode(node, replicatorNode);
                replicatorNode.addChildNode(node);
                replicatorNodes.add(replicatorNode);
            }
        } else if (node.getParent() != null) {
            this.setReplicator(node.getParent(), replicatorNodes);
        }
    }

    private boolean replicatorHasReplicatorAncestor(XHTMLNode start_node) {
        boolean ret_value = false;
        XHTMLNode node = start_node;
        while ((node = node.getParent()) != null && !ret_value) {
            if (!(node instanceof XHTMLReplicationNode)) continue;
            ret_value = true;
        }
        return ret_value;
    }

    private boolean isTopicTextNode(XHTMLTextNode text_node) {
        String text = text_node.getText(this.m_identity, this.m_identity).toString();
        return this.isTopic(text);
    }

    private boolean isTopic(String text) {
        ResultSetLinePieces linePieces = new ResultSetLinePieces(text);
        return !linePieces.isConstant();
    }
}

