/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetFiltered;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.resultset.ResultSetXML;
import com.cognos.asv.resultset.SuppressionFilters;
import com.cognos.asv.xhtml.IXHTML_Visitor;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLReplicationNode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class XHTML_HotlistVisitor
implements IXHTML_Visitor {
    private XHTMLNode m_tocNode;
    private XHTMLNode m_tocHeaderNode;
    private XHTMLNode m_sectionHeaderNode;
    private ResultSet m_rs;
    private Locale m_locale;
    private static final String M_ATTRIBUTE_NAME = "name";
    private static final String M_TOC_NAME = "toc";
    private static final String M_TOC_HEADER_NAME = "tocHeader";
    private static final String M_SECTION_HEADER_NAME = "sectionHeader";
    private static final String M_STOPPED_BOOKMARK = "stoppedEvents";
    private static final String M_UNCHANGED_BOOKMARK = "unchangedEvents";
    private static final String M_CHANGED_BOOKMARK = "changedEvents";
    private static final String M_NEW_BOOKMARK = "newEvents";
    private static final String M_STOPPED_IMAGE = "../ags/images/summary/icon_ceased.gif";
    private static final String M_UNCHANGED_IMAGE = "../ags/images/summary/icon_ongoing.gif";
    private static final String M_CHANGED_IMAGE = "../ags/images/summary/icon_ongoing.gif";
    private static final String M_NEW_IMAGE = "../ags/images/summary/icon_new.gif";

    public XHTML_HotlistVisitor(ResultSet rs, Locale locale) {
        this.m_rs = rs;
        this.m_locale = locale;
    }

    @Override
    public void start() {
    }

    @Override
    public void end() {
        this.buildTOCAndSections();
    }

    @Override
    public void acceptNode(XHTMLNode node) {
        if (node.attributes().hasAttribute(M_ATTRIBUTE_NAME)) {
            if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TOC_NAME)) {
                this.m_tocNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TOC_HEADER_NAME)) {
                this.m_tocHeaderNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_SECTION_HEADER_NAME)) {
                this.m_sectionHeaderNode = node;
            }
        }
    }

    private void buildTOCAndSections() {
        ResultSetFiltered newRS;
        ResultSetFiltered changedRS;
        ResultSetFiltered unchangedRS;
        boolean sectionCreated = false;
        ResultSetFiltered deletedRS = new ResultSetFiltered(this.m_rs, new SuppressionFilters(ResultSetFilterEnum.DELETED));
        if (!deletedRS.isEmpty()) {
            sectionCreated = true;
            ResultSet deletedSectionRS = this.buildSectionRS(M_STOPPED_IMAGE, this.getMessage(AgsI18NCode.MSG_AGS_DELETED_EVENTS), M_STOPPED_BOOKMARK, this.getMessage(AgsI18NCode.MSG_AGS_DETELED_EVENTS_DESCRIPTION));
            this.buildSectionReplicators(deletedSectionRS, deletedRS, this.m_sectionHeaderNode.deepCopy());
            this.buildTocReplicator(deletedSectionRS, this.m_tocHeaderNode.deepCopy());
        }
        if (!(unchangedRS = new ResultSetFiltered(this.m_rs, new SuppressionFilters(ResultSetFilterEnum.UNCHANGED))).isEmpty()) {
            sectionCreated = true;
            ResultSet unchangedSectionRS = this.buildSectionRS("../ags/images/summary/icon_ongoing.gif", this.getMessage(AgsI18NCode.MSG_AGS_UNCHANGED_EVENTS), M_UNCHANGED_BOOKMARK, this.getMessage(AgsI18NCode.MSG_AGS_UNCHANGED_EVENTS_DESCRIPTION));
            this.buildSectionReplicators(unchangedSectionRS, unchangedRS, this.m_sectionHeaderNode.deepCopy());
            this.buildTocReplicator(unchangedSectionRS, this.m_tocHeaderNode.deepCopy());
        }
        if (!(changedRS = new ResultSetFiltered(this.m_rs, new SuppressionFilters(ResultSetFilterEnum.CHANGED))).isEmpty()) {
            sectionCreated = true;
            ResultSet changedSectionRS = this.buildSectionRS("../ags/images/summary/icon_ongoing.gif", this.getMessage(AgsI18NCode.MSG_AGS_CHANGED_EVENTS), M_CHANGED_BOOKMARK, this.getMessage(AgsI18NCode.MSG_AGS_CHANGED_EVENTS_DESCRIPTION));
            this.buildSectionReplicators(changedSectionRS, changedRS, this.m_sectionHeaderNode.deepCopy());
            this.buildTocReplicator(changedSectionRS, this.m_tocHeaderNode.deepCopy());
        }
        if (!(newRS = new ResultSetFiltered(this.m_rs, new SuppressionFilters(ResultSetFilterEnum.NEW))).isEmpty()) {
            sectionCreated = true;
            ResultSet newSectionRS = this.buildSectionRS(M_NEW_IMAGE, this.getMessage(AgsI18NCode.MSG_AGS_NEW_EVENTS), M_NEW_BOOKMARK, this.getMessage(AgsI18NCode.MSG_AGS_NEW_EVENTS_DESCRIPTION));
            this.buildSectionReplicators(newSectionRS, newRS, this.m_sectionHeaderNode.deepCopy());
            this.buildTocReplicator(newSectionRS, this.m_tocHeaderNode.deepCopy());
        }
        this.m_sectionHeaderNode.getParent().removeChildNode(this.m_sectionHeaderNode);
        this.m_tocHeaderNode.getParent().removeChildNode(this.m_tocHeaderNode);
        if (sectionCreated) {
            ResultSet tocTitleRS = this.buildTOCTitleRS();
            XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(tocTitleRS, ResultSetTypeEnum.XML);
            this.m_tocNode.getParent().replaceNode(this.m_tocNode, replicatorNode);
            replicatorNode.addChildNode(this.m_tocNode);
        } else {
            this.m_tocNode.getParent().removeChildNode(this.m_tocNode);
        }
    }

    private void buildTocReplicator(ResultSet sectionHeaderRS, XHTMLNode tocHeaderNode) {
        XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(sectionHeaderRS, ResultSetTypeEnum.XML);
        replicatorNode.addChildNode(tocHeaderNode);
        this.m_tocHeaderNode.getParent().addChildNode(replicatorNode, this.m_tocHeaderNode);
    }

    private void buildSectionReplicators(ResultSet sectionHeaderRS, ResultSet sectionDataRS, XHTMLNode sectionNode) {
        ResultSet sectionMetadataRS = this.buildMetadataRS(sectionDataRS);
        XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(sectionHeaderRS, ResultSetTypeEnum.XML);
        replicatorNode.addChildNode(sectionNode);
        this.m_sectionHeaderNode.getParent().addChildNode(replicatorNode, this.m_sectionHeaderNode);
        List listBodyNodes = sectionNode.findAttributeValuePair(M_ATTRIBUTE_NAME, "ListBody");
        List listBodyRows = ((XHTMLNode)listBodyNodes.get(0)).findAttributeValuePair("layoutClass", "tableRow");
        XHTMLNode rowHeaderDefNode = (XHTMLNode)((XHTMLNode)listBodyRows.get(0)).childIterator().next();
        XHTMLNode rowBodyDefNode = (XHTMLNode)((XHTMLNode)listBodyRows.get(1)).childIterator().next();
        XHTMLNode rowBodyRowNode = (XHTMLNode)listBodyRows.get(1);
        XHTMLReplicationNode rowHeaderReplicator = new XHTMLReplicationNode(sectionMetadataRS, ResultSetTypeEnum.XML);
        rowHeaderDefNode.getParent().replaceNode(rowHeaderDefNode, rowHeaderReplicator);
        rowHeaderReplicator.addChildNode(rowHeaderDefNode);
        XHTMLReplicationNode rowBodyMetaReplicator = new XHTMLReplicationNode(sectionMetadataRS, ResultSetTypeEnum.XML);
        rowBodyDefNode.getParent().replaceNode(rowBodyDefNode, rowBodyMetaReplicator);
        rowBodyMetaReplicator.addChildNode(rowBodyDefNode);
        rowBodyMetaReplicator.setComplete(false);
        XHTMLReplicationNode rowBodyDataReplicator = new XHTMLReplicationNode(sectionDataRS, ResultSetTypeEnum.HTML);
        rowBodyRowNode.getParent().replaceNode(rowBodyRowNode, rowBodyDataReplicator);
        rowBodyDataReplicator.addChildNode(rowBodyRowNode);
    }

    private ResultSet buildSectionRS(String image, String name, String bookmark, String description) {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_locale);
        resultSetXML.addMetadataItem("sectionImage", "xs:string", "100");
        resultSetXML.addMetadataItem("sectionName", "xs:string", "100");
        resultSetXML.addMetadataItem("sectionBookmark", "xs:string", "100");
        resultSetXML.addMetadataItem("sectionDesc", "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(image);
        resultSetXML.addValue(name);
        resultSetXML.addValue(bookmark);
        resultSetXML.addValue(description);
        return resultSetXML;
    }

    private ResultSet buildTOCTitleRS() {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_locale);
        resultSetXML.addMetadataItem("tocTitle", "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(this.getMessage(AgsI18NCode.MSG_AGS_TABLE_OF_CONTENTS));
        return resultSetXML;
    }

    private ResultSet buildMetadataRS(ResultSet rs) {
        ResultSetXML metadataResultSet = new ResultSetXML(this.m_locale);
        metadataResultSet.addMetadataItem("dataItemName", "xs:string", "100");
        metadataResultSet.addMetadataItem("dataItemValue", "xs:string", "100");
        Iterator it = rs.getMetadata();
        while (it.hasNext()) {
            MetadataItem item = (MetadataItem)it.next();
            if (item.name().equals(ResultSet.STATUS_TOPIC.name())) continue;
            metadataResultSet.addRow();
            metadataResultSet.addValue(item.name());
            metadataResultSet.addValue(item.makeTopic().reference());
        }
        return metadataResultSet;
    }

    private String getMessage(I18NCode msgCode) {
        return I18NUtil.getMessage((I18NCode)msgCode, null, (Locale)LocaleUtil.createContentLocale((String)this.m_locale.toString()));
    }
}

