/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml;

import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.formatters.XMLDecodeFormatter;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.resultset.ResultSetXML;
import com.cognos.asv.util.HumanTaskPreviewHelper;
import com.cognos.asv.xhtml.IXHTML_Visitor;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLReplicationNode;
import com.cognos.asv.xhtml.descriptors.AttachmentDescriptor;
import com.cognos.asv.xhtml.descriptors.DeliveryOptionDescriptor;
import com.cognos.asv.xhtml.descriptors.RssOptionDescriptor;
import com.cognos.asv.xhtml.descriptors.TaskRunDescriptor;
import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseDataIntegrationTask;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ContentTask;
import com.cognos.developer.schemas.bibus._3.EventTypeEnum;
import com.cognos.developer.schemas.bibus._3.EventTypeEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.ExportDeployment;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.ImportDeployment;
import com.cognos.developer.schemas.bibus._3.IndexUpdateTask;
import com.cognos.developer.schemas.bibus._3.InteractiveReport;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MigrationTask;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PlanningMacroTask;
import com.cognos.developer.schemas.bibus._3.PowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.PowerPlay8ReportView;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class XHTML_PreviewVisitor
implements IXHTML_Visitor {
    private XHTMLNode m_tocNode;
    private XHTMLNode m_tocLabelNode;
    private XHTMLNode m_tocContentNode;
    private XHTMLNode m_tocSequenceNode;
    private XHTMLNode m_taskHeaderNode;
    private XHTMLNode m_taskBodyNode;
    private Agent m_agent;
    private List m_taskRunList;
    private Locale m_contentLocale;
    private Locale m_productLocale;
    private JobBiBusHeaders m_headers;
    private ResultSet m_rs;
    private static final String M_ATTRIBUTE_NAME = "name";
    private static final String M_TOC_NAME = "toc";
    private static final String M_TOC_TITLE = "tocTitle";
    private static final String M_TOC_LABEL_NAME = "tocLabel";
    private static final String M_TOC_LABEL_TOPIC = "tocLabel";
    private static final String M_TOC_CONTENT_NAME = "taskContent";
    private static final String M_TASK_TASKIMAGE = "taskImage";
    private static final String M_TASK_TASKBOOKMARK = "taskBookmark";
    private static final String M_TASK_TASKNAME = "taskName";
    private static final String M_TOC_SEQUENCE_NAME = "tocSequence";
    private static final String M_TASK_HEADER_NAME = "taskHeader";
    private static final String M_TASK_BODY_NAME = "taskBody";
    private static final String M_DESCRIPTION_BODY_NODE = "taskDescription";
    private static final String M_EMAIL_BODY_NAME = "emailBody";
    private static final String M_NEWSITEM_BODY_NAME = "newitemContentBody";
    private static final String M_LIST_BODY_NAME = "ListBody";
    private static final String M_TASK_DESCRIPTION = "taskDescription";
    private static final String M_LIST_DATA_ITEM_NAME = "dataItemName";
    private static final String M_LIST_DATA_ITEM_VALUE = "dataItemValue";
    private static final String M_EMAIL_BODY_TO = "to";
    private static final String M_EMAIL_BODY_CC = "cc";
    private static final String M_EMAIL_BODY_BCC = "bcc";
    private static final String M_EMAIL_BODY_SUBJECT = "subject";
    private static final String M_EMAIL_BODY_BODY = "body";
    private static final String M_LINK_BODY_NAME = "linkBody";
    private static final String M_LINK_BODY_LINK = "link";
    private static final String M_ATTACHMENT_BODY_NAME = "attachmentBody";
    private static final String M_ATTACHMENT_BODY_IMAGE = "attachImage";
    private static final String M_ATTACHMENT_BODY_DESCRIPTION = "attachDescription";
    private static final String M_NEWSITEM_BODY_HEADLINE = "newsItemHeadline";
    private static final String M_NEWSITEM_BODY_DESCRIPTION = "newsItemDescription";
    private Integer m_truncatedTo;
    private Integer m_truncatedFrom;

    public XHTML_PreviewVisitor(Agent agent, List taskRunList, JobBiBusHeaders headers, Integer truncatedTo, Integer truncatedFrom) {
        this.m_agent = agent;
        this.m_taskRunList = taskRunList;
        this.m_headers = headers;
        this.m_productLocale = LocaleUtil.getLocale((String)this.m_headers.getUserPreferenceProductLocale());
        this.m_contentLocale = LocaleUtil.getLocale((String)this.m_headers.getUserPreferenceContentLocale());
        this.m_rs = this.m_agent.getResultSet();
        this.m_truncatedTo = truncatedTo;
        this.m_truncatedFrom = truncatedFrom;
    }

    @Override
    public void start() {
    }

    @Override
    public void acceptNode(XHTMLNode node) {
        if (node.attributes().hasAttribute(M_ATTRIBUTE_NAME)) {
            if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TOC_NAME)) {
                this.m_tocNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals("tocLabel")) {
                this.m_tocLabelNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TOC_CONTENT_NAME)) {
                this.m_tocContentNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TOC_SEQUENCE_NAME)) {
                this.m_tocSequenceNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TASK_HEADER_NAME)) {
                this.m_taskHeaderNode = node;
            } else if (node.attributes().getAttribute(M_ATTRIBUTE_NAME).equals(M_TASK_BODY_NAME)) {
                this.m_taskBodyNode = node;
            }
        }
    }

    @Override
    public void end() {
        this.replicateReplace(this.m_tocNode, this.buildTOCTitlePartition(), ResultSetTypeEnum.XML);
        this.copyReplicateAdd(this.m_tocLabelNode, this.buildTocLabelPartition(this.getMessage(AgsI18NCode.MSG_AGS_EVENT_HEADER)), ResultSetTypeEnum.XML, this.m_tocLabelNode);
        this.copyReplicateAdd(this.m_tocContentNode, this.buildEventListHeaderPartition(), ResultSetTypeEnum.XML, this.m_tocLabelNode);
        if (this.m_taskRunList.size() > 0) {
            this.copyReplicateAdd(this.m_tocLabelNode, this.buildTocLabelPartition(this.getMessage(AgsI18NCode.MSG_AGS_TASK_HEADER)), ResultSetTypeEnum.XML, this.m_tocLabelNode);
        }
        this.copyReplicateAdd(this.m_taskHeaderNode, this.buildEventListHeaderPartition(), ResultSetTypeEnum.XML, this.m_taskBodyNode);
        XHTMLNode eventListBody = this.m_taskBodyNode.deepCopy();
        this.m_taskBodyNode.getParent().addChildNode(eventListBody, this.m_taskBodyNode);
        this.pruneAttributeValuePairs(eventListBody, M_ATTRIBUTE_NAME, "taskDescription");
        this.pruneAttributeValuePairs(eventListBody, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
        this.pruneAttributeValuePairs(eventListBody, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
        this.buildListBodyReplicators(this.m_rs, ResultSetTypeEnum.HTML, eventListBody);
        Iterator it = this.m_taskRunList.iterator();
        int taskNum = 0;
        while (it.hasNext()) {
            TaskRun taskRun = (TaskRun)it.next();
            TaskRunDescriptor taskRunDescriptor = new TaskRunDescriptor(taskRun);
            ResultSet taskHeaderRS = this.buildTaskHeaderPartition(taskRunDescriptor, taskNum);
            this.copyReplicateAdd(this.m_tocContentNode, taskHeaderRS, ResultSetTypeEnum.XML, this.m_tocLabelNode);
            if (this.m_agent.getSequencing().equals("sequential") && it.hasNext()) {
                this.m_tocLabelNode.getParent().addChildNode(this.m_tocSequenceNode.deepCopy(), this.m_tocLabelNode);
            }
            this.copyReplicateAdd(this.m_taskHeaderNode, taskHeaderRS, ResultSetTypeEnum.XML, this.m_taskBodyNode);
            XHTMLNode copy = this.m_taskBodyNode.deepCopy();
            this.m_taskBodyNode.getParent().addChildNode(copy, this.m_taskBodyNode);
            ResultSet rs = ((BaseAgentTaskTarget)taskRun.task()).getResultSet();
            AgentTask agentTask = (AgentTask)taskRun.task().getParent();
            EventTypeEnumArrayProp eventTypes = agentTask.getAgentTaskDefinition().getEventTypes();
            if (!(taskRun.failed() || rs.isEmpty() && !XHTML_PreviewVisitor.containsFilter(eventTypes.getValue(), ResultSetFilterEnum.NIL))) {
                this.buildTaskBodyNode(copy, taskRunDescriptor);
            } else {
                this.pruneAttributeValuePairs(copy, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
                this.pruneAttributeValuePairs(copy, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
                this.pruneAttributeValuePairs(copy, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            }
            this.replicateReplace(copy, this.buildTaskDescriptionPartition(taskRunDescriptor), ResultSetTypeEnum.XML);
            ++taskNum;
        }
        this.m_tocLabelNode.getParent().removeChildNode(this.m_tocLabelNode);
        this.m_tocContentNode.getParent().removeChildNode(this.m_tocContentNode);
        this.m_tocSequenceNode.getParent().removeChildNode(this.m_tocSequenceNode);
        this.m_taskHeaderNode.getParent().removeChildNode(this.m_taskHeaderNode);
        this.m_taskBodyNode.getParent().removeChildNode(this.m_taskBodyNode);
    }

    private void buildListBodyReplicators(ResultSet listRS, ResultSetTypeEnum type, XHTMLNode listBodyNode) {
        ResultSet listMetadataRS = this.buildMetadataRS(listRS);
        List listBodyRows = listBodyNode.findAttributeValuePair("layoutClass", "tableRow");
        XHTMLNode rowHeaderDefNode = (XHTMLNode)((XHTMLNode)listBodyRows.get(0)).childIterator().next();
        XHTMLNode rowBodyDefNode = (XHTMLNode)((XHTMLNode)listBodyRows.get(1)).childIterator().next();
        XHTMLNode rowBodyRowNode = (XHTMLNode)listBodyRows.get(1);
        this.replicateReplace(rowHeaderDefNode, listMetadataRS, ResultSetTypeEnum.XML);
        this.replicateReplace(rowBodyDefNode, listMetadataRS, ResultSetTypeEnum.XML).setComplete(false);
        this.replicateReplace(rowBodyRowNode, listRS, type);
    }

    private void buildTaskBodyNode(XHTMLNode bodyNode, TaskRunDescriptor taskRunDescriptor) {
        BaseClass baseClass = taskRunDescriptor.getTaskRun().task().getBaseClass();
        if (taskRunDescriptor.getTaskRun().failed()) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
        } else if (baseClass instanceof BaseAgentDefinition || baseClass instanceof Report || baseClass instanceof ReportView || baseClass instanceof Query || baseClass instanceof Analysis || baseClass instanceof InteractiveReport || baseClass instanceof StoredProcedureTask || baseClass instanceof WebServiceTask || baseClass instanceof IndexUpdateTask || baseClass instanceof PowerPlay8Report || baseClass instanceof PowerPlay8ReportView) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
            if (taskRunDescriptor.taskRunHasPrompts()) {
                List listBodyNodes = bodyNode.findAttributeValuePair(M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
                this.buildListBody((XHTMLNode)listBodyNodes.get(0), taskRunDescriptor);
            } else {
                this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            }
        } else if (baseClass instanceof Memo) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
            List memoBodyNodes = bodyNode.findAttributeValuePair(M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            this.buildEmailBody((XHTMLNode)memoBodyNodes.get(0), taskRunDescriptor);
        } else if (baseClass instanceof HumanTask) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
            List memoBodyNodes = bodyNode.findAttributeValuePair(M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            List listBodyNodes = bodyNode.findAttributeValuePair(M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            TaskRun taskRun = taskRunDescriptor.getTaskRun();
            TaskRunInfo[] runInfos = taskRun.runInfo();
            for (int i = 0; i < runInfos.length; ++i) {
                HumanTaskPreviewHelper helper = new HumanTaskPreviewHelper(this.m_productLocale, this.m_headers);
                helper.process(runInfos[i]);
            }
            this.buildHumanTaskBody((XHTMLNode)memoBodyNodes.get(0), (XHTMLNode)listBodyNodes.get(0), taskRunDescriptor);
        } else if (baseClass instanceof BaseRSSTask) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            List newitemContentBodyNodes = bodyNode.findAttributeValuePair(M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
            this.buildNewsItemContentBody((XHTMLNode)newitemContentBodyNodes.get(0), taskRunDescriptor);
        } else if (baseClass instanceof JobDefinition || baseClass instanceof ImportDeployment || baseClass instanceof ExportDeployment || baseClass instanceof ContentTask || baseClass instanceof BaseDataIntegrationTask || baseClass instanceof PlanningMacroTask || baseClass instanceof MigrationTask) {
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_LIST_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_EMAIL_BODY_NAME);
            this.pruneAttributeValuePairs(bodyNode, M_ATTRIBUTE_NAME, M_NEWSITEM_BODY_NAME);
        }
    }

    private void buildHumanTaskBody(XHTMLNode memoBodyNode, XHTMLNode listBodyNode, TaskRunDescriptor taskRunDescriptor) {
        TaskRunInfo[] taskRunInfoArray = taskRunDescriptor.getTaskRun().runInfo();
        int isz = taskRunInfoArray.length;
        for (int i = 0; i < isz; ++i) {
            XHTMLNode memoCopy = memoBodyNode.deepCopy();
            Option[] options = taskRunInfoArray[i].options();
            this.fillEmailBody(memoCopy, options, memoBodyNode);
            XHTMLNode listCopy = listBodyNode.deepCopy();
            ParameterValue[] parameters = taskRunInfoArray[i].parameters();
            if (parameters.length <= 0) continue;
            this.fillListBody(listCopy, parameters, memoBodyNode);
        }
        listBodyNode.getParent().removeChildNode(listBodyNode);
        memoBodyNode.getParent().removeChildNode(memoBodyNode);
    }

    private void buildListBody(XHTMLNode bodyNode, TaskRunDescriptor taskRunDescriptor) {
        TaskRunInfo[] taskRunInfoArray = taskRunDescriptor.getTaskRun().runInfo();
        int isz = taskRunInfoArray.length;
        for (int i = 0; i < isz; ++i) {
            XHTMLNode copy = bodyNode.deepCopy();
            ParameterValue[] parameters = taskRunInfoArray[i].parameters();
            if (parameters.length > 0) {
                this.fillListBody(copy, parameters, bodyNode);
            }
            bodyNode.getParent().removeChildNode(bodyNode);
        }
    }

    private void fillListBody(XHTMLNode copy, ParameterValue[] parameters, XHTMLNode ref) {
        ResultSet parameterRS = this.buildParameterPartition(parameters);
        this.buildListBodyReplicators(parameterRS, ResultSetTypeEnum.XML, copy);
        ref.getParent().addChildNode(copy, ref);
    }

    private void buildEmailBody(XHTMLNode bodyNode, TaskRunDescriptor taskRunDescriptor) {
        TaskRunInfo[] taskRunInfoArray = taskRunDescriptor.getTaskRun().runInfo();
        int isz = taskRunInfoArray.length;
        for (int i = 0; i < isz; ++i) {
            XHTMLNode copy = bodyNode.deepCopy();
            Option[] options = taskRunInfoArray[i].options();
            this.fillEmailBody(copy, options, bodyNode);
        }
        bodyNode.getParent().removeChildNode(bodyNode);
    }

    private void fillEmailBody(XHTMLNode copy, Option[] options, XHTMLNode ref) {
        DeliveryOptionDescriptor wibble = new DeliveryOptionDescriptor(this.m_headers, options);
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        resultSetXML.addMetadataItem(M_EMAIL_BODY_TO, "xs:string", "100");
        resultSetXML.addMetadataItem(M_EMAIL_BODY_CC, "xs:string", "100");
        resultSetXML.addMetadataItem(M_EMAIL_BODY_BCC, "xs:string", "100");
        resultSetXML.addMetadataItem(M_EMAIL_BODY_SUBJECT, "xs:string", "100");
        resultSetXML.addMetadataItem(M_EMAIL_BODY_BODY, "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(wibble.getEmailTo());
        resultSetXML.addValue(wibble.getEmailCC());
        resultSetXML.addValue(wibble.getEmailBCC());
        resultSetXML.addValue(wibble.getEmailSubject());
        if (wibble.getHTMLBody() != null && wibble.getHTMLBody().length() > 0) {
            resultSetXML.addValue(wibble.getHTMLBody());
        } else if (wibble.getEmailTxtBody() != null) {
            resultSetXML.addValue(wibble.getEmailTxtBody());
        } else {
            resultSetXML.addValue("");
        }
        List linkCopyNodes = copy.findAttributeValuePair(M_ATTRIBUTE_NAME, M_LINK_BODY_NAME);
        this.buildLinkBody((XHTMLNode)linkCopyNodes.get(0), wibble);
        List attachmentCopyNodes = copy.findAttributeValuePair(M_ATTRIBUTE_NAME, M_ATTACHMENT_BODY_NAME);
        this.buildAttachmentBody((XHTMLNode)attachmentCopyNodes.get(0), wibble);
        this.replicateAdd(copy, resultSetXML, ResultSetTypeEnum.XML, ref);
    }

    private void buildLinkBody(XHTMLNode bodyNode, DeliveryOptionDescriptor wibble) {
        ArrayList linkList = wibble.getLinks();
        int isz = linkList.size();
        for (int i = 0; i < isz; ++i) {
            ObjectLink link = (ObjectLink)linkList.get(i);
            ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
            resultSetXML.addMetadataItem(M_LINK_BODY_LINK, "xs:string", "100");
            resultSetXML.addRow();
            resultSetXML.addValue(link.getLabel());
            this.copyReplicateAdd(bodyNode, resultSetXML, ResultSetTypeEnum.XML, bodyNode);
        }
        bodyNode.getParent().removeChildNode(bodyNode);
    }

    private void buildAttachmentBody(XHTMLNode bodyNode, DeliveryOptionDescriptor wibble) {
        ArrayList attachmentList = wibble.getAttachments();
        int isz = attachmentList.size();
        for (int i = 0; i < isz; ++i) {
            ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
            resultSetXML.addMetadataItem(M_ATTACHMENT_BODY_IMAGE, "xs:string", "100");
            resultSetXML.addMetadataItem(M_ATTACHMENT_BODY_DESCRIPTION, "xs:string", "100");
            resultSetXML.addRow();
            MemoPartAgentObject memoPartAgentObject = (MemoPartAgentObject)attachmentList.get(i);
            AttachmentDescriptor attachmentDescriptor = new AttachmentDescriptor(memoPartAgentObject, this.m_productLocale, this.m_headers.getBiBusHeader());
            resultSetXML.addValue(attachmentDescriptor.getAttachmentImage());
            resultSetXML.addValue(attachmentDescriptor.getAttachmentName());
            this.copyReplicateAdd(bodyNode, resultSetXML, ResultSetTypeEnum.XML, bodyNode);
        }
        bodyNode.getParent().removeChildNode(bodyNode);
    }

    private void buildNewsItemContentBody(XHTMLNode bodyNode, TaskRunDescriptor taskRunDescriptor) {
        TaskRunInfo[] taskRunInfoArray = taskRunDescriptor.getTaskRun().runInfo();
        int isz = taskRunInfoArray.length;
        for (int i = 0; i < isz; ++i) {
            XHTMLNode copy = bodyNode.deepCopy();
            RssOptionDescriptor rssOptionDescriptor = new RssOptionDescriptor(taskRunInfoArray[i].options());
            ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
            resultSetXML.addMetadataItem(M_NEWSITEM_BODY_HEADLINE, "xs:string", "100");
            resultSetXML.addMetadataItem(M_NEWSITEM_BODY_DESCRIPTION, "xs:string", "100");
            resultSetXML.addRow();
            resultSetXML.addValue(rssOptionDescriptor.getHeadline());
            resultSetXML.addValue(rssOptionDescriptor.getDescription());
            this.replicateAdd(copy, resultSetXML, ResultSetTypeEnum.XML, bodyNode);
        }
        bodyNode.getParent().removeChildNode(bodyNode);
    }

    private void pruneAttributeValuePairs(XHTMLNode source, String attributeName, String attributeValue) {
        List matchingNodes = source.findAttributeValuePair(attributeName, attributeValue);
        for (XHTMLNode matchNode : matchingNodes) {
            matchNode.getParent().removeChildNode(matchNode);
        }
    }

    private XHTMLReplicationNode replicateReplace(XHTMLNode source, ResultSet partition, ResultSetTypeEnum type) {
        XHTMLReplicationNode replicatorNode = new XHTMLReplicationNode(partition, type);
        source.getParent().replaceNode(source, replicatorNode);
        replicatorNode.addChildNode(source);
        return replicatorNode;
    }

    private XHTMLReplicationNode replicateAdd(XHTMLNode source, ResultSet rs, ResultSetTypeEnum type, XHTMLNode ref) {
        XHTMLReplicationNode replicator = new XHTMLReplicationNode(rs, type);
        replicator.addChildNode(source);
        ref.getParent().addChildNode(replicator, ref);
        return replicator;
    }

    private XHTMLReplicationNode copyReplicateAdd(XHTMLNode source, ResultSet rs, ResultSetTypeEnum type, XHTMLNode ref) {
        XHTMLNode copy = source.deepCopy();
        XHTMLReplicationNode replicator = new XHTMLReplicationNode(rs, type);
        replicator.addChildNode(copy);
        ref.getParent().addChildNode(replicator, ref);
        return replicator;
    }

    private ResultSet buildTaskDescriptionPartition(TaskRunDescriptor taskRunDescriptor) {
        ResultSetXML taskDescriptionResultSet = new ResultSetXML(this.m_contentLocale);
        taskDescriptionResultSet.addMetadataItem("taskDescription", "xs:string", "100");
        taskDescriptionResultSet.addRow();
        taskDescriptionResultSet.addValue(taskRunDescriptor.buildTaskHeaderDescription(this.isNoEvents(taskRunDescriptor), this.m_productLocale));
        return taskDescriptionResultSet;
    }

    private boolean isNoEvents(TaskRunDescriptor taskRunDescriptor) {
        AgentTask agentTask = (AgentTask)taskRunDescriptor.getTaskRun().task().getParent();
        EventTypeEnumArrayProp eventTypes = agentTask.getAgentTaskDefinition().getEventTypes();
        return this.m_rs.isEmpty() && !XHTML_PreviewVisitor.containsFilter(eventTypes.getValue(), ResultSetFilterEnum.NIL);
    }

    private static boolean containsFilter(EventTypeEnum[] enums, ResultSetFilterEnum enumr) {
        if (enums == null || enums.length == 0) {
            return false;
        }
        for (int i = 0; i < enums.length; ++i) {
            ResultSetFilterEnum r_enum = ResultSetFilterEnum.getFilterEnum(enums[i].getValue());
            if (!r_enum.equals(enumr)) continue;
            return true;
        }
        return false;
    }

    private ResultSet buildParameterPartition(ParameterValue[] parameters) {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        int maxParameterLength = -1;
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName();
            if (null != name && name.startsWith("credential:")) {
                name = name.substring("credential:".length(), name.length());
            }
            resultSetXML.addMetadataItem(name, "xs:string", "20");
            if (parameters[i].getValue().length <= maxParameterLength) continue;
            maxParameterLength = parameters[i].getValue().length;
        }
        for (int j = 0; j < maxParameterLength; ++j) {
            resultSetXML.addRow();
            for (int i = 0; i < parameters.length; ++i) {
                String value = "";
                if (j < parameters[i].getValue().length) {
                    ParmValueItem parameterItem = parameters[i].getValue()[j];
                    value = this.convertParameterValueItemForDisplay(parameterItem);
                }
                resultSetXML.addValue(value);
            }
        }
        return resultSetXML;
    }

    private String convertParameterValueItemForDisplay(ParmValueItem paramValueItem) {
        String ret_value = "";
        if (paramValueItem instanceof SimpleParmValueItem) {
            ret_value = this.convertSimpleParameterValueForDisplay((SimpleParmValueItem)paramValueItem);
        } else if (paramValueItem instanceof BoundRangeParmValueItem) {
            BoundRangeParmValueItem boundRangeParameterValue = (BoundRangeParmValueItem)paramValueItem;
            String start = this.convertSimpleParameterValueForDisplay(boundRangeParameterValue.getStart());
            String end = this.convertSimpleParameterValueForDisplay(boundRangeParameterValue.getEnd());
            ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_BOUNDED_RANGE_VALUE, new Object[]{start, end});
        } else if (paramValueItem instanceof HierarchicalParmValueItem) {
            HierarchicalParmValueItem hierarchicalParameterValue = (HierarchicalParmValueItem)paramValueItem;
            String simpleDisplayItem = this.convertSimpleParameterValueForDisplay(hierarchicalParameterValue.getValue());
            HierarchicalParmValueItem[] subNodes = hierarchicalParameterValue.getSubNodes();
            StringBuffer subNodeValue = new StringBuffer("");
            int isz = subNodes.length;
            for (int i = 0; i < isz; ++i) {
                subNodeValue.append(this.convertSimpleParameterValueForDisplay(subNodes[i].getValue()));
                if (i >= isz - 1) continue;
                subNodeValue.append(this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_LIST_SEPARATOR));
            }
            ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_HIERARCHICAL_PARAM_VALUE, new Object[]{simpleDisplayItem, subNodeValue.toString()});
        } else if (paramValueItem instanceof UnboundedEndRangeParmValueItem) {
            UnboundedEndRangeParmValueItem unboundedEndRangeParameterValue = (UnboundedEndRangeParmValueItem)paramValueItem;
            String start = this.convertSimpleParameterValueForDisplay(unboundedEndRangeParameterValue.getStart());
            ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_RANGED_START_PARAM_VALUE, new Object[]{start});
        } else if (paramValueItem instanceof UnboundedStartRangeParmValueItem) {
            UnboundedStartRangeParmValueItem unboundedStartRangeParameterValue = (UnboundedStartRangeParmValueItem)paramValueItem;
            String end = this.convertSimpleParameterValueForDisplay(unboundedStartRangeParameterValue.getEnd());
            ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_RANGED_END_PARAM_VALUE, new Object[]{end});
        }
        ret_value = this.resolveConnectionDetails(ret_value);
        return ret_value;
    }

    private String resolveConnectionDetails(String ret_value) {
        if (null != ret_value) {
            XMLDecodeFormatter decoder;
            int end;
            int start;
            String connectionPath = "";
            String signonPath = "";
            if (ret_value.indexOf("<dataSourceConnection>") != -1) {
                start = ret_value.indexOf("CAMID");
                end = ret_value.indexOf("</dataSourceConnection>");
                connectionPath = ret_value.substring(start, end);
            }
            if (ret_value.indexOf("<dataSourceSignon>") != -1) {
                start = ret_value.lastIndexOf("CAMID");
                end = ret_value.indexOf("</dataSourceSignon>");
                signonPath = ret_value.substring(start, end);
            }
            String connection = null;
            String signon = null;
            if (null != connectionPath && connectionPath.length() > 0) {
                decoder = new XMLDecodeFormatter();
                connection = this.getAmbiguousConnectionDetails(decoder.format(connectionPath));
            }
            if (null != signonPath && signonPath.length() > 0) {
                decoder = new XMLDecodeFormatter();
                signon = this.getAmbiguousConnectionDetails(decoder.format(signonPath));
            }
            if (null != connection && null != signon) {
                ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_CONNECTION_SIGNON, new Object[]{connection, signon});
            } else if (null != connection) {
                ret_value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_CONNECTION_NO_SIGNON, new Object[]{connection});
            }
        }
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAmbiguousConnectionDetails(String searchPath) {
        String result = "";
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
        QueryRequest request = null;
        if (null != searchPath && searchPath.length() > 0) {
            request = new QueryRequest();
            request.setSearch(searchPath);
            request.setProperties(new PropEnum[]{PropEnum.defaultName});
        }
        if (null != request) {
            try {
                BaseClass reply = cmPort.query(request);
                if (reply != null) {
                    String name;
                    result = name = reply.getDefaultName().getValue();
                }
            }
            catch (SDKClientException e) {
                e.printStackTrace();
            }
            catch (EMFSecurityException e) {
                e.printStackTrace();
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return result;
    }

    private String convertSimpleParameterValueForDisplay(SimpleParmValueItem simpleParameterValue) {
        String ret_value = null;
        if (simpleParameterValue.getDisplay() != null) {
            ret_value = simpleParameterValue.getDisplay();
        } else if (simpleParameterValue.getUse() != null) {
            ret_value = simpleParameterValue.getUse();
        }
        return ret_value;
    }

    private ResultSet buildMetadataRS(ResultSet rs) {
        ResultSetXML metadataResultSet = new ResultSetXML(this.m_contentLocale);
        metadataResultSet.addMetadataItem(M_LIST_DATA_ITEM_NAME, "xs:string", "100");
        metadataResultSet.addMetadataItem(M_LIST_DATA_ITEM_VALUE, "xs:string", "100");
        Iterator it = rs.getMetadata();
        while (it.hasNext()) {
            MetadataItem item = (MetadataItem)it.next();
            if (item.name().equals(ResultSet.STATUS_TOPIC.name())) continue;
            metadataResultSet.addRow();
            metadataResultSet.addValue(item.name());
            metadataResultSet.addValue(item.makeTopic().reference());
        }
        return metadataResultSet;
    }

    private ResultSet buildTOCTitlePartition() {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        resultSetXML.addMetadataItem(M_TOC_TITLE, "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(this.getMessage(AgsI18NCode.MSG_AGS_TABLE_OF_CONTENTS));
        return resultSetXML;
    }

    private ResultSet buildTocLabelPartition(String label) {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        resultSetXML.addMetadataItem("tocLabel", "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(label);
        return resultSetXML;
    }

    private ResultSet buildEventListHeaderPartition() {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        resultSetXML.addMetadataItem(M_TASK_TASKIMAGE, "xs:string", "100");
        resultSetXML.addMetadataItem(M_TASK_TASKBOOKMARK, "xs:string", "100");
        resultSetXML.addMetadataItem(M_TASK_TASKNAME, "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue("../ags/images/tasks/action_edit_condition.gif");
        resultSetXML.addValue("EventBookmark");
        if (this.m_truncatedFrom != null && this.m_truncatedTo != null) {
            resultSetXML.addValue(this.getMessage(AgsI18NCode.MSG_AGS_EVENT_LIST_TRUNC, new Object[]{this.m_truncatedFrom.toString(), this.m_truncatedTo.toString()}));
        } else {
            resultSetXML.addValue(this.getMessage(AgsI18NCode.MSG_AGS_EVENT_LIST));
        }
        return resultSetXML;
    }

    private ResultSet buildTaskHeaderPartition(TaskRunDescriptor taskRunDescriptor, int taskNum) {
        ResultSetXML resultSetXML = new ResultSetXML(this.m_contentLocale);
        resultSetXML.addMetadataItem(M_TASK_TASKIMAGE, "xs:string", "100");
        resultSetXML.addMetadataItem(M_TASK_TASKBOOKMARK, "xs:string", "100");
        resultSetXML.addMetadataItem(M_TASK_TASKNAME, "xs:string", "100");
        resultSetXML.addRow();
        resultSetXML.addValue(taskRunDescriptor.buildTaskHeaderImage());
        resultSetXML.addValue(M_TASK_TASKBOOKMARK + taskNum);
        resultSetXML.addValue(taskRunDescriptor.buildTaskName());
        return resultSetXML;
    }

    private String getMessage(I18NCode msgCode) {
        return I18NUtil.getMessage((I18NCode)msgCode, (Locale)this.m_productLocale);
    }

    private String getMessage(I18NCode msgCode, Object[] params) {
        return I18NUtil.getMessage((I18NCode)msgCode, (Object[])params, (Locale)LocaleUtil.createProductLocale((String)this.m_productLocale.toString()));
    }
}

