/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml.descriptors;

import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.Locale;

public class AttachmentDescriptor {
    private static final String M_EVENT_OUTPUT_SEARCHPATH = "eventOutput";
    private String m_attachmentImage;
    private String m_attachmentName;
    private String m_attachmentFormat;

    public AttachmentDescriptor(MemoPartAgentObject memoPartAgentObject, Locale locale, BiBusHeader header) {
        if (memoPartAgentObject.getSearchPath().get_value().equals(M_EVENT_OUTPUT_SEARCHPATH)) {
            this.m_attachmentName = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_EVENT_LIST_TITLE, (Locale)locale);
            this.m_attachmentFormat = "html";
        } else {
            this.m_attachmentName = memoPartAgentObject.getName();
            this.m_attachmentFormat = memoPartAgentObject.getFormat();
        }
        if (this.m_attachmentFormat == null || this.m_attachmentFormat.length() == 0) {
            try {
                this.m_attachmentFormat = LocaleUtil.getUserPreference((String)"format", (BiBusHeader)header);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_attachmentImage = this.buildAttachmentImage(this.m_attachmentFormat);
    }

    public String getAttachmentImage() {
        return this.m_attachmentImage;
    }

    public String getAttachmentName() {
        return this.m_attachmentName;
    }

    public String getAttachmentFormat() {
        return this.m_attachmentFormat;
    }

    private String buildAttachmentImage(String attachment_format) {
        String ret_value = "";
        String lowerCaseFormat = attachment_format.toLowerCase(Locale.ENGLISH);
        String imageLocation = "../ps/portal/images/";
        ret_value = lowerCaseFormat.equals("singlexls") ? "icon_result_excel_single_32.gif" : (lowerCaseFormat.equals("xls") ? "icon_result_excel_32.gif" : (lowerCaseFormat.equals("xlwa") ? "icon_result_excel_web_arch_32.gif" : (lowerCaseFormat.equals("spreadsheetml") ? "icon_result_excel_2007_32.gif" : (lowerCaseFormat.equals("xlsxData") ? "icon_result_xlsxdata_32.gif" : "icon_result_" + lowerCaseFormat + "_32.gif"))));
        return imageLocation + ret_value;
    }
}

