/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml.descriptors;

import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class DeliveryOptionDescriptor {
    private String m_email_to;
    private String m_email_cc;
    private String m_email_bcc;
    private String m_subject;
    private String m_txt_body;
    private String m_html_body;
    private ArrayList m_attachments;
    private ArrayList m_links;
    private JobBiBusHeaders m_headers;

    public DeliveryOptionDescriptor(JobBiBusHeaders headers, Option[] options) {
        this.m_headers = headers;
        this.m_attachments = new ArrayList();
        this.m_links = new ArrayList();
        this.process(options);
    }

    public String getEmailBCC() {
        return this.m_email_bcc;
    }

    public String getEmailCC() {
        return this.m_email_cc;
    }

    public String getEmailTo() {
        return this.m_email_to;
    }

    public String getHTMLBody() {
        return this.m_html_body;
    }

    public String getEmailSubject() {
        return this.m_subject;
    }

    public String getEmailTxtBody() {
        return this.m_txt_body;
    }

    public ArrayList getAttachments() {
        return this.m_attachments;
    }

    public ArrayList getLinks() {
        return this.m_links;
    }

    private void process(Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            DeliveryOptionSearchPathMultipleObjectArray cm_recipients;
            DeliveryOptionAddressSMTPArray external_recipients;
            if (!(options[i] instanceof DeliveryOption)) continue;
            DeliveryOption deliveryOption = (DeliveryOption)options[i];
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.subject)) {
                DeliveryOptionString subject = (DeliveryOptionString)deliveryOption;
                this.m_subject = subject.getValue();
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.toAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_email_to = this.updateString(this.m_email_to, this.processExternalRecipients(external_recipients));
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.to)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_email_to = this.updateString(this.m_email_to, this.processInternalRecipients(cm_recipients));
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.ccAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_email_cc = this.updateString(this.m_email_cc, this.processExternalRecipients(external_recipients));
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.cc)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_email_cc = this.updateString(this.m_email_cc, this.processInternalRecipients(cm_recipients));
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.bccAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_email_bcc = this.updateString(this.m_email_bcc, this.processExternalRecipients(external_recipients));
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.bcc)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_email_bcc = this.updateString(this.m_email_bcc, this.processInternalRecipients(cm_recipients));
                continue;
            }
            if (!deliveryOption.getName().equals((Object)DeliveryOptionEnum.memoPart)) continue;
            DeliveryOptionMemoPart memoPart = (DeliveryOptionMemoPart)deliveryOption;
            this.processMemoPart(memoPart.getValue());
        }
    }

    private String updateString(String a, String b) {
        return a == null ? b : a + b;
    }

    private void processMemoPart(MemoPart memoPart) {
        if (memoPart instanceof MemoPartComposite) {
            MemoPartComposite composite = (MemoPartComposite)memoPart;
            MemoPart[] mps = composite.getParts();
            for (int i = 0; i < mps.length; ++i) {
                this.processMemoPart(mps[i]);
            }
        } else if (memoPart instanceof MemoPartMIMEAttachment) {
            MemoPartMIMEAttachment memoPartMimeAttachment = (MemoPartMIMEAttachment)memoPart;
            if (memoPartMimeAttachment.getDataType().equals("text/html") && memoPartMimeAttachment.getContentDisposition().equals((Object)SmtpContentDispositionEnum.inline)) {
                try {
                    this.m_html_body = new String(memoPartMimeAttachment.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else if (memoPart instanceof MemoPartString) {
            this.m_txt_body = ((MemoPartString)memoPart).getText();
        } else if (!(memoPart instanceof MemoPartObject)) {
            if (memoPart instanceof MemoPartAgentObject) {
                this.m_attachments.add((MemoPartAgentObject)memoPart);
            } else if (memoPart instanceof MemoPartObjectLinks) {
                this.processObjectLinks((MemoPartObjectLinks)memoPart);
            }
        }
    }

    private String processExternalRecipients(DeliveryOptionAddressSMTPArray external_recipients) {
        String ret_value = "";
        for (int i = 0; i < external_recipients.getValue().length; ++i) {
            AddressSMTP smtpAddress = external_recipients.getValue()[i];
            String smtpAddressValue = smtpAddress.get_value();
            ret_value = ret_value + smtpAddressValue + " ";
        }
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processInternalRecipients(DeliveryOptionSearchPathMultipleObjectArray external_recipients) {
        String ret_value = "";
        SearchPathMultipleObject[] externalSearchPaths = external_recipients.getValue();
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
        if (externalSearchPaths != null && externalSearchPaths.length > 0) {
            QueryRequest[] queryRequests = new QueryRequest[externalSearchPaths.length];
            for (int i = 0; i < externalSearchPaths.length; ++i) {
                QueryRequest request = new QueryRequest();
                request.setSearch(externalSearchPaths[i].get_value());
                request.setProperties(new PropEnum[]{PropEnum.defaultName});
                queryRequests[i] = request;
            }
            try {
                QueryReply[] replies = cmPort.queryMultiple(queryRequests);
                if (replies != null && replies.length > 0) {
                    for (int j = 0; j < replies.length; ++j) {
                        BaseClass[] baseClasses;
                        QueryReply reply = replies[j];
                        if (reply == null || (baseClasses = reply.getQueryResult()) == null || baseClasses.length <= 0) continue;
                        ret_value = ret_value + baseClasses[0].getDefaultName().getValue() + " ";
                    }
                }
            }
            catch (SDKClientException sDKClientException) {
            }
            catch (EMFSecurityException eMFSecurityException) {
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processObjectLinks(MemoPartObjectLinks linkObject) {
        ObjectLink[] objectLinks = linkObject.getLinks();
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
        if (objectLinks != null && objectLinks.length > 0) {
            QueryRequest[] queryRequests = new QueryRequest[objectLinks.length];
            for (int i = 0; i < objectLinks.length; ++i) {
                QueryRequest request = new QueryRequest();
                request.setSearch(objectLinks[i].getSearchPath().get_value());
                request.setProperties(new PropEnum[]{PropEnum.defaultName});
                queryRequests[i] = request;
            }
            try {
                QueryReply[] replies = cmPort.queryMultiple(queryRequests);
                if (replies != null && replies.length > 0) {
                    for (int j = 0; j < replies.length; ++j) {
                        BaseClass[] baseClasses;
                        QueryReply reply = replies[j];
                        if (reply == null || (baseClasses = reply.getQueryResult()) == null || baseClasses.length <= 0) continue;
                        objectLinks[j].setLabel(baseClasses[0].getDefaultName().getValue());
                        this.m_links.add(objectLinks[j]);
                    }
                }
            }
            catch (SDKClientException sDKClientException) {
            }
            catch (EMFSecurityException eMFSecurityException) {
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
    }
}

