/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.xhtml.descriptors;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentTask;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseDataIntegrationTask;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.ContentTask;
import com.cognos.developer.schemas.bibus._3.EventTypeEnum;
import com.cognos.developer.schemas.bibus._3.EventTypeEnumArrayProp;
import com.cognos.developer.schemas.bibus._3.ExportDeployment;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.ImportDeployment;
import com.cognos.developer.schemas.bibus._3.IndexUpdateTask;
import com.cognos.developer.schemas.bibus._3.InteractiveReport;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MetadataModelItemNameProp;
import com.cognos.developer.schemas.bibus._3.MigrationTask;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PlanningMacroTask;
import com.cognos.developer.schemas.bibus._3.PowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.PowerPlay8ReportView;
import com.cognos.developer.schemas.bibus._3.PowerPlayReport;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.RunConditionEnum;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tasks.AgentTaskOutputStateService;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TaskRunDescriptor {
    private TaskRun m_taskRun;

    public TaskRunDescriptor(TaskRun taskRun) {
        this.m_taskRun = taskRun;
    }

    public TaskRun getTaskRun() {
        return this.m_taskRun;
    }

    private TASK_TYPE getHumanTaskType() {
        TASK_TYPE humanTaskType = null;
        Document beplXMLDoc = this.getHumanTaskDocument();
        Element humanTaskElement = null;
        if (beplXMLDoc != null) {
            humanTaskElement = (Element)beplXMLDoc.selectSingleNode("//*[local-name()='beplNotification']");
            if (humanTaskElement != null) {
                humanTaskType = TASK_TYPE.NOTIFICATION;
            } else {
                humanTaskElement = (Element)beplXMLDoc.selectSingleNode("//*[local-name()='beplTask']");
                if (humanTaskElement != null) {
                    humanTaskType = TASK_TYPE.APPROVAL;
                }
            }
        }
        return humanTaskType;
    }

    public Document getHumanTaskDocument() {
        Document beplXMLDoc = null;
        BaseClass baseClass = this.m_taskRun.task().getBaseClass();
        if (baseClass instanceof HumanTask) {
            String htsValue;
            HumanTask humanTask = (HumanTask)baseClass;
            ParameterValueArrayProp parameterProp = humanTask.getParameters();
            ParameterValue[] paramValueArr = parameterProp.getValue();
            ParameterValue paramValue = ObjectModelUtil.findParameter((ParameterValue[])paramValueArr, (String)"hts");
            ParmValueItem[] valueItem = paramValue.getValue();
            if (paramValue != null && valueItem.length > 0 && (htsValue = ObjectModelUtil.getParameterValue((ParmValueItem)valueItem[0])) != null && htsValue.length() > 0) {
                try {
                    beplXMLDoc = DocumentHelper.parseText((String)htsValue);
                }
                catch (DocumentException ex) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("cannot retrieve the human task document for preview: " + ex.getMessage());
                }
            }
        }
        return beplXMLDoc;
    }

    public String buildTaskName() {
        BaseClass baseClass = this.m_taskRun.task().getBaseClass();
        String ret_value = "";
        if (baseClass instanceof BaseRSSTask || baseClass instanceof StoredProcedureTask || baseClass instanceof WebServiceTask || baseClass instanceof Memo) {
            ret_value = this.m_taskRun.task().getBaseClass().getDefaultName().getValue();
        } else if (baseClass != null && baseClass.getDefaultName() != null) {
            ret_value = baseClass.getDefaultName().getValue();
        }
        return ret_value;
    }

    public String buildTaskHeaderImage() {
        String ret_value = null;
        BaseClass baseClass = this.m_taskRun.task().getBaseClass();
        if (baseClass instanceof BaseAgentDefinition) {
            ret_value = "../ags/images/tasks/action_new_agent.gif";
        } else if (baseClass instanceof Report || baseClass instanceof ReportView || baseClass instanceof Query || baseClass instanceof Analysis || baseClass instanceof InteractiveReport) {
            ret_value = "../ags/images/tasks/action_new_report.gif";
        } else if (baseClass instanceof PowerPlayReport) {
            ret_value = "../ags/images/tasks/icon_pp_report.gif";
        } else if (baseClass instanceof PowerPlay8Report || baseClass instanceof PowerPlay8ReportView) {
            ret_value = "../ags/images/tasks/icon_pp8_report.gif";
        } else if (baseClass instanceof JobDefinition) {
            ret_value = "../ags/images/tasks/action_new_job.gif";
        } else if (baseClass instanceof ImportDeployment) {
            ret_value = "../ags/images/tasks/action_new_import.gif";
        } else if (baseClass instanceof ExportDeployment) {
            ret_value = "../ags/images/tasks/action_new_export.gif";
        } else if (baseClass instanceof ContentTask) {
            ret_value = "../ags/images/tasks/action_new_content_maintenance.gif";
        } else if (baseClass instanceof StoredProcedureTask) {
            ret_value = "../ags/images/tasks/action_new_SQL_writeback.gif";
        } else if (baseClass instanceof WebServiceTask) {
            ret_value = "../ags/images/tasks/action_new_web_service.gif";
        } else if (baseClass instanceof Memo) {
            ret_value = "../ags/images/tasks/action_new_email.gif";
        } else if (baseClass instanceof BaseRSSTask) {
            ret_value = "../ags/images/menu/action_new_newsitem.gif";
        } else if (baseClass instanceof BaseDataIntegrationTask) {
            ret_value = "../ags/images/menu/action_new_metrics_maintenance.gif";
        } else if (baseClass instanceof IndexUpdateTask) {
            ret_value = "../ags/images/menu/action_new_index_update.gif";
        } else if (baseClass instanceof PlanningMacroTask) {
            ret_value = "../ags/images/menu/action_new_planning_macro.gif";
        } else if (baseClass instanceof MigrationTask) {
            ret_value = "../ags/images/menu/action_new_migration.gif";
        } else if (baseClass instanceof HumanTask && this.getHumanTaskType().equals((Object)TASK_TYPE.NOTIFICATION)) {
            ret_value = "../ags/images/menu/action_notification.gif";
        } else if (baseClass instanceof HumanTask && this.getHumanTaskType().equals((Object)TASK_TYPE.APPROVAL)) {
            ret_value = "../ags/images/menu/action_approval_task.gif";
        }
        return ret_value;
    }

    public String buildTaskHeaderDescription(boolean noEvents, Locale locale) {
        String ret_value = "";
        AgentTask agentTask = (AgentTask)this.m_taskRun.task().getParent();
        EventTypeEnumArrayProp eventTypes = agentTask.getAgentTaskDefinition().getEventTypes();
        ret_value = this.m_taskRun.failed() ? this.buildFailedTaskHeaderDescription(locale) : (noEvents ? this.buildNoEventsTaskHeaderDescription(locale) : (eventTypes != null && eventTypes.getValue() != null && eventTypes.getValue().length > 0 ? this.buildTaskHeaderDescriptionExecutionRules(locale) : this.buildTaskHeaderDescriptionNoExecutionRules(locale)));
        return ret_value;
    }

    public String buildFailedTaskHeaderDescription(Locale locale) {
        return I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_FAILED_TASK_DESCRIPTION, (Object[])new Object[]{this.buildTaskName()}, (Locale)locale);
    }

    public String buildNoEventsTaskHeaderDescription(Locale locale) {
        String ret_value;
        block5: {
            ret_value = "";
            BaseClass baseClass = this.m_taskRun.task().getBaseClass();
            if (baseClass instanceof BaseRSSTask) {
                try {
                    if (AgentTaskOutputStateService.newsItemExists((BaseClass)baseClass, (JobBiBusHeaders)this.m_taskRun.task().getHeaders())) {
                        ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_EXISTS_NO_EVENTS_DESCRIPTION, (Locale)locale);
                        break block5;
                    }
                    ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_NO_EVENTS_DESCRIPTION, (Locale)locale);
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("cannot determine existence of newsitem for preview: " + e.getMessage());
                }
            } else {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_TASK_NO_EVENTS_DESCRIPTION, (Locale)locale);
            }
        }
        return ret_value;
    }

    public String buildTaskHeaderDescriptionExecutionRules(Locale locale) {
        String ret_value;
        block30: {
            ret_value = "";
            boolean prompts = this.taskRunHasPrompts();
            String taskSuppressionDescription = this.buildTaskSuppressionDescription(locale);
            BaseClass baseClass = this.m_taskRun.task().getBaseClass();
            if (baseClass instanceof BaseAgentDefinition) {
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_AGENT_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_AGENT_NO_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof Report || baseClass instanceof ReportView || baseClass instanceof Query || baseClass instanceof Analysis || baseClass instanceof InteractiveReport) {
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_REPORT_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_REPORT_NO_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof JobDefinition) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_JOB_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof ImportDeployment) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_IMPORT_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof ExportDeployment) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_EXPORT_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof ContentTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_CONTENT_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof StoredProcedureTask) {
                int no_of_runs = this.maxNumberOfParameters();
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_SQL_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription, new Integer(no_of_runs)}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_SQL_NO_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof WebServiceTask) {
                int no_of_runs = this.maxNumberOfParameters();
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_WEBSERVICE_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription, new Integer(no_of_runs)}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_WEBSERVICE_NO_PROMPTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof IndexUpdateTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_INDEX_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof Memo) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_MEMO_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof BaseRSSTask) {
                try {
                    if (AgentTaskOutputStateService.newsItemExists((BaseClass)baseClass, (JobBiBusHeaders)this.m_taskRun.task().getHeaders())) {
                        ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_EXISTS_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
                        break block30;
                    }
                    ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("cannot determine existence of newsitem for preview: " + e.getMessage());
                }
            } else if (baseClass instanceof BaseDataIntegrationTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_METRIC_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof PlanningMacroTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PLANNING_MACRO_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            } else if (baseClass instanceof MigrationTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_MIGRATION_DESCRIPTION_EXECUTION_RULES, (Object[])new Object[]{taskSuppressionDescription}, (Locale)locale);
            }
        }
        return ret_value;
    }

    public String buildTaskHeaderDescriptionNoExecutionRules(Locale locale) {
        AgentTask taskStep;
        String ret_value;
        block31: {
            ret_value = "";
            boolean prompts = this.taskRunHasPrompts();
            BaseClass baseClass = this.m_taskRun.task().getBaseClass();
            if (baseClass instanceof BaseAgentDefinition) {
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_AGENT_PROMPTS_DESCRIPTION, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_AGENT_NO_PROMPTS_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof Report || baseClass instanceof ReportView || baseClass instanceof Query || baseClass instanceof Analysis || baseClass instanceof InteractiveReport) {
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_REPORT_PROMPTS_DESCRIPTION, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_REPORT_NO_PROMPTS_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof JobDefinition) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_JOB_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof ImportDeployment) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_IMPORT_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof ExportDeployment) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_EXPORT_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof ContentTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_CONTENT_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof IndexUpdateTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_INDEX_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof StoredProcedureTask) {
                int no_of_runs = this.maxNumberOfParameters();
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_SQL_PROMPTS_DESCRIPTION, (Object[])new Object[]{new Integer(no_of_runs)}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_SQL_NO_PROMPTS_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof WebServiceTask) {
                int no_of_runs = this.maxNumberOfParameters();
                ret_value = prompts ? I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_WEBSERVICE_PROMPTS_DESCRIPTION, (Object[])new Object[]{new Integer(no_of_runs)}, (Locale)locale) : I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_WEBSERVICE_NO_PROMPTS_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof Memo) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_MEMO_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof BaseRSSTask) {
                try {
                    if (AgentTaskOutputStateService.newsItemExists((BaseClass)baseClass, (JobBiBusHeaders)this.m_taskRun.task().getHeaders())) {
                        ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_EXISTS_DESCRIPTION, (Locale)locale);
                        break block31;
                    }
                    ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NEWSITEM_DESCRIPTION, (Locale)locale);
                }
                catch (Exception e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("cannot determine existence of newsitem for preview: " + e.getMessage());
                }
            } else if (baseClass instanceof BaseDataIntegrationTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_METRIC_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof PlanningMacroTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PLANNING_MACRO_DESCRIPTION, (Locale)locale);
            } else if (baseClass instanceof MigrationTask) {
                ret_value = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_MIGRATION_DESCRIPTION, (Locale)locale);
            }
        }
        if (this.m_taskRun.task().getParent() instanceof AgentTask && RunConditionEnum.runOnFailure.equals((Object)(taskStep = (AgentTask)this.m_taskRun.task().getParent()).getTaskRunCondition())) {
            ret_value = ret_value + " " + I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_FAILED_DESCRIPTION, (Locale)locale);
        }
        return ret_value;
    }

    public int maxNumberOfParameters() {
        int totalRowsCount = 0;
        if (this.m_taskRun.runInfo() != null) {
            for (int i = 0; i < this.m_taskRun.runInfo().length; ++i) {
                ParameterValue[] parameters = this.m_taskRun.runInfo()[i].parameters();
                if (parameters == null) continue;
                for (int j = 0; j < parameters.length; ++j) {
                    int length = parameters[j].getValue().length;
                    if (length <= totalRowsCount) continue;
                    totalRowsCount = length;
                }
            }
        }
        return totalRowsCount;
    }

    public String buildTaskSuppressionDescription(Locale locale) {
        String filter;
        MetadataModelItemNameProp filterProp;
        EventTypeEnum[] eventTypes;
        AgentTaskDefinition agentTaskDefinition = (AgentTaskDefinition)this.m_taskRun.task().getParent().getBaseClass();
        StringBuffer ret_value = new StringBuffer("");
        if (agentTaskDefinition.getEventTypes() != null && (eventTypes = agentTaskDefinition.getEventTypes().getValue()) != null) {
            int i;
            ArrayList<EventTypeEnum> processedEventTypes = new ArrayList<EventTypeEnum>();
            boolean ongoingSeenBefore = false;
            for (i = 0; i < eventTypes.length; ++i) {
                EventTypeEnum type = eventTypes[i];
                if (type.getValue().equals(ResultSetFilterEnum.CHANGED.getValue()) || type.getValue().equals(ResultSetFilterEnum.UNCHANGED.getValue())) {
                    if (ongoingSeenBefore) continue;
                    processedEventTypes.add(type);
                    ongoingSeenBefore = true;
                    continue;
                }
                processedEventTypes.add(type);
            }
            int isz = processedEventTypes.size();
            for (i = 0; i < isz; ++i) {
                String suppressionMessage = null;
                EventTypeEnum type = (EventTypeEnum)processedEventTypes.get(i);
                if (type.getValue().equals(ResultSetFilterEnum.NEW.getValue())) {
                    suppressionMessage = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_NEW_EVENTS, (Locale)locale);
                } else if (type.getValue().equals(ResultSetFilterEnum.DELETED.getValue())) {
                    suppressionMessage = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_CEASED_EVENTS, (Locale)locale);
                } else if (type.getValue().equals(ResultSetFilterEnum.CHANGED.getValue())) {
                    suppressionMessage = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_ONGOING_EVENTS, (Locale)locale);
                } else if (type.getValue().equals(ResultSetFilterEnum.UNCHANGED.getValue())) {
                    suppressionMessage = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_ONGOING_EVENTS, (Locale)locale);
                } else if (type.getValue().equals(ResultSetFilterEnum.NIL.getValue())) {
                    suppressionMessage = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_NO_EVENTS, (Locale)locale);
                }
                ret_value.append(suppressionMessage);
                if (i >= isz - 1) continue;
                ret_value.append(I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_LIST_SEPARATOR, (Locale)locale) + " ");
            }
        }
        if ((filterProp = agentTaskDefinition.getFilterDataItemName()) != null && filterProp.getValue() != null && (filter = filterProp.getValue().get_value()) != null && filter.length() > 0) {
            ret_value.append(I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_LIST_SEPARATOR, (Locale)locale) + " ");
            ret_value.append(I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_PREVIEW_TASK_LEVEL_FILTER, (Object[])new Object[]{filter}, (Locale)locale) + " ");
        }
        return ret_value.toString();
    }

    public boolean taskRunHasPrompts() {
        TaskRunInfo taskRunInfo;
        ParameterValue[] parameters;
        boolean prompts = false;
        if (this.m_taskRun.runInfo() != null && this.m_taskRun.runInfo().length > 0 && (parameters = (taskRunInfo = this.m_taskRun.runInfo()[0]).parameters()) != null && parameters.length > 0) {
            prompts = true;
        }
        return prompts;
    }

    public static enum TASK_TYPE {
        NOTIFICATION,
        APPROVAL;

    }
}

