/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.accesscontrol;

import com.ibm.cognos.camaaa.internal.accesscontrol.BridgeIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMCachedIdentityProvider;
import com.ibm.cognos.camaaa.internal.accesscontrol.CAMIdentityCache;
import com.ibm.cognos.camaaa.internal.auth.TenancyInfoImpl;
import com.ibm.cognos.camaaa.internal.auth.soap.TenancyInfo;
import com.ibm.cognos.camaaa.internal.common.exception.InternalErrorException;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.service.CAMAsyncServiceHandler;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.internal.camaaa.accesscontrol.AccessControlException;
import com.ibm.cognos.internal.camaaa.accesscontrol.Identity;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public class BridgeIdentityProviderImpl
extends CAMCachedIdentityProvider
implements BridgeIdentityProvider {
    private static final XPath QUERY_RESPONSE_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='Body']/*[local-name()='queryResponse']");
    private static final XPath CAM_PASSPORT_ID_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='Header']/*[local-name()='biBusHeader']/*[local-name()='CAM']/*[local-name()='CAMPassport']/*[local-name()='id']/text()");
    private static final XPath IDENTITY_VALUES_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='searchPath']/*[local-name()='value']");
    private static final String QUERY_RESULT_ITEM_XPATH_EXP = "./*[local-name()='queryResult']/*[local-name()='item']";
    private static final String VALUES_XPATH_EXP = "/*[local-name()='value']";
    private static final String ITEM_XPATH_EXP = "/*[local-name()='item']";
    private static final XPath TENANTID_VALUES_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='tenantID']/*[local-name()='value']");
    private static final XPath READTENANTID_VALUES_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='readTenantIDs']/*[local-name()='item']");
    private static final XPath WRITETENANTID_VALUES_XPATH_EXP = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='queryResult']/*[local-name()='item']/*[local-name()='writeTenantID']/*[local-name()='value']");
    private static final String XSD_STRING = "xsd:string";

    public BridgeIdentityProviderImpl(long theCacheTimeoutInSeconds) {
        super(theCacheTimeoutInSeconds);
    }

    private Element constructSoapHeader(String thePassportId) {
        Element soapHeader = DocumentHelper.createElement((QName)XMLConstants.SOAPENV_HEADER);
        soapHeader.addNamespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/");
        soapHeader.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        soapHeader.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        soapHeader.addNamespace("bus", "http://developer.cognos.com/schemas/bibus/3/");
        Element biBusHeader = soapHeader.addElement(XMLConstants.BIBUS_BIBUSHEADER);
        biBusHeader.addAttribute(XMLConstants.XSI_TYPE, "bus:biBusHeader");
        Element cam = biBusHeader.addElement("CAM");
        cam.addAttribute(XMLConstants.XSI_TYPE, "bus:CAM");
        Element camPassport = cam.addElement("CAMPassport");
        camPassport.addAttribute(XMLConstants.XSI_TYPE, "bus:CAMPassport");
        Element id = camPassport.addElement("id");
        id.addAttribute(XMLConstants.XSI_TYPE, XSD_STRING);
        id.setText(thePassportId);
        return soapHeader;
    }

    public Identity getIdentity(Element soapHeader) throws AccessControlException {
        try {
            Document doc;
            try {
                doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)super.constructSoapRequest(soapHeader));
            }
            catch (DocumentException e) {
                throw new InternalErrorException(BridgeIdentityProviderImpl.class.getName(), (Exception)((Object)e));
            }
            Element soapResponseElement = CAMAsyncServiceHandler.getInstance().invokeImpl(doc, "http://developer.cognos.com/schemas/bibus/3#CAM.auth");
            return super.createIdentity(soapResponseElement);
        }
        catch (LocalizableException e) {
            throw new AccessControlException("AAA_ACM_E_AUTHENTICATION_FAILED_FOR_IDENTITY", (Exception)((Object)e));
        }
    }

    @Override
    public Identity getIdentity(String passportId, int generation) throws AccessControlException {
        Identity identity = super.getIdentityFromCache(passportId, generation);
        if (identity == null) {
            identity = this.getIdentity(this.constructSoapHeader(passportId));
            this.addCAMIdentityToTheCache((CAMIdentityCache)identity);
        }
        return identity;
    }

    @Override
    public Identity updateIdentity(String authenticateResponse) throws AccessControlException {
        Document doc = null;
        try {
            doc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)authenticateResponse);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        if (doc != null) {
            return this.updateIdentity(doc.getRootElement());
        }
        return null;
    }

    @Override
    public Identity updateIdentity(Element authenticateResponse) throws AccessControlException {
        Element queryResponse;
        Identity identity = null;
        if (authenticateResponse != null && (queryResponse = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((XPath)QUERY_RESPONSE_XPATH_EXP, (Node)authenticateResponse)) != null) {
            String passportId = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.valueOf((XPath)CAM_PASSPORT_ID_XPATH_EXP, (Node)authenticateResponse);
            List identityValueElements = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectElements((XPath)IDENTITY_VALUES_XPATH_EXP, (Node)queryResponse);
            TenancyInfo tenancyInfo = this.getTenancyFromResponse(queryResponse);
            identity = this.updateIdentity(passportId, identityValueElements, tenancyInfo);
        }
        return identity;
    }

    private TenancyInfo getTenancyFromResponse(Element authenticateResponse) {
        TenancyInfoImpl tenancyInfo = new TenancyInfoImpl();
        this.getTenantFromResponse(authenticateResponse, (TenancyInfo)tenancyInfo, TENANTID_VALUES_XPATH_EXP, TenancyInfo.TenancyType.TENANTID);
        this.getTenantFromResponse(authenticateResponse, (TenancyInfo)tenancyInfo, READTENANTID_VALUES_XPATH_EXP, TenancyInfo.TenancyType.READ_TENANTID);
        this.getTenantFromResponse(authenticateResponse, (TenancyInfo)tenancyInfo, WRITETENANTID_VALUES_XPATH_EXP, TenancyInfo.TenancyType.WRITE_TENANTID);
        return tenancyInfo;
    }

    private void getTenantFromResponse(Element authenticateResponse, TenancyInfo tenancyInfo, XPath xPathExpr, TenancyInfo.TenancyType tenancyType) {
        Element tenantID = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((XPath)xPathExpr, (Node)authenticateResponse);
        if (tenantID != null) {
            tenancyInfo.setTenancy(tenancyType, tenantID.getTextTrim());
        }
    }

    private Identity updateIdentity(String passportId, List identityValueElements, TenancyInfo tenancyInfo) throws AccessControlException {
        Identity identity = null;
        if (passportId != null && passportId.length() > 0 && identityValueElements != null && identityValueElements.size() > 0) {
            super.removeIdentityFromCacheAndTimer(passportId);
            identity = super.createIdentity(passportId, identityValueElements, tenancyInfo);
            this.addCAMIdentityToTheCache((CAMIdentityCache)identity);
        }
        return identity;
    }
}

