/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.bridge;

import com.cognos.CAM.AAAException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.cognos.camaaa.internal.common.config.Configuration;
import com.ibm.cognos.camaaa.internal.common.config.ConfigurationManager;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.logging.ComponentImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogContext;
import com.ibm.cognos.camaaa.internal.common.logging.LogContextImpl;
import com.ibm.cognos.camaaa.internal.common.logging.LogData;
import com.ibm.cognos.camaaa.internal.common.logging.LogDataImpl;
import com.ibm.cognos.camaaa.internal.common.logging.Logger;
import com.ibm.cognos.camaaa.internal.common.logging.PerfLoggerImpl;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import com.ibm.cognos.camaaa.internal.common.util.CAMEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

class BridgeHelper {
    private static final Pattern BIBUS_NS_URI_V2 = Pattern.compile("http://developer.cognos.com/schemas/bibus/2/");
    private static final String QUERY_RESPONSE = "queryResponse";
    private static final int AUDIT_LOGGING_LEVEL = 10000;
    private static final int PERF_LOGGING_LEVEL = 50000;
    private static final int TRACE_LOGGING_LEVEL = 30000;
    private static final String THE_PROPERTIES_PARAM = "theProperties";
    private static final String THE_ADDITIONAL_INFO_PARAM = "theAdditionalInfo";
    private static final String NON_COGNOS_AUTH_PROVIDER = "./*[local-name()='instances'][@name=\"authProvider\"]/*[local-name()='instance'][@class!='Cognos']";
    private static final String CURRENT_NAMESPACE_FORMAT_XML = "<currentNamespaceFormat xsi:type=\"xsd:string\">http://developer.cognos.com/schemas/CAM/AAANamespaceFormat/3/</currentNamespaceFormat>";
    private static final String XSI_NS_DECL = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ";
    private static final Namespace NS_SOAP_ENV = Namespace.get((String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/");
    private static final String ENVELOPE = "Envelope";
    private static final QName SOAP_ENV_ENVELOPE = DocumentHelper.createQName((String)"Envelope", (Namespace)NS_SOAP_ENV);
    private static final QName SOAP_ENV_ENCODING_STYLE = DocumentHelper.createQName((String)"encodingStyle", (Namespace)NS_SOAP_ENV);
    private static final Namespace NS_SOAP_ENC = Namespace.get((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final String BIBUS_HEADER_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader";
    private static final String SOAP_BODY_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Body";
    private static final String SOAP_BODY_FAULT_XPATH = "/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault";
    private static final String TRACKING_FULL_XPATH_EXPRESSION = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']";
    private static final XPath TRACKING_FULL_XPATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']/*[local-name()='tracking']");
    private static final String ADDINFO_XPATH_EXPRESSION = "/SOAP-ENV:Envelope/SOAP-ENV:Header/bus:biBusHeader/*[local-name()='additionalInfo']";
    private static final String TRACKING_XPATH_EXPRESSION = "./*[local-name()='tracking']";
    private static final XPath TRACKING_XPATH = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.createXPath((String)"./*[local-name()='tracking']");
    private static final String SESSIONCONTEXT = "sessionContext";
    private static final String REQUESTCONTEXT = "requestContext";
    private static final String STEPCONTEXT = "stepContext";
    private static final String SUBREQUEST_CONTEXT = "hopCount";
    private static final QName BIBUS_QUERY_RESPONSE = QName.get((String)"queryResponse", (String)"bus", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final String SOAPENC_ARRAY = "SOAP-ENC:Array";
    private static final String SOAPENC_ARRAYTYPE = "SOAP-ENC:arrayType";
    private static final String AUDIT_PREFIX = "Audit.RTUsage.CAM.AAA.";
    private static final String PERF_PREFIX = "Perf.CAM.AAA.";
    private static final String TRACE_PREFIX = "Trace.CAM.AAA.";
    private static final String GET_NAMESPACE_LIST = "GetNamespaceList";
    private static final String FAILED = "Failed";
    private final ICCLConfiguration configuration;
    private final LogTypedLogger auditLogger;
    private final PerfLoggerImpl perfLogger;
    private final LogTypedLogger traceLogger;

    BridgeHelper(ICCLConfiguration config, String bridgeName) {
        this.configuration = config;
        this.auditLogger = LogTypedLogger.getInstance((String)(AUDIT_PREFIX + bridgeName), LogAuditAccessIndication.class);
        LogTypedLogger perfLogTypedLogger = LogTypedLogger.getInstance((String)(PERF_PREFIX + bridgeName), LogPerfIndication.class);
        this.perfLogger = new PerfLoggerImpl(perfLogTypedLogger);
        this.traceLogger = LogTypedLogger.getInstance((String)(TRACE_PREFIX + bridgeName), LogTraceIndication.class);
    }

    BridgeHelper(String bridgeName) {
        this(CCLConfigurationFactory.getInstance(), bridgeName);
    }

    public void addObjectParameter(String name, Object param, LogData logData) {
        if (param == null) {
            logData.addParameter(name, null);
        } else {
            logData.addParameter(name, param.toString());
        }
    }

    public Document buildRequest(String theRequest, String soapAction, String thePassportID) throws AAAException {
        Document retval = null;
        try {
            Element header;
            Element body;
            Matcher matcher = BIBUS_NS_URI_V2.matcher(theRequest);
            String theNewRequest = matcher.replaceAll("http://developer.cognos.com/schemas/bibus/3/");
            Document request = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)theNewRequest);
            Element soapEnv = request.getRootElement();
            if (thePassportID != null && soapEnv.getName().equals(ENVELOPE)) {
                body = this.getQueryBody(soapEnv);
                header = this.updateHeader(soapEnv, thePassportID);
            } else {
                header = DocumentHelper.createElement((QName)QName.get((String)"Header", (String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
                Element biBusHdr = request.getRootElement();
                biBusHdr.detach();
                header.add(biBusHdr);
                body = DocumentHelper.createElement((QName)QName.get((String)"Body", (String)"SOAP-ENV", (String)"http://schemas.xmlsoap.org/soap/envelope/"));
            }
            Document requestEnvelope = DocumentHelper.createDocument();
            Element rootElement = requestEnvelope.addElement(SOAP_ENV_ENVELOPE);
            rootElement.addAttribute(SOAP_ENV_ENCODING_STYLE, NS_SOAP_ENC.getURI());
            rootElement.add(NS_SOAP_ENV);
            rootElement.add(NS_SOAP_ENC);
            rootElement.add(header);
            rootElement.add(body);
            retval = requestEnvelope;
        }
        catch (DocumentException e) {
            throw new AAAException(e.getLocalizedMessage(), (Throwable)e);
        }
        return retval;
    }

    public LogData createLogData(String operation) {
        LogDataImpl logData = new LogDataImpl();
        logData.init(operation);
        return logData;
    }

    public boolean failed(int theStatus) {
        Object perfIndication = this.perfLogEntry(FAILED, null, null);
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(FAILED);
            logData.addParameter("theStatus", String.valueOf(theStatus));
            this.logAuditIndication(FAILED, "CallStart", logData.toString(), (Element)null);
        }
        boolean ret = theStatus < 0;
        this.logExit(FAILED, String.valueOf(ret), perfIndication, null);
        return ret;
    }

    public ICCLConfiguration getConfiguration() {
        return this.configuration;
    }

    private Configuration getConfiguration(ICCLConfiguration config) throws LocalizableException {
        ConfigurationManager cfg = new ConfigurationManager(config, "./*[local-name()='AAA']/*[local-name()='value']");
        return cfg;
    }

    private String getNamespaceItem(String name, String id, String nsType) {
        StringBuffer item = new StringBuffer();
        item.append("<item xsi:type=\"bus:namespace\">");
        item.append("<defaultName xsi:type=\"bus:tokenProp\">");
        item.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">");
        item.append(CAMEncoder.encode1((String)name));
        item.append("</value>");
        item.append("</defaultName>");
        item.append("<objectClass xsi:type=\"bus:classEnumProp\">");
        item.append("<value xsi:type=\"cm:classEnum\">namespace</value>");
        item.append("</objectClass>");
        item.append("<searchPath xsi:type=\"bus:stringProp\">");
        item.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">CAMID(&quot;");
        item.append(CAMEncoder.encode2((String)id));
        item.append("&quot;)</value></searchPath>");
        item.append("<namespaceType xsi:type=\"bus:stringProp\">");
        item.append("<value xsi:type=\"xsd:string\" xml:space=\"preserve\">");
        item.append(nsType);
        item.append("</value></namespaceType></item>");
        return item.toString();
    }

    public String getNamespaceList(String theAdditionalInfo, String theProperties) {
        Object perfIndication = this.perfLogEntry(GET_NAMESPACE_LIST, null, theAdditionalInfo);
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(GET_NAMESPACE_LIST);
            logData.addParameter(THE_ADDITIONAL_INFO_PARAM, theAdditionalInfo);
            logData.addParameter(THE_PROPERTIES_PARAM, theProperties);
            this.logAuditIndication(GET_NAMESPACE_LIST, "CallStart", logData.toString(), theAdditionalInfo);
        }
        StringBuffer response = new StringBuffer();
        response.append("<bus:queryResponse ");
        response.append("xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" ");
        response.append(XSI_NS_DECL);
        response.append("xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        response.append(CURRENT_NAMESPACE_FORMAT_XML);
        response.append("<queryResult xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[]\">");
        response.append(this.getNamespaceItem("Cognos", ":", "Cognos"));
        try {
            Configuration config = this.getConfiguration(this.getConfiguration());
            Configuration[] namespaceConfig = config.getConfiguration(NON_COGNOS_AUTH_PROVIDER);
            if (namespaceConfig != null) {
                for (int i = 0; i < namespaceConfig.length; ++i) {
                    try {
                        String name = namespaceConfig[i].getMandatoryValue("./@name");
                        String id = namespaceConfig[i].getMandatoryValue("./*[local-name()='parameter' and @name='id']/*[local-name()='value']/text()");
                        String nsType = namespaceConfig[i].getMandatoryValue("./@class");
                        response.append(this.getNamespaceItem(name, id, nsType));
                        continue;
                    }
                    catch (LocalizableException localizableException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (LocalizableException localizableException) {
            // empty catch block
        }
        response.append("</queryResult>");
        response.append("</bus:queryResponse>");
        this.logExit(GET_NAMESPACE_LIST, response, null, perfIndication, theAdditionalInfo);
        return response.toString();
    }

    private Element getQueryBody(Element envelopeElement) {
        Element body = envelopeElement.element(XMLConstants.SOAPENV_BODY);
        body.detach();
        return body;
    }

    public boolean isAuditLoggingEnabled() {
        return this.auditLogger.isEnabled(10000);
    }

    public boolean isPerfLoggingEnabled() {
        return this.perfLogger.isEnabled(50000);
    }

    public boolean isTraceLoggingEnabled() {
        return this.traceLogger.isEnabled(30000);
    }

    public void logAuditIndication(String operation, String logStatus, String logData, Element additionalInfoElement) {
        Element tracking;
        LogAuditAccessIndication indication = new LogAuditAccessIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber());
        String sessionID = null;
        String requestID = null;
        if (additionalInfoElement != null && (tracking = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((XPath)TRACKING_XPATH, (Node)additionalInfoElement)) != null) {
            sessionID = tracking.elementText(SESSIONCONTEXT);
            requestID = tracking.elementText(REQUESTCONTEXT);
        }
        if (indication != null) {
            indication.setSessionID(sessionID);
            indication.setRequestID(requestID);
            indication.setOperation(operation);
            indication.setObjectType(BridgeHelper.class.getName());
            indication.setStatus(logStatus);
            indication.setLevel(10000);
            if (logData != null) {
                indication.setLogData(logData);
            }
            this.auditLogger.log((Object)indication);
        }
    }

    public void logAuditIndication(String operation, String logStatus, String logData, String additionalInfo) {
        Element additionalInfoElement = null;
        if (additionalInfo != null) {
            try {
                additionalInfoElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)additionalInfo).getRootElement();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        this.logAuditIndication(operation, logStatus, logData, additionalInfoElement);
    }

    public void logException(String operation, Exception e, Object perfIndication, Element theAdditionalInfoElement) {
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(operation);
            logData.setException(e);
            this.logAuditIndication(operation, "Failure", logData.toString(), theAdditionalInfoElement);
        }
        this.perfLogExit(perfIndication, operation);
    }

    public void logException(String operation, Exception e, Object perfIndication, String theAdditionalInfo) {
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(operation);
            logData.setException(e);
            this.logAuditIndication(operation, "Failure", logData.toString(), theAdditionalInfo);
        }
        this.perfLogExit(perfIndication, operation);
    }

    public void logExit(String operation, Object ret, Document soapRequest, Object perfIndication, String theAdditionalInfo) {
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(operation);
            if (ret != null) {
                logData.setReturnValue(ret.toString());
            } else {
                logData.setReturnValue(null);
            }
            this.logAuditIndication(operation, "CallEnd", logData.toString(), theAdditionalInfo);
        }
        this.perfLogExit(perfIndication, operation);
    }

    public void logExit(String operation, Object ret, Object perfIndication, Element theAdditionalInfo) {
        if (this.isAuditLoggingEnabled()) {
            LogData logData = this.createLogData(operation);
            if (ret != null) {
                logData.setReturnValue(ret.toString());
            } else {
                logData.setReturnValue(null);
            }
            this.logAuditIndication(operation, "CallEnd", logData.toString(), theAdditionalInfo);
        }
        this.perfLogExit(perfIndication, operation);
    }

    public void logTraceIndication(String operation, String logStatus, String logData, Element additionalInfoElement) {
        Element tracking;
        LogTraceIndication indication = new LogTraceIndication(ComponentImpl.getInstance().getID(), ComponentImpl.getInstance().getBuildNumber());
        String sessionID = null;
        String requestID = null;
        if (additionalInfoElement != null && (tracking = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleElement((XPath)TRACKING_XPATH, (Node)additionalInfoElement)) != null) {
            sessionID = tracking.elementText(SESSIONCONTEXT);
            requestID = tracking.elementText(REQUESTCONTEXT);
        }
        if (indication != null) {
            indication.setSessionID(sessionID);
            indication.setRequestID(requestID);
            indication.setLevel(10000);
            if (logData != null) {
                indication.setMessage(logData);
            }
            this.traceLogger.log((Object)indication);
        }
    }

    public void logTraceIndication(String operation, String logStatus, String logData, String additionalInfo) {
        Element additionalInfoElement = null;
        if (additionalInfo != null) {
            try {
                additionalInfoElement = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)additionalInfo).getRootElement();
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        this.logTraceIndication(operation, logStatus, logData, additionalInfoElement);
    }

    public Object perfLogEntry(String functionName, Document soapRequest, String theAdditionalInfo) {
        Object retval = null;
        if (!this.perfLogger.isEnabled(50000)) {
            return retval;
        }
        String sessionID = null;
        String requestID = null;
        String stepID = null;
        String subRequestID = null;
        Element tracking = null;
        if (soapRequest != null) {
            tracking = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)TRACKING_FULL_XPATH, (Node)soapRequest);
        } else if (theAdditionalInfo != null) {
            try {
                Document addInfoDoc = com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.parseText((String)theAdditionalInfo);
                Element additionalInfo = addInfoDoc.getRootElement();
                tracking = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((XPath)TRACKING_XPATH, (Node)additionalInfo);
            }
            catch (DocumentException addInfoDoc) {
                // empty catch block
            }
        }
        if (tracking != null) {
            sessionID = tracking.elementText(SESSIONCONTEXT);
            requestID = tracking.elementText(REQUESTCONTEXT);
            stepID = tracking.elementText(STEPCONTEXT);
            subRequestID = tracking.elementText(SUBREQUEST_CONTEXT);
        }
        if (subRequestID == null) {
            subRequestID = "0";
        }
        LogContextImpl logContext = new LogContextImpl(sessionID, requestID, Integer.valueOf(subRequestID), stepID);
        if (this.perfLogger.isEnabled(Logger.LEVEL1)) {
            LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
            perfLogData.init(functionName);
            retval = this.perfLogger.logEnter((LogContext)logContext, ComponentImpl.getInstance(), Logger.LEVEL1, BridgeHelper.class.getName(), functionName, "sequenceID", (LogData)perfLogData);
        }
        return retval;
    }

    public void perfLogExit(Object perfIndication, String functionName) {
        if (perfIndication != null && this.isPerfLoggingEnabled() && this.perfLogger.isEnabled(Logger.LEVEL1)) {
            LogDataImpl perfLogData = (LogDataImpl)this.perfLogger.getLogData();
            perfLogData.init(functionName);
            this.perfLogger.logExit(perfIndication, (LogData)perfLogData);
        }
    }

    public void setQueryResponseInTheBody(Element soapEnv) throws AAAException {
        Element body = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)SOAP_BODY_XPATH, (Node)soapEnv);
        Element bodyFault = (Element)com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper.selectSingleNode((String)SOAP_BODY_FAULT_XPATH, (Node)soapEnv);
        if (bodyFault != null) {
            bodyFault.detach();
        }
        Element queryResponse = DocumentHelper.createElement((QName)BIBUS_QUERY_RESPONSE);
        queryResponse.add(new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/"));
        queryResponse.add(new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        Element queryResultElement = queryResponse.addElement("queryResult");
        String baseClassSize = new String(":baseClass[0]");
        queryResultElement.addAttribute(XMLConstants.XSI_TYPE, SOAPENC_ARRAY);
        queryResultElement.addAttribute(SOAPENC_ARRAYTYPE, "bus" + baseClassSize);
        body.add(queryResponse);
        throw new AAAException(soapEnv.asXML());
    }

    public boolean succeeded(int theStatus) {
        return theStatus >= 0;
    }

    public Element trimSearchResponse(Element soapEnv) {
        Element soapBody = soapEnv.element(XMLConstants.SOAPENV_BODY);
        if (soapBody != null) {
            return soapBody.element(QUERY_RESPONSE);
        }
        return null;
    }

    private Element updateHeader(Element envelopeElement, String thePassport) {
        Element header = envelopeElement.element(XMLConstants.SOAPENV_HEADER);
        Element biBusHeader = null;
        if (header != null) {
            biBusHeader = header.element(XMLConstants.BIBUS_BIBUSHEADER);
        }
        Element cam = DocumentHelper.createElement((QName)XMLConstants.BIBUS_CAM);
        Element camPassport = DocumentHelper.createElement((String)"CAMPassport");
        Element id = DocumentHelper.createElement((String)"id");
        id.addText(thePassport);
        camPassport.add(id);
        cam.add(camPassport);
        if (biBusHeader != null) {
            biBusHeader.add(cam);
        } else {
            Element newBiBusHeader = DocumentHelper.createElement((QName)XMLConstants.BIBUS_BIBUSHEADER);
            newBiBusHeader.add(cam);
            if (header != null) {
                header.add(newBiBusHeader);
            }
        }
        header.detach();
        return header;
    }
}

