/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cclcfgapi.base64;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class DecryptTextFunction
implements Function {
    private static final String ENCRYPTED_ATTRIBUTE = "encrypted";
    private CAMFactory camFactory;
    private boolean parseContent;

    DecryptTextFunction() {
        this.parseContent = true;
        this.camFactory = null;
    }

    DecryptTextFunction(boolean theParseContentFlag) {
        this.parseContent = theParseContentFlag;
        this.camFactory = null;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        Object retVal = null;
        if (!args.isEmpty()) {
            for (Object obj : args) {
                if (obj instanceof List) {
                    retVal = this.call(context, (List)obj);
                    continue;
                }
                if (!(obj instanceof Element)) continue;
                Element element = (Element)obj;
                retVal = this.evaluate(context, element);
            }
        }
        return retVal;
    }

    private String decrypt(String cipherText) {
        try {
            if (this.camFactory == null) {
                this.camFactory = new CAMFactory();
                this.camFactory.initialize("<initializeDocument><serviceID>DecryptTextFunction</serviceID></initializeDocument>".getBytes());
            }
            byte[] decodedValue = base64.decode((int)0, (String)cipherText);
            EncryptingSession session = this.camFactory.createEncryptingSession();
            return new String(session.decryptData(decodedValue), "UTF-8");
        }
        catch (CAMCryptoException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private Object evaluateEncryptedText(Context context, Element element) {
        String ciphertext = StringFunction.evaluate((Object)element, (Navigator)context.getNavigator());
        String plainText = "";
        if (ciphertext != null) {
            plainText = this.decrypt(ciphertext);
            if (this.parseContent) {
                return this.parse(plainText);
            }
        }
        return DocumentFactory.getInstance().createText(plainText);
    }

    private Object evaluate(Context context, Element element) {
        String isEncrptyed = element.attributeValue(ENCRYPTED_ATTRIBUTE);
        if (isEncrptyed != null && Boolean.valueOf(isEncrptyed).booleanValue()) {
            return this.evaluateEncryptedText(context, element);
        }
        if (element.isTextOnly()) {
            return element;
        }
        return (Element)element.elements().get(0);
    }

    private Element parse(String plainText) {
        if (plainText != null) {
            try {
                return DocumentHelper.parseText(plainText).getRootElement();
            }
            catch (DocumentException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

