/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.soap;

import com.cognos.pogo.pdk.xml.PooledSAXReader;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.cognos.camaaa.internal.common.soap.BiBusNamespaceContext;
import com.ibm.cognos.camaaa.internal.common.soap.DecryptTextFunction;
import com.ibm.cognos.camaaa.internal.common.soap.ElementTextFunction;
import com.ibm.cognos.camaaa.internal.common.soap.XMLConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.util.NodeComparator;
import org.jaxen.Function;
import org.jaxen.FunctionContext;
import org.jaxen.NamespaceContext;
import org.jaxen.VariableContext;
import org.jaxen.XPathFunctionContext;
import org.xml.sax.SAXException;

public final class DocumentHelper {
    private static final DecryptTextFunction DECRYPT_TEXT_FUNCTION = new DecryptTextFunction();
    private static final DecryptTextFunction DECRYPT_PASSWORD_TEXT_FUNCTION = new DecryptTextFunction(false);
    private static final ElementTextFunction ELEMENT_TEXT_FUNCTION = new ElementTextFunction();
    private static final String UTF8_ENCODING = "UTF-8";

    private DocumentHelper() {
    }

    public static XPath createXPath(String xpathExpression) {
        XPath xpath = DocumentFactory.getInstance().createXPath(xpathExpression);
        XPathFunctionContext fc = new XPathFunctionContext();
        fc.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "element-text", (Function)ELEMENT_TEXT_FUNCTION);
        fc.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "decrypt-text", (Function)DECRYPT_TEXT_FUNCTION);
        fc.registerFunction("http://developer.cognos.com/schemas/CAM/AAA/2/", "decrypt-password-text", (Function)DECRYPT_PASSWORD_TEXT_FUNCTION);
        xpath.setFunctionContext((FunctionContext)fc);
        xpath.setNamespaceContext((NamespaceContext)new BiBusNamespaceContext());
        return xpath;
    }

    public static XPath createXPath(String xpathExpression, VariableContext variableContext) {
        XPath xpath = DocumentHelper.createXPath(xpathExpression);
        xpath.setVariableContext(variableContext);
        return xpath;
    }

    public static String getChildElementText(Element parent, String childName) {
        Element element = parent.element(childName);
        return DocumentHelper.getElementText(element);
    }

    public static String getChildElementText(Element parent, QName childName) {
        Element element = parent.element(childName);
        return DocumentHelper.getElementText(element);
    }

    private static List getElementList(List nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            ArrayList<Node> elements = new ArrayList<Node>();
            for (Node resultNode : nodeList) {
                if (resultNode.getNodeType() != 1) continue;
                elements.add(resultNode);
            }
            return elements;
        }
        return null;
    }

    public static String getElementText(Element element) {
        String xsiNil;
        if (!(element == null || (xsiNil = element.attributeValue(XMLConstants.XSI_NIL)) != null && Boolean.parseBoolean(xsiNil))) {
            return element.getText();
        }
        return null;
    }

    private static PooledSAXReader getSaxReader() {
        SAXReaderPool pool = SAXReaderPool.getInstance();
        PooledSAXReader reader = pool.get();
        return reader;
    }

    public static Document parse(InputStream is) throws DocumentException {
        PooledSAXReader reader = DocumentHelper.getSaxReader();
        try {
            Document document = reader.read(is);
            return document;
        }
        finally {
            reader.release();
        }
    }

    public static void addMissingAttribute(Element theElement, QName theAttributeName, String theAttributeValue) {
        Attribute attr = theElement.attribute(theAttributeName);
        if (attr == null) {
            theElement.addAttribute(theAttributeName, theAttributeValue);
        }
    }

    public static String createQualifiedElementName(String prefix, String name) {
        return prefix + ":" + name;
    }

    public static boolean isXsiNil(Element element) {
        Attribute xsiNil = element.attribute(XMLConstants.XSI_NIL);
        if (xsiNil != null) {
            return Boolean.valueOf(xsiNil.getText());
        }
        return false;
    }

    public static void removeAttribute(Element theElement, QName theAttributeName) {
        Attribute attr = theElement.attribute(theAttributeName);
        if (attr != null) {
            theElement.remove(attr);
        }
    }

    public static Document parse(Reader aReader) throws DocumentException {
        PooledSAXReader reader = DocumentHelper.getSaxReader();
        try {
            Document document = reader.read(aReader);
            return document;
        }
        finally {
            reader.release();
        }
    }

    public static Document parseText(String text) throws DocumentException {
        PooledSAXReader reader = DocumentHelper.getSaxReader();
        try {
            Document document = reader.read((Reader)new StringReader(text));
            return document;
        }
        finally {
            reader.release();
        }
    }

    public static void removeMatchedNodes(Element e, String[] xpaths) {
        ArrayList nodes = new ArrayList();
        for (int i = 0; i < xpaths.length; ++i) {
            nodes.addAll(DocumentHelper.selectNodes(xpaths[i], (Node)e));
        }
        for (Node node : nodes) {
            node.getParent().remove(node);
        }
    }

    public static void removeMatchedNodes(Element e, XPath[] xpaths) {
        ArrayList nodes = new ArrayList();
        for (int i = 0; i < xpaths.length; ++i) {
            nodes.addAll(DocumentHelper.selectNodes(xpaths[i], (Node)e));
        }
        for (Node node : nodes) {
            node.getParent().remove(node);
        }
    }

    public static List selectElements(String xpathExpression, List nodes) {
        List nodeList = DocumentHelper.selectNodes(xpathExpression, nodes);
        return DocumentHelper.getElementList(nodeList);
    }

    public static List selectElements(String xpathExpression, Node node) {
        List nodeList = DocumentHelper.selectNodes(xpathExpression, node);
        return DocumentHelper.getElementList(nodeList);
    }

    public static List selectElements(String xpathFilterExpression, VariableContext variableContext, Node node) {
        List nodeList = DocumentHelper.selectNodes(xpathFilterExpression, variableContext, node);
        return DocumentHelper.getElementList(nodeList);
    }

    public static List selectElements(XPath xpath, Node node) {
        List nodeList = DocumentHelper.selectNodes(xpath, node);
        return DocumentHelper.getElementList(nodeList);
    }

    public static List selectNodes(String xpathFilterExpression, List nodes) {
        if (nodes == null) {
            return new ArrayList();
        }
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath.selectNodes((Object)nodes);
    }

    public static List selectNodes(String xpathFilterExpression, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath.selectNodes((Object)node);
    }

    public static List selectNodes(String xpathFilterExpression, VariableContext variableContext, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression, variableContext);
        return xpath.selectNodes((Object)node);
    }

    public static List selectNodes(XPath xpath, Node node) {
        if (node == null) {
            return new ArrayList();
        }
        return xpath.selectNodes((Object)node);
    }

    public static Element selectSingleElement(String xpathFilterExpression, Node node) {
        List elements = DocumentHelper.selectElements(xpathFilterExpression, node);
        if (elements != null) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public static Element selectSingleElement(XPath xpath, Node node) {
        List nodeList = DocumentHelper.selectElements(xpath, node);
        List elements = DocumentHelper.getElementList(nodeList);
        if (elements != null) {
            return (Element)elements.get(0);
        }
        return null;
    }

    public static Node selectSingleNode(String xpathFilterExpression, Node node) {
        if (node == null) {
            return null;
        }
        XPath xpath = DocumentHelper.createXPath(xpathFilterExpression);
        return xpath.selectSingleNode((Object)node);
    }

    public static Node selectSingleNode(XPath xpath, Node node) {
        if (node == null) {
            return null;
        }
        return xpath.selectSingleNode((Object)node);
    }

    public static String toCompactUtf8String(Element theElement, boolean theSuppressDeclaration) throws SAXException {
        OutputFormat outformat = OutputFormat.createCompactFormat();
        outformat.setSuppressDeclaration(theSuppressDeclaration);
        outformat.setEncoding(UTF8_ENCODING);
        outformat.setExpandEmptyElements(true);
        outformat.setTrimText(false);
        return DocumentHelper.toXmlString(theElement, outformat);
    }

    public static String toPrettyPrintUtf8String(Element theElement, boolean theSuppressDeclaration) throws SAXException {
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setSuppressDeclaration(theSuppressDeclaration);
        outformat.setEncoding(UTF8_ENCODING);
        outformat.setExpandEmptyElements(true);
        outformat.setTrimText(false);
        outformat.setNewlines(true);
        return DocumentHelper.toXmlString(theElement, outformat);
    }

    public static String toXmlString(Element theElement, OutputFormat theFormatter) throws SAXException {
        String retval = null;
        if (theElement != null) {
            theElement.normalize();
            try {
                StringWriter formattedDocument = new StringWriter();
                XMLWriter writer = new XMLWriter((Writer)formattedDocument, theFormatter);
                writer.startDocument();
                writer.write(theElement);
                writer.endDocument();
                writer.flush();
                writer.close();
                retval = formattedDocument.toString();
                formattedDocument.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return retval;
    }

    public static String valueOf(String xpathFilterExpression, Node node) {
        return DocumentHelper.valueOf(xpathFilterExpression, node, null);
    }

    public static String valueOf(String xpathFilterExpression, Node node, String defaultValue) {
        List nodeList = DocumentHelper.selectNodes(xpathFilterExpression, node);
        if (nodeList != null && nodeList.size() > 0) {
            return DocumentHelper.valueOfFromNodeList(nodeList);
        }
        return defaultValue;
    }

    public static String valueOf(XPath xpath, Node node) {
        return DocumentHelper.valueOf(xpath, node, null);
    }

    public static String valueOf(XPath xpath, Node node, String defaultValue) {
        List nodeList = DocumentHelper.selectNodes(xpath, node);
        if (nodeList != null && nodeList.size() > 0) {
            return DocumentHelper.valueOfFromNodeList(nodeList);
        }
        return defaultValue;
    }

    private static String valueOfFromNodeList(List nodeList) {
        boolean foundNotNullValue = false;
        StringBuffer stringResult = new StringBuffer();
        for (Node aNode : nodeList) {
            if (aNode == null || aNode.getStringValue() == null) continue;
            stringResult.append(aNode.getStringValue());
            foundNotNullValue = true;
        }
        if (foundNotNullValue) {
            return stringResult.toString();
        }
        return null;
    }

    public static boolean isConfigurationDifferent(List nodeList1, List nodeList2) {
        boolean retval = false;
        if (nodeList1.size() != nodeList2.size()) {
            retval = true;
        } else {
            Iterator nodeIt1 = nodeList1.iterator();
            Iterator nodeIt2 = nodeList2.iterator();
            while (nodeIt1.hasNext() && nodeIt2.hasNext() && !retval) {
                Node aNode1 = (Node)nodeIt1.next();
                Node aNode2 = (Node)nodeIt2.next();
                retval = DocumentHelper.isConfigurationDifferent(aNode1, aNode2);
            }
        }
        return retval;
    }

    public static boolean isConfigurationDifferent(Node node1, Node node2) {
        boolean retval = false;
        NodeComparator comparator = new NodeComparator();
        if (node1 != null && node2 != null) {
            DocumentHelper.normalizeAndPrune(node1);
            DocumentHelper.normalizeAndPrune(node2);
            retval = comparator.compare(node1, node2) != 0;
        } else {
            retval = node1 == null && node2 == null;
        }
        return retval;
    }

    private static void normalizeAndPrune(Node node) {
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            ((Branch)node).normalize();
            DocumentHelper.prune((Branch)node);
        }
    }

    private static boolean isSimpleType(Element element) {
        boolean retval = false;
        Attribute type = element.attribute(XMLConstants.XSI_TYPE);
        if (type != null) {
            String typeValue = type.getStringValue();
            if (typeValue.equals("cfg:credential")) {
                Attribute encrypted = element.attribute("encrypted");
                retval = encrypted != null && Boolean.getBoolean(encrypted.getStringValue());
            } else if (typeValue.equals("xsd:string") || typeValue.equals("xsd:int") || typeValue.equals("cfg:hostPort") || typeValue.equals("xsd:boolean") || typeValue.equals("cfg:filePath") || typeValue.equals("xsd:anyURI") || typeValue.equals("cfg:anyPathURI") || typeValue.equals("xsd:unsignedShort") || typeValue.equals("xsd:positiveInteger")) {
                retval = true;
            }
        }
        return retval;
    }

    private static boolean isComplexType(Element element) {
        return !DocumentHelper.isSimpleType(element);
    }

    private static void prune(Branch theBranch) {
        PruningVisitor visitor = new PruningVisitor();
        theBranch.accept((Visitor)visitor);
        visitor.removeNodesToPrune();
    }

    public static class PruningVisitor
    extends VisitorSupport {
        private List<Node> toBePruned = new ArrayList<Node>();

        void reset() {
            this.toBePruned.clear();
        }

        public void visit(Comment comment) {
            this.toBePruned.add((Node)comment);
        }

        public void visit(Text node) {
            if (node.getParent() != null && DocumentHelper.isComplexType(node.getParent())) {
                this.toBePruned.add((Node)node);
            }
        }

        public void removeNodesToPrune() {
            ListIterator<Node> it = this.toBePruned.listIterator();
            while (it.hasNext()) {
                Node delme = it.next();
                delme.getParent().remove(delme);
            }
            this.reset();
        }
    }
}

