/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.ibm.cognos.camaaa.internal.common.exception.LocalizableException;
import com.ibm.cognos.camaaa.internal.common.messages.LocalizableMessage;
import com.ibm.cognos.camaaa.internal.common.soap.DocumentHelper;
import com.ibm.cognos.camaaa.internal.common.util.CAMAAServiceCommunicator;
import com.ibm.cognos.camaaa.internal.msgsdk.camaaa_srvc.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.dom4j.Document;
import org.dom4j.DocumentException;

public class CAMAAServiceHttpCommunicator
implements CAMAAServiceCommunicator {
    static final String INTERNAL_DISPATCHER = "internalDispatcher";
    private HttpClient httpClient;
    private final String dispatcherURL;

    CAMAAServiceHttpCommunicator(HttpClient client, String theDispatcherURL) {
        this.httpClient = client;
        this.dispatcherURL = theDispatcherURL;
    }

    public CAMAAServiceHttpCommunicator(URL theDispatcherURL, int theMaxHostConnections) throws LocalizableException {
        this(CAMAAServiceHttpCommunicator.createHttpClient(theDispatcherURL, new CAMFactory(), theMaxHostConnections), theDispatcherURL.getPath());
    }

    static HttpClient createHttpClient(URL theDispatcherURL, CAMFactory cryptoFactory, int theMaxHostConnections) throws LocalizableException {
        try {
            cryptoFactory.initialize("<initializeDocument><serviceID>CAMAAA_Com</serviceID></initializeDocument>".getBytes());
            HttpClient client = cryptoFactory.createHttpClient(theDispatcherURL);
            if (client != null) {
                MultiThreadedHttpConnectionManager multiThreadedHttpConnMgr = new MultiThreadedHttpConnectionManager();
                HttpConnectionManagerParams params = new HttpConnectionManagerParams();
                params.setMaxTotalConnections(theMaxHostConnections);
                multiThreadedHttpConnMgr.setParams(params);
                client.setHttpConnectionManager((HttpConnectionManager)multiThreadedHttpConnMgr);
            }
            return client;
        }
        catch (CAMCryptoException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_CFG_E_CRYPTO_INIT_FAILED"), (Throwable)e);
        }
    }

    @Override
    public void terminate() {
        if (this.httpClient != null) {
            HttpConnectionManager connectionManager = this.httpClient.getHttpConnectionManager();
            if (connectionManager instanceof MultiThreadedHttpConnectionManager) {
                ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
            }
            this.httpClient = null;
        }
    }

    private PostMethod createPostMethod(String requestEnvelope, String soapAction) throws LocalizableException {
        PostMethod postMethod = new PostMethod(this.dispatcherURL);
        postMethod.addRequestHeader("soapaction", soapAction);
        try {
            postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(requestEnvelope, "text/xml", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_COMMUNICATION_ERROR"), (Throwable)e);
        }
        return postMethod;
    }

    private Document executeMethod(PostMethod postMethod) throws LocalizableException {
        try {
            if (this.httpClient == null) {
                throw new IllegalStateException();
            }
            this.httpClient.setState(new HttpState());
            this.httpClient.executeMethod((HttpMethod)postMethod);
            Document responseEnvelope = this.readResponse(postMethod);
            postMethod.releaseConnection();
            return responseEnvelope;
        }
        catch (IOException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_COMMUNICATION_ERROR"), (Throwable)e);
        }
        catch (DocumentException e) {
            throw new LocalizableException((LocalizableMessage)new Message("AAA_SYS_E_SERVER_RESPONSE_ERROR"), (Throwable)e);
        }
    }

    @Override
    public Document processSoapRequest(Document requestEnvelope, String soapAction) throws LocalizableException {
        return this.processSoapRequest(requestEnvelope.asXML(), soapAction);
    }

    @Override
    public Document processSoapRequest(String requestEnvelope, String soapAction) throws LocalizableException {
        PostMethod postMethod = this.createPostMethod(requestEnvelope, soapAction);
        return this.executeMethod(postMethod);
    }

    private Document readResponse(PostMethod postMethod) throws IOException, DocumentException {
        String response = postMethod.getResponseBodyAsString();
        if (response.startsWith("<html")) {
            throw new IOException(response);
        }
        return DocumentHelper.parseText(response);
    }
}

