/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

public final class CAMEncoder {
    private static final String QUOTE_CHAR = "\"";
    private static final String[][] QUOTE_MAP1 = new String[][]{{"\"", "&quot;"}};
    private static final String[][] QUOTE_MAP2 = new String[][]{{"\"", "&amp;quot;"}};
    private static final String[][] SPECIAL_CHARS_MAP = new String[][]{{"&", "&amp;"}, {"'", "&apos;"}, {"<", "&lt;"}, {">", "&gt;"}};

    private CAMEncoder() {
    }

    public static String decode1(String data) {
        String result = data;
        for (int i = SPECIAL_CHARS_MAP.length - 1; i >= 0; --i) {
            result = result.replaceAll(SPECIAL_CHARS_MAP[i][1], SPECIAL_CHARS_MAP[i][0]);
        }
        result = result.replaceAll(QUOTE_MAP1[0][1], QUOTE_MAP1[0][0]);
        return result;
    }

    public static String decode2(String data) {
        String result = data;
        for (int i = SPECIAL_CHARS_MAP.length - 1; i >= 0; --i) {
            result = result.replaceAll(SPECIAL_CHARS_MAP[i][1], SPECIAL_CHARS_MAP[i][0]);
        }
        result = result.replaceAll(QUOTE_MAP2[0][1], QUOTE_MAP2[0][0]);
        return result;
    }

    public static String decodeQuote(String data) {
        return data.replaceAll(QUOTE_MAP1[0][1], QUOTE_MAP1[0][0]);
    }

    public static String encode1(String data) {
        String result = data;
        for (int i = 0; i < SPECIAL_CHARS_MAP.length; ++i) {
            result = result.replaceAll(SPECIAL_CHARS_MAP[i][0], SPECIAL_CHARS_MAP[i][1]);
        }
        result = result.replaceAll(QUOTE_MAP1[0][0], QUOTE_MAP1[0][1]);
        return result;
    }

    public static String encode2(String data) {
        String result = data;
        for (int i = 0; i < SPECIAL_CHARS_MAP.length; ++i) {
            result = result.replaceAll(SPECIAL_CHARS_MAP[i][0], SPECIAL_CHARS_MAP[i][1]);
        }
        result = result.replaceAll(QUOTE_MAP2[0][0], QUOTE_MAP2[0][1]);
        return result;
    }

    public static String encodeQuote(String data) {
        return data.replaceAll(QUOTE_MAP1[0][0], QUOTE_MAP1[0][1]);
    }
}

