/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.CAM_AAA.authentication.proxy.ParanoidClassLoader;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class CustomProviderProxyAdapter {
    private static ClassLoader providerClassLoader;

    private CustomProviderProxyAdapter() {
        providerClassLoader = null;
    }

    private static URI checkDirectory() {
        File file;
        ICCLConfiguration cfg;
        String path;
        ClassLoader cl = CustomProviderProxyAdapter.class.getClassLoader();
        URI location = null;
        try {
            URL url = cl.getResource("WEB-INF/lib/CAM_AAA_CustomProxy.jar");
            if (url != null) {
                location = url.toURI();
            }
        }
        catch (URISyntaxException url) {
            // empty catch block
        }
        if (location == null && (path = (cfg = CCLConfigurationFactory.getInstance()).resolveEffectivePath("../webapps/p2pd/WEB-INF/lib/CAM_AAA_CustomProxy.jar")) != null && (file = new File(path)).exists()) {
            try {
                location = file.getCanonicalFile().toURI();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return location;
    }

    private static List getURLList(URI location) {
        File webInfDir = new File(location).getParentFile().getParentFile();
        ArrayList<URL> urlList = new ArrayList<URL>();
        File classesDir = new File(webInfDir + "/AAA/classes/");
        File libDir = new File(webInfDir + "/AAA/lib");
        if (classesDir.exists() && classesDir.isDirectory()) {
            try {
                URL dir = classesDir.toURI().toURL();
                urlList.add(dir);
            }
            catch (MalformedURLException dir) {
                // empty catch block
            }
        }
        if (libDir.exists() && libDir.isDirectory()) {
            File[] libraries = libDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            for (int i = 0; i < libraries.length; ++i) {
                try {
                    URL lib = libraries[i].toURI().toURL();
                    urlList.add(lib);
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return urlList;
    }

    public static ClassLoader getProviderClassLoader() {
        if (providerClassLoader != null) {
            return providerClassLoader;
        }
        URI location = CustomProviderProxyAdapter.checkDirectory();
        if (location == null) {
            providerClassLoader = CustomProviderProxyAdapter.class.getClassLoader();
        } else {
            List urlList = CustomProviderProxyAdapter.getURLList(location);
            if (urlList.size() > 0) {
                URL[] urls = urlList.toArray(new URL[urlList.size()]);
                providerClassLoader = new ParanoidClassLoader(urls, CustomProviderProxyAdapter.class.getClassLoader());
            } else {
                providerClassLoader = CustomProviderProxyAdapter.class.getClassLoader();
            }
        }
        return providerClassLoader;
    }
}

