/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.util.Locale;

public final class LocaleUtil {
    private static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final int CONTENT_LOCALE_TYPE = 1;
    private static final int PRODUCT_LOCALE_TYPE = 2;
    private static final int GENERAL_LOCALE_TYPE = 3;

    private LocaleUtil() {
    }

    public static Locale createContentLocale(String theContentLocaleString, Locale defaultLocale) {
        return LocaleUtil.createLocaleObject(1, theContentLocaleString, defaultLocale);
    }

    public static Locale createLocale(String theLocaleString, Locale defaultLocale) {
        return LocaleUtil.createLocaleObject(3, theLocaleString, defaultLocale);
    }

    private static Locale createLocaleObject(int type, String theLocaleString, Locale defaultLocale) {
        Locale locale = null;
        if (theLocaleString != null && theLocaleString.length() > 0) {
            try {
                String normalizedLocaleString = null;
                switch (type) {
                    case 1: {
                        normalizedLocaleString = cclConfig.mapContentLocale(theLocaleString, true);
                        break;
                    }
                    case 2: {
                        normalizedLocaleString = cclConfig.mapProductLocale(theLocaleString, true);
                        break;
                    }
                    default: {
                        normalizedLocaleString = cclConfig.normalizeLocale(theLocaleString);
                    }
                }
                int index = normalizedLocaleString.indexOf("-");
                String language = "";
                String country = "";
                if (index == -1) {
                    language = normalizedLocaleString;
                } else {
                    language = normalizedLocaleString.substring(0, index);
                    country = normalizedLocaleString.substring(index + 1);
                }
                if (language.length() > 0) {
                    locale = new Locale(language, country);
                }
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        if (locale == null) {
            locale = LocaleUtil.createDefaultLocale(defaultLocale);
        }
        return locale;
    }

    private static Locale createDefaultLocale(Locale defaultLocale) {
        Locale retval = null;
        if (defaultLocale != null) {
            try {
                String defaultLocaleString = defaultLocale.getLanguage();
                String defaultNormalizedLocaleString = cclConfig.normalizeLocale(defaultLocaleString);
                retval = new Locale(defaultNormalizedLocaleString, "");
            }
            catch (CCLConfigurationException cCLConfigurationException) {
                // empty catch block
            }
        }
        return retval;
    }

    public static Locale createProductLocale(String theProductLocaleString, Locale defaultLocale) {
        return LocaleUtil.createLocaleObject(2, theProductLocaleString, defaultLocale);
    }
}

