/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class ReadProperties {
    private static final String AAA_PROPERTIES_FILE = "/configuration/AAA.properties";
    private static ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
    private static final String TRACE_SETTIG_TRUE_VALUE = "true";
    private boolean traceException;
    private boolean traceLogic;
    private PrintStream printStream;
    private Properties properties;

    public ReadProperties() {
        this.traceException = false;
        this.traceLogic = false;
        this.printStream = null;
        this.properties = null;
        this.getProperties();
    }

    public ReadProperties(Properties theProperties) {
        this.properties = theProperties;
        this.checkTraceSetting();
    }

    private void getProperties() {
        String installLocaiton = cclConfig.resolveEffectivePath("..");
        File configureFile = new File(installLocaiton + AAA_PROPERTIES_FILE);
        try {
            FileInputStream input = new FileInputStream(configureFile);
            this.properties = new Properties();
            this.properties.load(input);
            this.checkTraceSetting();
        }
        catch (FileNotFoundException input) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkTraceSetting() {
        boolean debugEnabled = this.tracePropertyEnabled("trace.debug");
        if (debugEnabled) {
            this.traceLogic = true;
            this.traceException = true;
        } else {
            this.traceLogic = this.tracePropertyEnabled("trace.debug.logic");
            this.traceException = this.tracePropertyEnabled("trace.debug.exception");
        }
    }

    public String getTraceFileName() throws FileNotFoundException {
        String traceFile = this.properties.getProperty("trace.output");
        return traceFile;
    }

    private void getTraceFileStream() throws FileNotFoundException {
        String traceFile = this.getTraceFileName();
        if (traceFile != null && this.printStream == null) {
            this.printStream = new PrintStream(traceFile);
        }
    }

    private boolean tracePropertyEnabled(String traceProperty) {
        String tracingEnabled = this.properties.getProperty(traceProperty);
        return tracingEnabled != null && tracingEnabled.equalsIgnoreCase(TRACE_SETTIG_TRUE_VALUE);
    }

    public boolean traceLogicEnabled() {
        return this.traceLogic;
    }

    public void logTraceException(Throwable e) {
        if (this.traceException) {
            if (this.printStream == null) {
                try {
                    this.getTraceFileStream();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace(this.printStream);
        }
    }

    public void logTraceLogic(String message) {
        if (this.traceLogic) {
            if (this.printStream == null) {
                try {
                    this.getTraceFileStream();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            this.printStream.println(message);
        }
    }
}

