/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.camaaa.internal.common.util;

import com.ibm.cognos.camaaa.internal.common.util.TimedObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class TimedObjectMap
implements Map {
    private PruningThread pruningThread = new PruningThread();
    private Timer timer;
    private Map map = Collections.synchronizedMap(new HashMap());

    public TimedObjectMap(long freq) {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)this.pruningThread, 0L, freq);
    }

    public void stopExpiry() {
        this.timer.cancel();
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public synchronized Set entrySet() {
        return this.map.entrySet();
    }

    public synchronized Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized Set keySet() {
        return this.map.keySet();
    }

    public synchronized Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    public synchronized void putAll(Map otherMap) {
        this.map.putAll(otherMap);
    }

    public synchronized Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    public synchronized Collection values() {
        return this.map.values();
    }

    private class PruningThread
    extends TimerTask {
        private PruningThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimedObjectMap timedObjectMap = TimedObjectMap.this;
            synchronized (timedObjectMap) {
                if (!TimedObjectMap.this.isEmpty()) {
                    Iterator it = TimedObjectMap.this.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        TimedObject obj = (TimedObject)TimedObjectMap.this.get(key);
                        if (!obj.isExpired()) continue;
                        it.remove();
                        obj.cleanup();
                    }
                }
            }
        }
    }
}

