/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.NextFunction;
import EDU.oswego.cs.dl.util.concurrent.misc.UpdateCommand;
import java.lang.reflect.InvocationTargetException;

abstract class ExecutorRNG
extends DelegatedRNG {
    Executor executor_;
    Runnable delegatedUpdate_ = null;
    Callable delegatedNext_ = null;
    FutureResult nextResult_ = null;

    ExecutorRNG() {
    }

    synchronized void setExecutor(Executor executor) {
        this.executor_ = executor;
    }

    synchronized Executor getExecutor() {
        return this.executor_;
    }

    synchronized Runnable delegatedUpdateCommand() {
        if (this.delegatedUpdate_ == null) {
            this.delegatedUpdate_ = new UpdateCommand(this.getDelegate());
        }
        return this.delegatedUpdate_;
    }

    synchronized Callable delegatedNextFunction() {
        if (this.delegatedNext_ == null) {
            this.delegatedNext_ = new NextFunction(this.getDelegate());
        }
        return this.delegatedNext_;
    }

    @Override
    public void update() {
        try {
            this.getExecutor().execute(this.delegatedUpdateCommand());
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized long next() {
        long l = 0L;
        try {
            if (this.nextResult_ == null) {
                this.nextResult_ = new FutureResult();
                this.nextResult_.set(new Long(this.getDelegate().next()));
            }
            FutureResult futureResult = this.nextResult_;
            this.nextResult_ = new FutureResult();
            Runnable runnable = this.nextResult_.setter(this.delegatedNextFunction());
            this.getExecutor().execute(runnable);
            l = (Long)futureResult.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            throw new Error("Bad Callable?");
        }
        return l;
    }
}

