/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.Slot;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.SemRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times per call in microseconds");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SynchronizationTimer().mainPanel());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static String modeToString(int n) {
        String string = n == 0 ? "block" : (n == 1 ? "timeout" : "No such mode");
        return string;
    }

    static String biasToString(int n) {
        String string = n < 0 ? "slower producer" : (n == 0 ? "balanced prod/cons rate" : (n > 0 ? "slower consumer" : "No such bias"));
        return string;
    }

    static String p2ToString(int n) {
        String string = "";
        if (n >= 1024) {
            string = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                string = "M";
            }
        }
        return n + string;
    }

    static String formatTime(long l, boolean bl) {
        long l2 = l / 10L;
        long l3 = l % 10L;
        if (!bl) {
            if (l3 >= 5L) {
                ++l2;
            }
            return Long.toString(l2);
        }
        String string = Long.toString(l2);
        String string2 = Long.toString(l3);
        if (l3 == 0L) {
            for (int i = 10; i > 10; i /= 10) {
                string2 = "0" + string2;
            }
        }
        String string3 = string + "." + string2;
        return string3;
    }

    boolean threadEnabled(int n) {
        return this.threadInfo[n].getEnabled();
    }

    JPanel resultPanel() {
        JCheckBox jCheckBox;
        int n;
        int n2;
        JPanel[] jPanelArray = new JPanel[this.tableColumns];
        for (int i = 0; i < this.tableColumns; ++i) {
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new GridLayout(this.tableRows, 1));
            if (i == 0) continue;
            jPanelArray[i].setBackground(Color.white);
        }
        Color color = jPanelArray[0].getBackground();
        LineBorder lineBorder = new LineBorder(color);
        Font font = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(40, 16);
        Dimension dimension2 = new Dimension(154, 16);
        JLabel jLabel = new JLabel(" Classes      \\      Threads");
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jLabel.setFont(font);
        this.resultTable_[0][0] = jLabel;
        jPanelArray[0].add(jLabel);
        for (n2 = 1; n2 < this.tableColumns; ++n2) {
            n = n2 - 1;
            jCheckBox = new JCheckBox(this.threadInfo[n].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SynchronizationTimer.this.threadInfo[n].toggleEnabled();
                }
            });
            jCheckBox.setMinimumSize(dimension);
            jCheckBox.setPreferredSize(dimension);
            jCheckBox.setFont(font);
            jCheckBox.setBackground(color);
            this.resultTable_[0][n2] = jCheckBox;
            jPanelArray[n2].add(jCheckBox);
        }
        for (n2 = 1; n2 < this.tableRows; ++n2) {
            n = n2 - 1;
            jCheckBox = new JCheckBox(TestedClass.classes[n].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestedClass.classes[n].toggleEnabled();
                }
            });
            this.resultTable_[n2][0] = jCheckBox;
            jCheckBox.setMinimumSize(dimension2);
            jCheckBox.setPreferredSize(dimension2);
            jCheckBox.setFont(font);
            jPanelArray[0].add(jCheckBox);
            for (int i = 1; i < this.tableColumns; ++i) {
                int n3 = i - 1;
                JLabel jLabel2 = new JLabel("");
                this.resultTable_[n2][i] = jLabel2;
                jLabel2.setMinimumSize(dimension);
                jLabel2.setPreferredSize(dimension);
                jLabel2.setBorder(lineBorder);
                jLabel2.setFont(font);
                jLabel2.setBackground(Color.white);
                jLabel2.setForeground(Color.black);
                jLabel2.setHorizontalAlignment(4);
                jPanelArray[i].add(jLabel2);
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        for (n = 0; n < this.tableColumns; ++n) {
            jPanel.add(jPanelArray[n]);
        }
        return jPanel;
    }

    void setTime(final long l, int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 + 1;
        final JLabel jLabel = (JLabel)this.resultTable_[n3][n4];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jLabel.setText(SynchronizationTimer.formatTime(l, true));
            }
        });
    }

    void clearTable() {
        for (int i = 1; i < this.tableRows; ++i) {
            for (int j = 1; j < this.tableColumns; ++j) {
                ((JLabel)this.resultTable_[i][j]).setText("");
            }
        }
    }

    void setChecks(boolean bl) {
        for (int i = 0; i < TestedClass.classes.length; ++i) {
            TestedClass.classes[i].setEnabled(new Boolean(bl));
            ((JCheckBox)this.resultTable_[i + 1][0]).setSelected(bl);
        }
    }

    public SynchronizationTimer() {
        for (int i = 0; i < this.threadInfo.length; ++i) {
            this.threadInfo[i] = new ThreadInfo(nthreadsChoices[i]);
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel.add(this.startstop_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Continue");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SynchronizationTimer.this.running_.get()) {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Clear cells");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.clearTable();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("All classes");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("No classes");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        jPanel4.add(jButton4);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JCheckBox jCheckBox = new JCheckBox("Console echo");
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel jLabel = new JLabel("Active threads:      0");
        jPanel5.add(jLabel);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        jPanel.add(this.contentionBox());
        jPanel.add(this.itersBox());
        jPanel.add(this.cloopBox());
        jPanel.add(this.barrierBox());
        jPanel.add(this.exchangeBox());
        jPanel.add(this.biasBox());
        jPanel.add(this.capacityBox());
        jPanel.add(this.timeoutBox());
        jPanel.add(this.syncModePanel());
        jPanel.add(this.producerSyncModePanel());
        jPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = this.resultPanel();
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel);
        return jPanel6;
    }

    JComboBox syncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Locks: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.syncMode.set(syncModes[n]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Producers: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.producerMode.set(syncModes[n]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < syncModes.length; ++i) {
            String string = "Consumers: " + SynchronizationTimer.modeToString(syncModes[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.consumerMode.set(syncModes[n]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] fractionArray = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < fractionArray.length; ++i) {
            String string = fractionArray[i].asDouble() * 100.0 + "% contention/sharing";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(fractionArray[n]);
            }
        });
        this.contention_.set(fractionArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox itersBox() {
        final int[] nArray = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " calls per thread per test";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(nArray[n]);
            }
        });
        this.loopsPerTest_.set(nArray[8]);
        jComboBox.setSelectedIndex(8);
        return jComboBox;
    }

    JComboBox cloopBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " computations per call";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.computeLoops.set(nArray[n]);
            }
        });
        RNG.computeLoops.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox barrierBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " iterations per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.itersPerBarrier.set(nArray[n]);
            }
        });
        RNG.itersPerBarrier.set(nArray[13]);
        jComboBox.setSelectedIndex(13);
        return jComboBox;
    }

    JComboBox exchangeBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " max threads per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.exchangeParties.set(nArray[n]);
            }
        });
        RNG.exchangeParties.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox biasBox() {
        final int[] nArray = new int[]{-1, 0, 1};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.biasToString(nArray[i]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.bias.set(nArray[n]);
            }
        });
        RNG.bias.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox capacityBox() {
        final int[] nArray = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < nArray.length; ++i) {
            String string = SynchronizationTimer.p2ToString(nArray[i]) + " element bounded buffers";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                DefaultChannelCapacity.set(nArray[n]);
            }
        });
        DefaultChannelCapacity.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox timeoutBox() {
        final long[] lArray = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 0; i < lArray.length; ++i) {
            String string = lArray[i] + " msec timeouts";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.timeout.set(lArray[n]);
            }
        });
        RNG.timeout.set(lArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    void startPoolStatus(final JLabel jLabel) {
        Runnable runnable = new Runnable(){
            int lastps = 0;

            @Override
            public void run() {
                final int n = Threads.activeThreads.get();
                if (this.lastps != n) {
                    this.lastps = n;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jLabel.setText("Active threads: " + n);
                        }
                    });
                }
            }
        };
        this.timeDaemon.executePeriodically(250L, runnable, false);
    }

    private void runOneTest(Runnable runnable) throws InterruptedException {
        int n = this.testNumber_.get();
        Threads.pool.execute(runnable);
        this.testNumber_.whenNotEqual(n, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception exception) {
                System.out.println("\nException during cancel:\n" + exception);
                return;
            }
        }
    }

    void startTestSeries(Runnable runnable) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(runnable);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ void access$600(SynchronizationTimer synchronizationTimer) {
        synchronizationTimer.endOneTest();
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int n, int n2) {
            this.clsIdx = n;
            this.nthreadsIdx = n2;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        @Override
        public synchronized void run() {
            long l = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = l;
            } else {
                this.endTime_ = l;
            }
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int n, int n2) {
            this.firstclass = n;
            this.firstnthreads = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                Thread.currentThread().setPriority(5);
                try {
                    int n = this.firstnthreads;
                    int n2 = this.firstclass;
                    if (n >= nthreadsChoices.length || n2 >= TestedClass.classes.length) break block10;
                    while (true) {
                        if (SynchronizationTimer.this.threadEnabled(n)) {
                            TestedClass testedClass = TestedClass.classes[n2];
                            int n3 = nthreadsChoices[n];
                            int n4 = SynchronizationTimer.this.loopsPerTest_.get();
                            Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                            if (testedClass.isEnabled(n3, fraction)) {
                                SynchronizationTimer.this.runOneTest(new OneTest(n2, n));
                            }
                        }
                        if (++n2 >= TestedClass.classes.length) {
                            n2 = 0;
                            if (++n >= nthreadsChoices.length) {
                                break;
                            }
                        }
                        SynchronizationTimer.this.nextClassIdx_.set(n2);
                        SynchronizationTimer.this.nextThreadIdx_.set(n);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    SynchronizationTimer.this.endTestSeries();
                }
            }
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        @Override
        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int n) {
            this.number = n;
            this.name = SynchronizationTimer.p2ToString(n);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy = new TestedClass("", null, false, false);
        static final TestedClass[] classes = new TestedClass[]{new TestedClass("NoSynchronization", NoSynchRNG.class, false, true), new TestedClass("PublicSynchronization", PublicSynchRNG.class, true, true), new TestedClass("NestedSynchronization", AllSynchRNG.class, true, true), new TestedClass("SDelegated", SDelegatedRNG.class, true, true), new TestedClass("SynchLongUsingSet", SynchLongRNG.class, true, true), new TestedClass("SynchLongUsingCommit", AClongRNG.class, true, true), new TestedClass("Semaphore", SemRNG.class, true, true), new TestedClass("WaiterPrefSemaphore", WpSemRNG.class, true, true), new TestedClass("FIFOSemaphore", FifoRNG.class, true, true), new TestedClass("PrioritySemaphore", PrioritySemRNG.class, true, true), new TestedClass("Mutex", MutexRNG.class, true, true), new TestedClass("ReentrantLock", RlockRNG.class, true, true), new TestedClass("WriterPrefRWLock", WpRWlockRNG.class, true, true), new TestedClass("ReaderPrefRWLock", ReaderPrefRWlockRNG.class, true, true), new TestedClass("FIFORWLock", FIFORWlockRNG.class, true, true), new TestedClass("ReentrantRWL", ReentrantRWlockRNG.class, true, true), new TestedClass("LinkedQueue", ChanRNG.class, true, true, LinkedQueue.class), new TestedClass("WaitFreeQueue", ChanRNG.class, true, true, WaitFreeQueue.class), new TestedClass("BoundedLinkedQueue", ChanRNG.class, true, true, BoundedLinkedQueue.class), new TestedClass("BoundedBuffer", ChanRNG.class, true, true, BoundedBuffer.class), new TestedClass("CondVarBoundedBuffer", ChanRNG.class, true, true, CVBuffer.class), new TestedClass("BoundedPriorityQueue", ChanRNG.class, true, true, BoundedPriorityQueue.class), new TestedClass("Slot", ChanRNG.class, true, true, Slot.class), new TestedClass("SynchronousChannel", ChanRNG.class, true, false, SynchronousChannel.class), new TestedClass("DirectExecutor", DirectExecutorRNG.class, true, true), new TestedClass("SemaphoreLckExecutor", LockedSemRNG.class, true, true), new TestedClass("QueuedExecutor", QueuedExecutorRNG.class, true, true), new TestedClass("ThreadedExecutor", ThreadedExecutorRNG.class, true, true), new TestedClass("PooledExecutor", PooledExecutorRNG.class, true, true)};

        synchronized void setEnabled(Boolean bl) {
            this.enabled_ = bl;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean bl = this.enabled_;
            this.enabled_ = new Boolean(!bl);
        }

        synchronized boolean isEnabled(int n, Fraction fraction) {
            boolean bl = this.enabled_;
            if (!bl) {
                return false;
            }
            if (!this.singleOK && n <= 1) {
                return false;
            }
            return this.multipleOK || n <= 1 || fraction.compareTo(0L) <= 0;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = null;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2, Class clazz2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = clazz2;
        }
    }
}

